/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts.configform;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsActivator;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsConnectionImpl;
import net.java.sip.communicator.impl.googlecontacts.configform.Resources;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsConnection;

public class AccountSettingsForm
extends SIPCommDialog
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private JTextField nameField;
    private JTextField prefixField;
    private JButton saveBtn = new JButton(Resources.getString("impl.googlecontacts.SAVE"));
    private JButton cancelBtn = new JButton(Resources.getString("impl.googlecontacts.CANCEL"));
    private int retCode = 0;
    private GoogleContactsConnectionImpl cnx = null;

    public AccountSettingsForm() {
        this.setTitle(Resources.getString("impl.googlecontacts.CONFIG_FORM_TITLE"));
        this.getContentPane().add(this.getContentPanel());
        this.setMinimumSize(new Dimension(400, 200));
        this.setSize(new Dimension(400, 400));
        this.setPreferredSize(new Dimension(400, 200));
        this.pack();
    }

    public JPanel getContentPanel() {
        TransparentPanel contentPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel mainPanel = new TransparentPanel();
        TransparentPanel basePanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        TransparentPanel btnPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        BoxLayout boxLayout = new BoxLayout((Container)mainPanel, 1);
        GridBagConstraints c = new GridBagConstraints();
        JLabel nameLabel = new JLabel(Resources.getString("impl.googlecontacts.ACCOUNT_NAME"));
        this.nameField = new JTextField();
        nameLabel.setLabelFor(this.nameField);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)nameLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.nameField, c);
        JLabel nameExampleLabel = new JLabel("myaccount@gmail.com");
        nameExampleLabel.setForeground(Color.GRAY);
        nameExampleLabel.setFont(nameExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)nameExampleLabel, c);
        JLabel prefixLabel = new JLabel(Resources.getString("service.gui.PREFIX"));
        this.prefixField = new JTextField();
        prefixLabel.setLabelFor(this.prefixField);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)prefixLabel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.prefixField, c);
        mainPanel.setLayout(boxLayout);
        mainPanel.add((Component)basePanel);
        this.nameField.addActionListener(this);
        this.saveBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        btnPanel.add(this.saveBtn);
        btnPanel.add(this.cancelBtn);
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.add((Component)btnPanel, "South");
        return contentPanel;
    }

    public void loadData(GoogleContactsConnection cnx) {
        if (cnx != null) {
            this.nameField.setText(cnx.getLogin());
            this.prefixField.setText(cnx.getPrefix());
            this.cnx = (GoogleContactsConnectionImpl)cnx;
        } else {
            this.nameField.setText("");
            this.cnx = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.saveBtn) {
            String login = this.nameField.getText();
            String prefix = this.prefixField.getText();
            if (this.cnx == null) {
                this.cnx = (GoogleContactsConnectionImpl)GoogleContactsActivator.getGoogleContactsService().getConnection(login);
            } else {
                this.cnx.setLogin(login);
            }
            this.cnx.setPrefix(prefix);
            if (this.cnx.connect() == GoogleContactsConnection.ConnectionStatus.ERROR_INVALID_CREDENTIALS) {
                JOptionPane.showMessageDialog((Component)((Object)this), Resources.getString("impl.googlecontacts.WRONG_CREDENTIALS", new String[]{login}), Resources.getString("impl.googlecontacts.WRONG_CREDENTIALS", new String[]{login}), 2);
                return;
            }
            this.retCode = 1;
            this.dispose();
        } else if (src == this.cancelBtn) {
            this.retCode = 0;
            this.dispose();
        }
    }

    public GoogleContactsConnection getConnection() {
        return this.cnx;
    }

    protected void close(boolean escaped) {
        this.cancelBtn.doClick();
    }

    public int showDialog() {
        this.retCode = 0;
        this.setVisible(true);
        this.setVisible(false);
        return this.retCode;
    }

    public void setNameFieldEnabled(boolean enable) {
        this.nameField.setEnabled(enable);
    }
}

