/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.credentialsstorage;

import junit.framework.TestCase;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.slick.credentialsstorage.CredentialsStorageServiceLick;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TestCredentialsStorageService
extends TestCase {
    private CredentialsStorageService credentialsService = null;
    private static final String accountPrefix = "my.account.prefix";
    private static final String accountPassword = "pa$$W0rt123.";
    private static final String masterPassword = "MasterPazz321";
    private static final String otherMasterPassword = "123$ecretPSWRD";

    public TestCredentialsStorageService(String name) {
        super(name);
        BundleContext context = CredentialsStorageServiceLick.bc;
        ServiceReference ref = context.getServiceReference(CredentialsStorageService.class.getName());
        this.credentialsService = (CredentialsStorageService)context.getService(ref);
    }

    protected void setUp() throws Exception {
        boolean passSet = this.credentialsService.changeMasterPassword(null, masterPassword);
        if (!passSet) {
            throw new Exception("Failed to set the master password");
        }
        this.credentialsService.storePassword(accountPrefix, accountPassword);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        boolean passRemoved = this.credentialsService.changeMasterPassword(masterPassword, null);
        if (!passRemoved) {
            throw new Exception("Failed to remove the master password");
        }
        this.credentialsService.removePassword(accountPrefix);
    }

    public void testIsVerified() {
        boolean verify1 = this.credentialsService.verifyMasterPassword(otherMasterPassword);
        TestCredentialsStorageService.assertFalse((String)"Wrong password cannot be correct", (boolean)verify1);
        boolean verify2 = this.credentialsService.verifyMasterPassword(masterPassword);
        TestCredentialsStorageService.assertTrue((String)"Correct password cannot be wrong", (boolean)verify2);
    }

    public void testLoadPassword() {
        String loadedPassword = this.credentialsService.loadPassword(accountPrefix);
        TestCredentialsStorageService.assertEquals((String)"Loaded and stored passwords do not match", (String)accountPassword, (String)loadedPassword);
    }

    public void testIsUsingMasterPassword() {
        boolean isUsing = this.credentialsService.isUsingMasterPassword();
        TestCredentialsStorageService.assertTrue((String)"Master password is used, true expected", (boolean)isUsing);
    }

    public void testChangeMasterPassword() {
        boolean change1 = this.credentialsService.changeMasterPassword(masterPassword, otherMasterPassword);
        TestCredentialsStorageService.assertTrue((String)"Changing master password failed", (boolean)change1);
        String loadedPassword = this.credentialsService.loadPassword(accountPrefix);
        TestCredentialsStorageService.assertEquals((String)"Account passwords must not differ", (String)loadedPassword, (String)accountPassword);
        boolean change2 = this.credentialsService.changeMasterPassword(otherMasterPassword, masterPassword);
        TestCredentialsStorageService.assertTrue((String)"Changing master password back failed", (boolean)change2);
    }

    public void testIsStoredEncrypted() {
        boolean storedEncrypted = this.credentialsService.isStoredEncrypted(accountPrefix);
        TestCredentialsStorageService.assertTrue((String)"Account password is not stored encrypted", (boolean)storedEncrypted);
    }

    public void testRemoveSavedPassword() {
        this.credentialsService.removePassword(accountPrefix);
        String loadedPassword = this.credentialsService.loadPassword(accountPrefix);
        TestCredentialsStorageService.assertNull((String)"Password was not removed", (Object)loadedPassword);
        this.credentialsService.storePassword(accountPrefix, accountPassword);
    }
}

