/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.dnsconfig;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.dnsconfig.DnsConfigActivator;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class ParallelDnsPanel
extends TransparentPanel
implements ActionListener,
ChangeListener,
FocusListener,
PropertyChangeListener {
    private static final long serialVersionUID = 4393128042592738855L;
    private JCheckBox chkBackupDnsEnabled;
    private JLabel lblBackupPort;
    private JLabel lblBackupResolver;
    private JLabel lblBackupResolverFallbackIP;
    private JLabel lblPatience;
    private JLabel lblRedemption;
    private JSpinner spnBackupResolverPort;
    private JSpinner spnDnsRedemption;
    private JSpinner spnDnsTimeout;
    private JTextField txtBackupResolver;
    private JFormattedTextField txtBackupResolverFallbackIP;
    private ResourceManagementService R;
    private ConfigurationService configService;

    public ParallelDnsPanel() {
        this.initServices();
        this.initComponents();
        this.loadData();
        this.initBehavior();
    }

    private void initServices() {
        BundleContext bc = DnsConfigActivator.bundleContext;
        this.R = (ResourceManagementService)ServiceUtils.getService((BundleContext)bc, ResourceManagementService.class);
        this.configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bc, ConfigurationService.class);
    }

    private void initComponents() {
        this.chkBackupDnsEnabled = new SIPCommCheckBox();
        this.spnDnsTimeout = new JSpinner(new SpinnerNumberModel(0, 0, 30000, 100));
        this.spnDnsRedemption = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        this.spnBackupResolverPort = new JSpinner(new SpinnerNumberModel(0, 0, 65536, 1));
        this.txtBackupResolverFallbackIP = new JFormattedTextField(this.createIPFormatter());
        this.lblRedemption = new JLabel();
        this.txtBackupResolver = new JTextField();
        this.lblBackupResolver = new JLabel();
        this.lblBackupPort = new JLabel();
        this.lblBackupResolverFallbackIP = new JLabel();
        this.lblPatience = new JLabel();
        this.chkBackupDnsEnabled.setText(this.R.getI18NString("plugin.dnsconfig.chkBackupDnsEnabled.text"));
        this.lblRedemption.setText(this.R.getI18NString("plugin.dnsconfig.lblRedemption.text"));
        this.lblBackupResolver.setText(this.R.getI18NString("plugin.dnsconfig.lblBackupResolver.text"));
        this.lblBackupPort.setText(this.R.getI18NString("plugin.dnsconfig.lblBackupPort.text"));
        this.lblBackupResolverFallbackIP.setText(this.R.getI18NString("plugin.dnsconfig.lblBackupResolverFallbackIP.text"));
        this.lblPatience.setText(this.R.getI18NString("plugin.dnsconfig.lblPatience.text"));
        this.setLayout(new BorderLayout());
        TransparentPanel mainPanel = new TransparentPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder(this.R.getI18NString("plugin.dnsconfig.border.TITLE")));
        GridBagConstraints cl = new GridBagConstraints();
        GridBagConstraints cr = new GridBagConstraints();
        this.chkBackupDnsEnabled.setAlignmentX(0.0f);
        TransparentPanel enablePanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
        enablePanel.add(this.chkBackupDnsEnabled);
        this.add((Component)enablePanel, "North");
        TransparentPanel centerPanel = new TransparentPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)mainPanel, "North");
        this.add((Component)centerPanel, "Center");
        cl.fill = 2;
        cl.gridx = 0;
        cl.gridy = 0;
        cl.insets = new Insets(0, 3, 0, 0);
        mainPanel.add((Component)this.lblBackupResolver, cl);
        cr.fill = 2;
        cr.anchor = 17;
        cr.insets = new Insets(0, 3, 0, 3);
        cr.weightx = 1.0;
        cr.gridx = 1;
        cr.gridy = 0;
        mainPanel.add((Component)this.txtBackupResolver, cr);
        cl.gridy = 1;
        cl.insets = new Insets(5, 3, 0, 0);
        cr.gridy = 1;
        cr.insets = new Insets(5, 3, 0, 3);
        mainPanel.add((Component)this.lblBackupResolverFallbackIP, cl);
        mainPanel.add((Component)this.txtBackupResolverFallbackIP, cr);
        cl.gridy = 2;
        cr.gridy = 2;
        mainPanel.add((Component)this.lblBackupPort, cl);
        mainPanel.add((Component)this.spnBackupResolverPort, cr);
        cl.gridy = 3;
        cr.gridy = 3;
        mainPanel.add((Component)this.lblPatience, cl);
        mainPanel.add((Component)this.spnDnsTimeout, cr);
        String label = this.R.getI18NString("plugin.dnsconfig.lblPatience.description");
        JLabel descriptionLabel = new JLabel(label);
        descriptionLabel.setToolTipText(label);
        descriptionLabel.setForeground(Color.GRAY);
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(11.0f));
        cr.gridy = 4;
        mainPanel.add((Component)descriptionLabel, cr);
        cl.gridy = 5;
        cr.gridy = 5;
        mainPanel.add((Component)this.lblRedemption, cl);
        mainPanel.add((Component)this.spnDnsRedemption, cr);
        label = this.R.getI18NString("plugin.dnsconfig.lblRedemption.description");
        descriptionLabel = new JLabel(label);
        descriptionLabel.setToolTipText(label);
        descriptionLabel.setForeground(Color.GRAY);
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(11.0f));
        cr.gridy = 6;
        cr.insets = new Insets(5, 3, 3, 3);
        mainPanel.add((Component)descriptionLabel, cr);
    }

    public void updateDnssecState() {
        boolean isDnssec = this.configService.getBoolean("net.java.sip.communicator.util.dns.DNSSEC_ENABLED", false);
        if (isDnssec) {
            this.chkBackupDnsEnabled.setSelected(false);
        }
        this.chkBackupDnsEnabled.setEnabled(!isDnssec);
        this.updateButtonsState();
    }

    private void updateButtonsState() {
        this.txtBackupResolver.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.lblBackupResolver.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.txtBackupResolverFallbackIP.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.lblBackupResolverFallbackIP.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.txtBackupResolverFallbackIP.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.lblBackupResolverFallbackIP.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.spnBackupResolverPort.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.lblBackupPort.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.spnDnsTimeout.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.lblPatience.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.spnDnsRedemption.setEnabled(this.chkBackupDnsEnabled.isSelected());
        this.lblRedemption.setEnabled(this.chkBackupDnsEnabled.isSelected());
    }

    private void initBehavior() {
        this.chkBackupDnsEnabled.addActionListener(this);
        this.txtBackupResolver.addActionListener(this);
        this.txtBackupResolver.addFocusListener(this);
        this.txtBackupResolverFallbackIP.addPropertyChangeListener("value", this);
        this.spnBackupResolverPort.addChangeListener(this);
        this.spnDnsTimeout.addChangeListener(this);
        this.spnDnsRedemption.addChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.saveProperty(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.saveProperty(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.saveProperty(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    private void saveProperty(EventObject e) {
        if (e.getSource() == this.chkBackupDnsEnabled) {
            boolean enabled = this.chkBackupDnsEnabled.isSelected();
            this.configService.setProperty("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_ENABLED", (Object)enabled);
            this.updateButtonsState();
        } else if (e.getSource() == this.txtBackupResolver) {
            this.configService.setProperty("net.java.sip.communicator.util.dns.BACKUP_RESOLVER", (Object)this.txtBackupResolver.getText());
        } else if (e.getSource() == this.spnBackupResolverPort) {
            this.configService.setProperty("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_PORT", (Object)this.spnBackupResolverPort.getValue().toString());
        } else if (e.getSource() == this.spnDnsTimeout) {
            this.configService.setProperty("net.java.sip.communicator.util.dns.DNS_PATIENCE", (Object)this.spnDnsTimeout.getValue().toString());
        } else if (e.getSource() == this.spnDnsRedemption) {
            this.configService.setProperty("net.java.sip.communicator.util.dns.DNS_REDEMPTION", (Object)this.spnDnsRedemption.getValue().toString());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.txtBackupResolverFallbackIP) {
            this.configService.setProperty("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_FALLBACK_IP", (Object)this.txtBackupResolverFallbackIP.getValue().toString());
        }
    }

    private DefaultFormatter createIPFormatter() {
        return new DefaultFormatter(){

            @Override
            public Object stringToValue(String string) throws ParseException {
                if (NetworkUtils.isIPv4Address((String)string) || NetworkUtils.isIPv6Address((String)string)) {
                    return super.stringToValue(string);
                }
                throw new ParseException("Not a valid literal IP address", 0);
            }
        };
    }

    private void loadData() {
        this.chkBackupDnsEnabled.setSelected(this.configService.getBoolean("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_ENABLED", true));
        this.txtBackupResolver.setText(this.configService.getString("net.java.sip.communicator.util.dns.BACKUP_RESOLVER", "backup-resolver.jitsi.net"));
        this.txtBackupResolverFallbackIP.setValue(this.configService.getString("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_FALLBACK_IP", this.R.getSettingsString("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_FALLBACK_IP")));
        this.spnBackupResolverPort.setValue(this.configService.getInt("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_PORT", 53));
        this.spnDnsTimeout.setValue(this.configService.getInt("net.java.sip.communicator.util.dns.DNS_PATIENCE", 1500));
        this.spnDnsRedemption.setValue(this.configService.getInt("net.java.sip.communicator.util.dns.DNS_REDEMPTION", 3));
        this.updateButtonsState();
    }
}

