/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.icqaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.TrimTextField;
import net.java.sip.communicator.plugin.icqaccregwizz.IcqAccRegWizzActivator;
import net.java.sip.communicator.plugin.icqaccregwizz.IcqAccountRegistration;
import net.java.sip.communicator.plugin.icqaccregwizz.IcqAccountRegistrationWizard;
import net.java.sip.communicator.plugin.icqaccregwizz.Resources;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class FirstWizardPage
extends TransparentPanel
implements WizardPage,
DocumentListener,
ActionListener {
    private static final long serialVersionUID = 0L;
    public static final String FIRST_PAGE_IDENTIFIER = "FirstPageIdentifier";
    public static final String USER_NAME_EXAMPLE = "Ex: 83378997";
    private JPanel uinPassPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel labelsPanel = new TransparentPanel();
    private JPanel valuesPanel = new TransparentPanel();
    private JLabel uinLabel = new JLabel(Resources.getString("plugin.icqaccregwizz.USERNAME"));
    private JPanel emptyPanel = new TransparentPanel();
    private JLabel uinExampleLabel = new JLabel("Ex: 83378997");
    private JLabel passLabel = new JLabel(Resources.getString("service.gui.PASSWORD"));
    private JTextField uinField = new TrimTextField();
    private JPasswordField passField = new JPasswordField();
    private JCheckBox rememberPassBox = new SIPCommCheckBox(Resources.getString("service.gui.REMEMBER_PASSWORD"));
    private JPanel registerPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private JPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
    private JTextArea registerArea = new JTextArea(Resources.getString("plugin.icqaccregwizz.REGISTER_NEW_ACCOUNT_TEXT"));
    private JButton registerButton = new JButton(Resources.getString("plugin.icqaccregwizz.REGISTER_NEW_ACCOUNT"));
    private JPanel mainPanel = new TransparentPanel();
    private Object nextPageIdentifier = "SUMMARY";
    private IcqAccountRegistrationWizard wizard;
    private boolean isCommitted = false;

    public FirstWizardPage(IcqAccountRegistrationWizard wizard) {
        super((LayoutManager)new BorderLayout());
        this.wizard = wizard;
        this.setPreferredSize(new Dimension(600, 500));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.init();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.labelsPanel.setLayout(new BoxLayout(this.labelsPanel, 1));
        this.valuesPanel.setLayout(new BoxLayout(this.valuesPanel, 1));
    }

    private void init() {
        this.mainPanel.setOpaque(false);
        this.labelsPanel.setOpaque(false);
        this.valuesPanel.setOpaque(false);
        this.uinPassPanel.setOpaque(false);
        this.emptyPanel.setOpaque(false);
        this.registerButton.addActionListener(this);
        this.uinField.getDocument().addDocumentListener(this);
        this.rememberPassBox.setSelected(true);
        this.uinExampleLabel.setForeground(Color.GRAY);
        this.uinExampleLabel.setFont(this.uinExampleLabel.getFont().deriveFont(8));
        this.emptyPanel.setMaximumSize(new Dimension(40, 35));
        this.uinExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.labelsPanel.add(this.uinLabel);
        this.labelsPanel.add(this.emptyPanel);
        this.labelsPanel.add(this.passLabel);
        this.valuesPanel.add(this.uinField);
        this.valuesPanel.add(this.uinExampleLabel);
        this.valuesPanel.add(this.passField);
        this.uinPassPanel.add((Component)this.labelsPanel, "West");
        this.uinPassPanel.add((Component)this.valuesPanel, "Center");
        this.uinPassPanel.add((Component)this.rememberPassBox, "South");
        this.uinPassPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.aimaccregwizz.USERNAME_AND_PASSWORD")));
        this.mainPanel.add(this.uinPassPanel);
        this.buttonPanel.add(this.registerButton);
        this.registerArea.setEditable(false);
        this.registerArea.setLineWrap(true);
        this.registerArea.setWrapStyleWord(true);
        this.registerArea.setOpaque(false);
        this.registerPanel.add(this.registerArea);
        this.registerPanel.add(this.buttonPanel);
        this.registerPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.aimaccregwizz.REGISTER_NEW_ACCOUNT")));
        this.mainPanel.add(this.registerPanel);
        this.add(this.mainPanel, "North");
    }

    public Object getIdentifier() {
        return FIRST_PAGE_IDENTIFIER;
    }

    public Object getNextPageIdentifier() {
        return this.nextPageIdentifier;
    }

    public Object getBackPageIdentifier() {
        return null;
    }

    public Object getWizardForm() {
        return this;
    }

    public void pageShowing() {
        this.setNextButtonAccordingToUIN();
    }

    public void commitPage() {
        String uin = this.uinField.getText();
        IcqAccountRegistration registration = this.wizard.getRegistration();
        if (uin == null || uin.trim().length() == 0) {
            throw new IllegalStateException("No UIN provided.");
        }
        registration.setUin(uin);
        registration.setPassword(new String(this.passField.getPassword()));
        registration.setRememberPassword(this.rememberPassBox.isSelected());
        this.nextPageIdentifier = "SUMMARY";
        this.isCommitted = true;
    }

    private void setNextButtonAccordingToUIN() {
        if (this.uinField.getText() == null || this.uinField.getText().equals("")) {
            this.wizard.getWizardContainer().setNextFinishButtonEnabled(false);
        } else {
            this.wizard.getWizardContainer().setNextFinishButtonEnabled(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setNextButtonAccordingToUIN();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setNextButtonAccordingToUIN();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void pageHiding() {
    }

    public void pageShown() {
    }

    public void pageBack() {
    }

    public void loadAccount(ProtocolProviderService protocolProvider) {
        AccountID accountID = protocolProvider.getAccountID();
        String password = IcqAccRegWizzActivator.getIcqProtocolProviderFactory().loadPassword(accountID);
        this.uinField.setText(accountID.getUserID());
        this.uinField.setEnabled(false);
        if (password != null) {
            this.passField.setText(password);
            this.rememberPassBox.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.wizard.webSignup();
    }

    public Object getSimpleForm() {
        return this.uinPassPanel;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }
}

