/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Timer;

public class AnimatedImage
extends BufferedImage
implements ActionListener {
    private static final int DEFAULT_DELAY = 500;
    private static final int DEFAULT_CYCLES = -1;
    private List<Image> images = new ArrayList<Image>();
    private JComponent component;
    private int cycles;
    private boolean showFirstImage = false;
    private int imageWidth;
    private int imageHeight;
    private int currentImageIndex;
    private int cyclesCompleted;
    private boolean animationFinished = true;
    private Timer timer;
    private final Graphics2D g2d;

    public AnimatedImage(JComponent component, Image ... images) {
        this(component, 500, images);
    }

    public AnimatedImage(JComponent component, int delay, Image ... images) {
        this(component, delay, -1, images);
    }

    public AnimatedImage(JComponent component, int delay, int cycles, Image ... images) {
        super(images[0].getWidth(null), images[0].getHeight(null), 2);
        this.component = component;
        this.g2d = (Graphics2D)this.getGraphics();
        this.setCycles(cycles);
        for (int i = 0; i < images.length; ++i) {
            if (images[i] == null) {
                throw new IllegalArgumentException("Images can not be null");
            }
            this.addImage(images[i]);
        }
        this.timer = new Timer(delay, this);
    }

    public void addImage(Image image) {
        if (image != null) {
            this.images.add(image);
            this.calculateImageDimensions();
        }
    }

    private void calculateImageDimensions() {
        this.imageWidth = 0;
        this.imageHeight = 0;
        for (Image image : this.images) {
            this.imageWidth = Math.max(this.imageWidth, image.getWidth(null));
            this.imageHeight = Math.max(this.imageHeight, image.getHeight(null));
        }
    }

    public int getCurrentImageIndex() {
        return this.currentImageIndex;
    }

    public void setCurrentImageIndex(int index) {
        this.currentImageIndex = index;
        AlphaComposite ac = AlphaComposite.getInstance(2);
        this.g2d.setComposite(ac);
        this.g2d.drawImage(this.getImage(this.currentImageIndex), 0, 0, this.component);
        this.component.repaint();
    }

    public int getRemainingCycles() {
        return this.cycles;
    }

    public void setCycles(int cycles) {
        this.cycles = cycles;
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    public Image getImage(int index) {
        return this.images.get(index);
    }

    public int getImagesCount() {
        return this.images.size();
    }

    public boolean isShowFirstImage() {
        return this.showFirstImage;
    }

    public void setShowFirstImage(boolean showFirstImage) {
        this.showFirstImage = showFirstImage;
    }

    public void pause() {
        this.timer.stop();
    }

    public void start() {
        if (!this.timer.isRunning()) {
            this.setCurrentImageIndex(0);
            this.animationFinished = false;
            this.cyclesCompleted = 0;
            this.timer.start();
        }
    }

    public void restart() {
        if (!this.timer.isRunning()) {
            if (this.animationFinished) {
                this.start();
            } else {
                this.timer.restart();
            }
        }
    }

    public void stop() {
        this.timer.stop();
        this.setCurrentImageIndex(0);
        this.animationFinished = true;
    }

    @Override
    public int getWidth(ImageObserver obs) {
        return this.imageWidth;
    }

    @Override
    public int getHeight(ImageObserver obs) {
        return this.imageHeight;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setCurrentImageIndex(this.getNextImageIndex(this.currentImageIndex, this.images.size()));
        if (this.isCycleCompleted(this.currentImageIndex, this.images.size())) {
            ++this.cyclesCompleted;
        }
        if (this.cycles > 0 && this.cycles <= this.cyclesCompleted) {
            this.timer.stop();
            this.animationFinished = true;
            if (this.isShowFirstImage() && this.getCurrentImageIndex() != 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(AnimatedImage.this.timer.getDelay());
                            AnimatedImage.this.setCurrentImageIndex(0);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }).start();
            }
        }
    }

    protected int getNextImageIndex(int currentIndex, int imageCount) {
        return ++currentIndex % imageCount;
    }

    protected boolean isCycleCompleted(int currentIndex, int imageCount) {
        return currentIndex == imageCount - 1;
    }
}

