/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public class FramedImage
extends JComponent
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private Image frameImage;
    private ImageIcon icon;
    protected final int width;
    protected final int height;

    public FramedImage(ImageIcon imageIcon, int width, int height) {
        this.width = width;
        this.height = height;
        this.setPreferredSize(new Dimension(width, height));
        this.loadSkin();
        if (imageIcon != null) {
            this.icon = this.getScaledImage(imageIcon.getImage());
        }
    }

    public FramedImage(int width, int height) {
        this(null, width, height);
    }

    public void setImageIcon(byte[] image) {
        this.icon = this.getScaledImage(image);
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setImageIcon(Image image) {
        this.icon = this.getScaledImage(image);
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public Image getImage() {
        if (this.icon != null) {
            return this.icon.getImage();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.icon != null) {
            int imageWidth = this.icon.getIconWidth();
            int imageHeight = this.icon.getIconHeight();
            if (imageWidth != -1 && imageHeight != -1) {
                g.drawImage(this.icon.getImage(), this.width / 2 - imageWidth / 2, this.height / 2 - imageHeight / 2, null);
            }
        }
        if (this.frameImage != null) {
            int frameWidth = this.frameImage.getWidth(this);
            int frameHeight = this.frameImage.getHeight(this);
            if (frameWidth != -1 && frameHeight != -1) {
                g.drawImage(this.frameImage, this.width / 2 - frameWidth / 2, this.height / 2 - frameHeight / 2, null);
            }
        }
    }

    public void loadSkin() {
        ImageIcon frameIcon = DesktopUtilActivator.getResources().getImage("service.gui.USER_PHOTO_FRAME");
        if (frameIcon.getIconWidth() >= this.width && frameIcon.getIconHeight() >= frameIcon.getIconHeight()) {
            this.frameImage = ImageUtils.scaleImageWithinBounds(frameIcon.getImage(), this.width, this.height);
        }
    }

    private ImageIcon getScaledImage(Image image) {
        return ImageUtils.getScaledRoundedIcon(image, this.width - 2, this.height - 2);
    }

    private ImageIcon getScaledImage(byte[] image) {
        return ImageUtils.getScaledRoundedIcon(image, this.width - 2, this.height - 2);
    }
}

