/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileFilter;
import org.jitsi.util.OSUtils;

public class SipCommFileDialogImpl
extends FileDialog
implements SipCommFileChooser {
    private static final long serialVersionUID = 0L;
    private int selectionMode = 0;

    public SipCommFileDialogImpl(Frame parent, String title) {
        super(parent, title);
    }

    public SipCommFileDialogImpl(Frame parent, String title, int fileOperation) {
        super(parent, title, fileOperation);
    }

    @Override
    public File getApprovedFile() {
        String file = this.getFile();
        return file != null ? new File(this.getDirectory(), file) : null;
    }

    @Override
    public void setStartPath(String path) {
        if (path == null) {
            return;
        }
        try {
            URL url = new URL(path);
            path = url.getPath();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        File file = new File(path);
        if (file != null && !file.isDirectory()) {
            this.setDirectory(file.getParent());
            this.setFile(file.getName());
        } else {
            this.setDirectory(path);
            this.setFile(null);
        }
    }

    @Override
    public File getFileFromDialog() {
        this.setVisible(true);
        return this.getApprovedFile();
    }

    @Override
    public void addFilter(SipCommFileFilter filter) {
        this.setFilenameFilter(filter);
    }

    @Override
    public void setFileFilter(SipCommFileFilter filter) {
        this.setFilenameFilter(filter);
    }

    @Override
    public SipCommFileFilter getUsedFilter() {
        return (SipCommFileFilter)this.getFilenameFilter();
    }

    @Override
    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    @Override
    public void setVisible(boolean b) {
        if (OSUtils.IS_MAC && this.selectionMode == 1) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        super.setVisible(b);
        if (OSUtils.IS_MAC && this.selectionMode == 1) {
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
        }
    }
}

