/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.plaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommTextFieldUI
extends MetalTextFieldUI
implements Skinnable,
MouseMotionListener,
MouseListener {
    protected boolean isDeleteMouseOver = false;
    protected boolean isDeleteMousePressed = false;
    protected static int BUTTON_GAP = 5;
    private Image deleteButtonImg;
    private Image deleteButtonRolloverImg;
    private Image deleteButtonPressedImg;
    private boolean isDeleteButtonEnabled = false;
    protected SIPCommButton deleteButton;
    private boolean isDeleteIconVisible = false;
    private Color bgStartColor = new Color(DesktopUtilActivator.getResources().getColor("service.gui.SEARCH_BACKGROUND"));
    private Color bgEndColor = new Color(DesktopUtilActivator.getResources().getColor("service.gui.SEARCH_GRADIENT"));
    private Color bgBorderStartColor = new Color(DesktopUtilActivator.getResources().getColor("service.gui.SEARCH_BORDER"));
    private Color bgBorderEndColor = new Color(DesktopUtilActivator.getResources().getColor("service.gui.SEARCH_BORDER_GRADIENT"));

    public SIPCommTextFieldUI() {
        this.loadSkin();
    }

    public boolean isDeleteButtonEnabled() {
        return this.isDeleteButtonEnabled;
    }

    public void setDeleteButtonEnabled(boolean isDeleteButtonEnabled) {
        this.isDeleteButtonEnabled = isDeleteButtonEnabled;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addMouseListener(this);
        this.getComponent().addMouseMotionListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this);
        this.getComponent().removeMouseMotionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void customPaintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            String roundedSet = DesktopUtilActivator.getResources().getSettingsString("impl.gui.IS_SIP_COMM_TEXT_FIELD_ROUNDED");
            boolean isRounded = true;
            if (roundedSet != null) {
                isRounded = new Boolean(roundedSet);
            }
            AntialiasingManager.activateAntialiasing(g2);
            JTextComponent c = this.getComponent();
            GradientPaint bgGradientColor = new GradientPaint(c.getWidth() / 2, 0.0f, this.bgStartColor, c.getWidth() / 2, c.getHeight(), this.bgEndColor);
            g2.setPaint(bgGradientColor);
            if (isRounded) {
                g2.fillRoundRect(1, 1, c.getWidth() - 1, c.getHeight() - 1, 8, 8);
            } else {
                g2.fillRect(1, 1, c.getWidth() - 1, c.getHeight() - 1);
            }
            Rectangle deleteButtonRect = this.getDeleteButtonRect();
            if (deleteButtonRect != null) {
                int dx = deleteButtonRect.x;
                int dy = deleteButtonRect.y;
                if (c.getText() != null && c.getText().length() > 0 && this.isDeleteButtonEnabled) {
                    if (this.isDeleteMousePressed) {
                        g2.drawImage(this.deleteButtonPressedImg, dx, dy, null);
                    }
                    if (this.isDeleteMouseOver) {
                        g2.drawImage(this.deleteButtonRolloverImg, dx, dy, null);
                    } else {
                        g2.drawImage(this.deleteButtonImg, dx, dy, null);
                    }
                    this.isDeleteIconVisible = true;
                } else {
                    this.isDeleteIconVisible = false;
                }
            } else {
                this.isDeleteIconVisible = false;
            }
            g2.setStroke(new BasicStroke(1.0f));
            GradientPaint bgBorderGradientColor = new GradientPaint(c.getWidth() / 2, 0.0f, this.bgBorderStartColor, c.getWidth() / 2, c.getHeight(), this.bgBorderEndColor);
            g2.setPaint(bgBorderGradientColor);
            if (isRounded) {
                g2.drawRoundRect(0, 0, c.getWidth() - 1, c.getHeight() - 1, 8, 8);
            } else {
                g2.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected void updateDeleteIcon(MouseEvent evt) {
        if (this.getComponent() == null) {
            return;
        }
        int x = evt.getX();
        int y = evt.getY();
        if (!this.isDeleteButtonEnabled) {
            return;
        }
        Rectangle deleteRect = this.getDeleteButtonRect();
        if (this.isDeleteIconVisible && deleteRect.contains(x, y)) {
            if (evt.getID() == 501) {
                this.isDeleteMouseOver = false;
                this.isDeleteMousePressed = true;
            } else {
                this.isDeleteMouseOver = true;
                this.isDeleteMousePressed = false;
            }
            this.getComponent().setCursor(Cursor.getDefaultCursor());
            if (evt.getID() == 500) {
                this.getComponent().setText("");
            }
        } else {
            this.isDeleteMouseOver = false;
            this.isDeleteMousePressed = false;
        }
        this.getComponent().repaint();
    }

    protected Rectangle getDeleteButtonRect() {
        JTextComponent c = this.getComponent();
        if (c == null) {
            return null;
        }
        Rectangle rect = c.getBounds();
        int dx = rect.width - this.deleteButton.getWidth() - BUTTON_GAP;
        int dy = rect.height / 2 - this.deleteButton.getHeight() / 2;
        return new Rectangle(dx, dy, this.deleteButton.getWidth(), this.deleteButton.getHeight());
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        if (!this.isDeleteIconVisible) {
            return super.getVisibleEditorRect();
        }
        JTextComponent c = this.getComponent();
        if (c == null) {
            return null;
        }
        Rectangle alloc = c.getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            alloc.y = 0;
            alloc.x = 0;
            Insets insets = c.getInsets();
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width = (int)((double)alloc.width - ((double)(insets.left + insets.right) + this.getDeleteButtonRect().getWidth()));
            alloc.height -= insets.top + insets.bottom;
            return alloc;
        }
        return null;
    }

    public void setBgStartColor(Color bgStartColor) {
        this.bgStartColor = bgStartColor;
    }

    public void setBgEndColor(Color bgEndColor) {
        this.bgEndColor = bgEndColor;
    }

    public void setBgBorderStartColor(Color bgBorderStartColor) {
        this.bgBorderStartColor = bgBorderStartColor;
    }

    public void setBgBorderEndColor(Color bgBorderEndColor) {
        this.bgBorderEndColor = bgBorderEndColor;
    }

    public void loadSkin() {
        this.deleteButtonImg = DesktopUtilActivator.getResources().getImage("service.gui.lookandfeel.DELETE_TEXT_ICON").getImage();
        this.deleteButtonRolloverImg = DesktopUtilActivator.getResources().getImage("service.gui.lookandfeel.DELETE_TEXT_ROLLOVER_ICON").getImage();
        this.deleteButtonPressedImg = DesktopUtilActivator.getResources().getImage("service.gui.lookandfeel.DELETE_TEXT_PRESSED_ICON").getImage();
        if (this.deleteButton != null) {
            this.deleteButton.setBackgroundImage(this.deleteButtonImg);
            this.deleteButton.setRolloverImage(this.deleteButtonRolloverImg);
            this.deleteButton.setPressedImage(this.deleteButtonPressedImg);
        } else {
            this.deleteButton = new SIPCommButton(this.deleteButtonImg, this.deleteButtonRolloverImg, this.deleteButtonPressedImg, null, null, null);
        }
        this.deleteButton.setSize(this.deleteButtonImg.getWidth(null), this.deleteButtonImg.getHeight(null));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.updateDeleteIcon(e);
        this.updateCursor(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateDeleteIcon(e);
        this.updateCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.updateDeleteIcon(e);
        this.updateCursor(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updateDeleteIcon(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateDeleteIcon(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateDeleteIcon(e);
        this.updateCursor(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateDeleteIcon(e);
        this.updateCursor(e);
    }

    private void updateCursor(MouseEvent mouseEvent) {
        Rectangle rect = this.getVisibleEditorRect();
        if (rect != null && rect.contains(mouseEvent.getPoint())) {
            this.getComponent().setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SIPCommTextFieldUI();
    }
}

