/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence;

import java.beans.PropertyChangeEvent;
import net.java.sip.communicator.plugin.desktoputil.presence.AbstractStatusMessageMenu;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.util.Logger;

public class StatusMessageMenu
extends AbstractStatusMessageMenu
implements ProviderPresenceStatusListener {
    private static final Logger logger = Logger.getLogger(StatusMessageMenu.class);
    private ProtocolProviderService protocolProvider;

    public StatusMessageMenu(ProtocolProviderService protocolProvider, boolean swing) {
        super(swing);
        this.protocolProvider = protocolProvider;
        OperationSetPresence presenceOpSet = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        if (presenceOpSet != null) {
            presenceOpSet.addProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
        }
    }

    @Override
    public Object getDescriptor() {
        return this.protocolProvider;
    }

    @Override
    public String getCurrentStatusMessage() {
        OperationSetPresence presenceOpSet = (OperationSetPresence)this.protocolProvider.getOperationSet(OperationSetPresence.class);
        return presenceOpSet.getCurrentStatusMessage();
    }

    @Override
    public void publishStatusMessage(String message, Object menuItem, boolean saveIfNewMessage) {
        new PublishStatusMessageThread(message, menuItem, saveIfNewMessage).start();
    }

    public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
    }

    public void providerStatusMessageChanged(PropertyChangeEvent evt) {
        this.fireStatusMessageUpdated((String)evt.getOldValue(), (String)evt.getNewValue());
    }

    @Override
    public void dispose() {
        super.dispose();
        OperationSetPresence presenceOpSet = (OperationSetPresence)this.protocolProvider.getOperationSet(OperationSetPresence.class);
        if (presenceOpSet != null) {
            presenceOpSet.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
        }
    }

    private class PublishStatusMessageThread
    extends Thread {
        private String message;
        private PresenceStatus currentStatus;
        private OperationSetPresence presenceOpSet;
        private Object menuItem;
        private boolean saveIfNewMessage;

        public PublishStatusMessageThread(String message, Object menuItem, boolean saveIfNewMessage) {
            this.message = message;
            this.presenceOpSet = (OperationSetPresence)StatusMessageMenu.this.protocolProvider.getOperationSet(OperationSetPresence.class);
            this.currentStatus = this.presenceOpSet.getPresenceStatus();
            this.menuItem = menuItem;
            this.saveIfNewMessage = saveIfNewMessage;
        }

        @Override
        public void run() {
            block6: {
                try {
                    this.presenceOpSet.publishPresenceStatus(this.currentStatus, this.message);
                }
                catch (IllegalArgumentException e1) {
                    logger.error((Object)"Error - changing status", (Throwable)e1);
                }
                catch (IllegalStateException e1) {
                    logger.error((Object)"Error - changing status", (Throwable)e1);
                }
                catch (OperationFailedException e1) {
                    if (e1.getErrorCode() == 1) {
                        logger.error((Object)"General error occured while publishing presence status.", (Throwable)e1);
                    }
                    if (e1.getErrorCode() == 2) {
                        logger.error((Object)"Network failure occured while publishing presence status.", (Throwable)e1);
                    }
                    if (e1.getErrorCode() != 3) break block6;
                    logger.error((Object)"Protocol provider must beregistered in order to change status.", (Throwable)e1);
                }
            }
        }
    }
}

