/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;

public class ImageClipper
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final Color IMAGE_BORDER_COLOR = new Color(174, 189, 215);
    private static final Color IMAGE_OVERLAY_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.4f);
    private int lastComponentWidth = 0;
    private int lastComponentHeight = 0;
    private BufferedImage image = null;
    private Rectangle imageRect = new Rectangle();
    private Rectangle cropZoneRect;
    private int mouseStartX;
    private int mouseStartY;

    public ImageClipper(int cropZoneWidth, int cropZoneHeight) {
        this.cropZoneRect = new Rectangle(cropZoneWidth, cropZoneHeight);
        this.updateCropZone();
        Dimension d = new Dimension(320, 240);
        this.setSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void updateCropZone() {
        this.cropZoneRect.x = this.getWidth() / 2 - this.cropZoneRect.width / 2;
        this.cropZoneRect.y = this.getHeight() / 2 - this.cropZoneRect.height / 2;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.imageRect.width = image.getWidth(this);
        this.imageRect.height = image.getHeight(this);
        this.imageRect.x = (this.getWidth() - this.imageRect.width) / 2;
        this.imageRect.y = (this.getHeight() - this.imageRect.height) / 2;
        this.lastComponentHeight = this.getHeight();
        this.lastComponentWidth = this.getWidth();
        this.updateImagePoints();
        this.repaint();
    }

    private void updateImagePoints() {
        if (this.lastComponentWidth != this.getWidth()) {
            this.imageRect.x += (this.getWidth() - this.lastComponentWidth) / 2;
            this.lastComponentWidth = this.getWidth();
        }
        if (this.lastComponentHeight != this.getHeight()) {
            this.imageRect.y += (this.getHeight() - this.lastComponentHeight) / 2;
            this.lastComponentHeight = this.getHeight();
        }
    }

    public Rectangle getCroppedArea() {
        Rectangle croppedArea = new Rectangle();
        croppedArea.setSize(this.cropZoneRect.getSize());
        croppedArea.x = this.cropZoneRect.x - this.imageRect.x;
        croppedArea.y = this.cropZoneRect.y - this.imageRect.y;
        return croppedArea;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        AntialiasingManager.activateAntialiasing(g);
        this.updateImagePoints();
        g.drawImage(this.image, this.imageRect.x, this.imageRect.y, this.imageRect.width, this.imageRect.height, this);
        this.updateCropZone();
        g.setColor(Color.BLACK);
        g.drawRect(this.cropZoneRect.x, this.cropZoneRect.y, this.cropZoneRect.width, this.cropZoneRect.height);
        this.drawImageOverlay(g);
        g.setColor(IMAGE_BORDER_COLOR);
        g.drawRoundRect(this.imageRect.x - 2, this.imageRect.y - 2, this.imageRect.width + 3, this.imageRect.height + 3, 2, 2);
        g.drawRoundRect(this.imageRect.x - 1, this.imageRect.y - 1, this.imageRect.width + 1, this.imageRect.height + 1, 2, 2);
    }

    private void drawImageOverlay(Graphics g) {
        int height;
        g.setColor(IMAGE_OVERLAY_COLOR);
        int width = this.cropZoneRect.x - this.imageRect.x;
        if (width > 0) {
            g.fillRect(this.imageRect.x, this.imageRect.y, width, this.imageRect.height);
        }
        if ((width = this.imageRect.x + this.imageRect.width - (this.cropZoneRect.x + this.cropZoneRect.width)) > 0) {
            g.fillRect(this.cropZoneRect.x + this.cropZoneRect.width, this.imageRect.y, width, this.imageRect.height);
        }
        if ((height = this.cropZoneRect.y - this.imageRect.y) > 0) {
            g.fillRect(this.cropZoneRect.x, this.imageRect.y, this.cropZoneRect.width, height);
        }
        if ((height = this.imageRect.y + this.imageRect.height - (this.cropZoneRect.y + this.cropZoneRect.height)) > 0) {
            g.fillRect(this.cropZoneRect.x, this.cropZoneRect.y + this.cropZoneRect.height, this.cropZoneRect.width, height);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseStartX = e.getX();
        this.mouseStartY = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int newXpos = this.imageRect.x + e.getX() - this.mouseStartX;
        int newYpos = this.imageRect.y + e.getY() - this.mouseStartY;
        if (newXpos <= this.cropZoneRect.x && newXpos + this.imageRect.width >= this.cropZoneRect.x + this.cropZoneRect.width) {
            this.imageRect.x = newXpos;
            this.mouseStartX = e.getX();
        }
        if (newYpos < this.cropZoneRect.y && newYpos + this.imageRect.height >= this.cropZoneRect.y + this.cropZoneRect.height) {
            this.imageRect.y = newYpos;
            this.mouseStartY = e.getY();
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

