/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser;

import java.util.Dictionary;
import java.util.Hashtable;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutService;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class KeybindingChooserActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(KeybindingChooserActivator.class);
    private static BundleContext bundleContext;
    public static ResourceManagementService resourcesService;
    private static ConfigurationService configService;
    private static KeybindingsService keybindingService;
    private static GlobalShortcutService globalShortcutService;
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.keybindingsconfig.DISABLED";

    public void start(BundleContext bc) {
        bundleContext = bc;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Service Impl: " + this.getClass().getName() + " [  STARTED ]"));
        }
        if (!KeybindingChooserActivator.getConfigService().getBoolean(DISABLED_PROP, false)) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("FORM_TYPE", "ADVANCED_TYPE");
            bc.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm("net.java.sip.communicator.plugin.keybindingchooser.KeybindingsConfigPanel", this.getClass().getClassLoader(), "plugin.keybinding.PLUGIN_ICON", "plugin.keybindings.PLUGIN_NAME", 900, true), properties);
        }
    }

    public void stop(BundleContext bc) throws Exception {
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourcesService;
    }

    public static ConfigurationService getConfigService() {
        if (configService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configService = (ConfigurationService)bundleContext.getService(confReference);
        }
        return configService;
    }

    public static KeybindingsService getKeybindingsService() {
        if (keybindingService == null) {
            ServiceReference keybindingReference = bundleContext.getServiceReference(KeybindingsService.class.getName());
            keybindingService = (KeybindingsService)bundleContext.getService(keybindingReference);
        }
        return keybindingService;
    }

    public static GlobalShortcutService getGlobalShortcutService() {
        if (globalShortcutService == null) {
            ServiceReference globalShortcutReference = bundleContext.getServiceReference(GlobalShortcutService.class.getName());
            globalShortcutService = (GlobalShortcutService)bundleContext.getService(globalShortcutReference);
        }
        return globalShortcutService;
    }

    static {
        keybindingService = null;
        globalShortcutService = null;
    }
}

