/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenuBar;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextButton;
import net.java.sip.communicator.plugin.desktoputil.SelectedObject;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.plugin.spellcheck.Parameters;
import net.java.sip.communicator.plugin.spellcheck.Resources;
import net.java.sip.communicator.plugin.spellcheck.SpellCheckActivator;
import net.java.sip.communicator.plugin.spellcheck.SpellChecker;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.PopupDialog;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.Logger;

public class LanguageMenuBar
extends SIPCommMenuBar
implements PluginComponent,
PropertyChangeListener {
    private static final long serialVersionUID = 0L;
    private static final HashMap<Parameters.Locale, ImageIcon> AVAILABLE_FLAGS = new HashMap();
    private static final HashMap<Parameters.Locale, ImageIcon> UNAVAILABLE_FLAGS = new HashMap();
    private static final Logger logger = Logger.getLogger(LanguageMenuBar.class);
    private static final ImageIcon BLANK_FLAG_ICON = Resources.getImage("plugin.spellcheck.BLANK_FLAG");
    private final ListCellRenderer languageSelectionRenderer;
    private final HashMap<Parameters.Locale, Boolean> localeAvailabilityCache = new HashMap();
    private final SpellChecker spellChecker;
    private final SIPCommMenu menu = new SelectorMenu();
    private final List<Parameters.Locale> localeList = new ArrayList<Parameters.Locale>();
    private final SIPCommTextButton removeItem = new SIPCommTextButton(Resources.getString("plugin.spellcheck.UNINSTALL_DICTIONARY"));
    public final JList list;
    private final PluginComponentFactory parentFactory;

    LanguageMenuBar(SpellChecker checker, PluginComponentFactory parentFactory) {
        this.spellChecker = checker;
        this.spellChecker.addPropertyChangeListener(this);
        this.parentFactory = parentFactory;
        this.setPreferredSize(new Dimension(30, 28));
        this.setMaximumSize(new Dimension(30, 28));
        this.setMinimumSize(new Dimension(30, 28));
        this.menu.setPreferredSize(new Dimension(30, 45));
        this.menu.setMaximumSize(new Dimension(30, 45));
        this.menu.setToolTipText(Resources.getString("plugin.spellcheck.SPELLCHECK"));
        this.add((JMenu)this.menu);
        this.setBorder(null);
        this.menu.add((Component)this.createEnableCheckBox());
        this.menu.addSeparator();
        this.menu.setBorder(null);
        this.menu.setOpaque(false);
        this.setOpaque(false);
        final DefaultListModel model = new DefaultListModel();
        this.list = new JList(model);
        this.languageSelectionRenderer = new LanguageListRenderer();
        for (Parameters.Locale locale : Parameters.getLocales()) {
            if (!this.localeAvailabilityCache.containsKey(locale)) {
                this.localeAvailabilityCache.put(locale, this.spellChecker.isLocaleAvailable(locale));
            }
            this.localeList.add(locale);
        }
        this.setModelElements(model);
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setBorder(null);
        String localeIso = Parameters.getDefault(Parameters.Default.LOCALE);
        Parameters.Locale loc = Parameters.getLocale(localeIso);
        this.list.setCellRenderer(this.languageSelectionRenderer);
        this.list.setSelectedIndex(this.localeList.indexOf(loc) + 1);
        this.list.setSelectionMode(0);
        this.removeItem.setPreferredSize(new Dimension(30, 28));
        this.list.addListSelectionListener(new LanguageListSelectionListener());
        this.menu.add((Component)scroll);
        ImageIcon flagIcon = LanguageMenuBar.getLocaleIcon(checker.getLocale(), this.localeAvailabilityCache.get(checker.getLocale()));
        SelectedObject selectedObject = new SelectedObject((Icon)flagIcon, (Object)checker.getLocale());
        this.menu.setSelected(selectedObject);
        this.menu.addSeparator();
        this.menu.add((Component)this.removeItem);
        this.list.addKeyListener(new KeyListener(){
            long time = 0L;
            String key = "";

            @Override
            public void keyTyped(KeyEvent e) {
                char ch = e.getKeyChar();
                if (!Character.isLetter(ch)) {
                    return;
                }
                if (this.time + 1000L < System.currentTimeMillis()) {
                    this.key = "";
                }
                this.time = System.currentTimeMillis();
                this.key = this.key + ch;
                for (int i = 0; i < model.getSize(); ++i) {
                    String label = ((Parameters.Locale)model.getElementAt(i)).getLabel().toLowerCase();
                    if (!label.startsWith(this.key.toLowerCase())) continue;
                    LanguageMenuBar.this.list.setSelectedIndex(i);
                    LanguageMenuBar.this.list.ensureIndexIsVisible(i);
                    break;
                }
                LanguageMenuBar.this.list.requestFocusInWindow();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.removeItem.setEnabled(!this.spellChecker.getLocale().getIsoCode().equals(Parameters.getDefault(Parameters.Default.LOCALE)) && this.spellChecker.isUserLocale(this.spellChecker.getLocale()));
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LanguageMenuBar.this.list.setEnabled(false);
                    Parameters.Locale locale = (Parameters.Locale)LanguageMenuBar.this.menu.getSelectedObject();
                    LanguageMenuBar.this.localeAvailabilityCache.put(locale, false);
                    LanguageMenuBar.this.spellChecker.removeLocale(locale);
                    LanguageMenuBar.this.list.setEnabled(true);
                    ImageIcon flagIcon = LanguageMenuBar.getLocaleIcon(LanguageMenuBar.this.spellChecker.getLocale(), (Boolean)LanguageMenuBar.this.localeAvailabilityCache.get(LanguageMenuBar.this.spellChecker.getLocale()));
                    SelectedObject selectedObject = new SelectedObject((Icon)flagIcon, (Object)LanguageMenuBar.this.spellChecker.getLocale());
                    LanguageMenuBar.this.menu.setSelected(selectedObject);
                }
                catch (Exception ex) {
                    PopupDialog dialog = SpellCheckActivator.getUIService().getPopupDialog();
                    String message = Resources.getString("plugin.spellcheck.DICT_ERROR_DELETE") + ex.getMessage();
                    dialog.showMessagePopupDialog((Object)message, Resources.getString("plugin.spellcheck.DICT_ERROR_DELETE_TITLE"), 2);
                    logger.error((Object)"Error removing dict", (Throwable)ex);
                }
            }
        });
    }

    public String getName() {
        return "Spell Checker Toggle";
    }

    public void setCurrentContact(MetaContact metaContact) {
    }

    public void setCurrentContactGroup(MetaContactGroup metaGroup) {
    }

    public void setCurrentAccountID(AccountID account) {
    }

    private static ImageIcon getLocaleIcon(Parameters.Locale locale, boolean isAvailable) {
        if (isAvailable && AVAILABLE_FLAGS.containsKey(locale)) {
            return AVAILABLE_FLAGS.get(locale);
        }
        if (!isAvailable && UNAVAILABLE_FLAGS.containsKey(locale)) {
            return UNAVAILABLE_FLAGS.get(locale);
        }
        try {
            ImageIcon localeFlag = Resources.getFlagImage(locale.getFlagIcon());
            BufferedImage flagBuffer = LanguageMenuBar.copy(localeFlag.getImage());
            LanguageMenuBar.setFaded(flagBuffer);
            ImageIcon unavailableLocaleFlag = new ImageIcon(flagBuffer);
            AVAILABLE_FLAGS.put(locale, localeFlag);
            UNAVAILABLE_FLAGS.put(locale, unavailableLocaleFlag);
            return isAvailable ? localeFlag : unavailableLocaleFlag;
        }
        catch (IOException exc) {
            AVAILABLE_FLAGS.put(locale, BLANK_FLAG_ICON);
            UNAVAILABLE_FLAGS.put(locale, BLANK_FLAG_ICON);
            return BLANK_FLAG_ICON;
        }
    }

    private static BufferedImage copy(Image image) {
        BufferedImage copy;
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            pg.grabPixels();
            ColorModel cm = pg.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
            copy = new BufferedImage(cm, raster, isRasterPremultiplied, null);
        }
        catch (InterruptedException e) {
            copy = new BufferedImage(width, height, 2);
        }
        Graphics2D g2 = copy.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return copy;
    }

    private static void setFaded(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        for (int row = 0; row < width; ++row) {
            for (int col = 0; col < height; ++col) {
                int c = image.getRGB(row, col);
                int r = ((c >> 16 & 0xFF) + (c >> 8 & 0xFF) + (c & 0xFF)) / 3;
                int newRgb = 0xFF000000 | r << 16 | r << 8 | r;
                newRgb &= 0xFFFFFF;
                image.setRGB(row, col, newRgb |= Integer.MIN_VALUE);
            }
        }
    }

    public void setCurrentContact(Contact contact) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("LocaleChanged")) {
            return;
        }
        Parameters.Locale currentLocale = this.spellChecker.getLocale();
        ImageIcon flagIcon = LanguageMenuBar.getLocaleIcon(currentLocale, this.localeAvailabilityCache.get(currentLocale));
        SelectedObject selectedObject = new SelectedObject((Icon)flagIcon, (Object)currentLocale);
        this.menu.setSelected(selectedObject);
    }

    private JCheckBox createEnableCheckBox() {
        SIPCommCheckBox checkBox = new SIPCommCheckBox(Resources.getString("plugin.spellcheck.ENABLE_SPELL_CHECK"));
        checkBox.setSelected(this.spellChecker.isEnabled());
        checkBox.setIconTextGap(0);
        checkBox.addChangeListener(new ChangeListener((JCheckBox)checkBox){
            final /* synthetic */ JCheckBox val$checkBox;
            {
                this.val$checkBox = jCheckBox;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                LanguageMenuBar.this.spellChecker.setEnabled(this.val$checkBox.isSelected());
                SpellCheckActivator.getConfigService().setProperty("plugin.spellcheck.ENABLE", (Object)this.val$checkBox.isSelected());
            }
        });
        return checkBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setModelElements(DefaultListModel model) {
        DefaultListModel defaultListModel = model;
        synchronized (defaultListModel) {
            model.clear();
            Collections.sort(this.localeList, new Comparator<Parameters.Locale>(){

                @Override
                public int compare(Parameters.Locale o1, Parameters.Locale o2) {
                    boolean b2;
                    boolean b1 = LanguageMenuBar.this.spellChecker.isLocaleAvailable(o1);
                    if (b1 == (b2 = LanguageMenuBar.this.spellChecker.isLocaleAvailable(o2))) {
                        return 0;
                    }
                    return b1 ? -1 : 1;
                }
            });
            for (Parameters.Locale loc : this.localeList) {
                model.addElement(loc);
            }
        }
    }

    public SetSpellChecker createSpellCheckerWorker(Parameters.Locale locale) {
        return new SetSpellChecker(locale, this.list);
    }

    public PluginComponentFactory getParentFactory() {
        return this.parentFactory;
    }

    public int getPositionIndex() {
        return -1;
    }

    public void setCurrentContact(Contact contact, String resourceName) {
    }

    private class LanguageListSelectionListener
    implements ListSelectionListener {
        private LanguageListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JList source = (JList)e.getSource();
                Parameters.Locale locale = (Parameters.Locale)source.getSelectedValue();
                source.setEnabled(false);
                locale.setLoading(true);
                new SetSpellChecker(locale, source).start();
                source.requestFocusInWindow();
                LanguageMenuBar.this.removeItem.setEnabled(false);
            }
        }
    }

    private class LanguageListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 0L;

        private LanguageListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Parameters.Locale locale = (Parameters.Locale)value;
            if (!LanguageMenuBar.this.localeAvailabilityCache.containsKey(locale)) {
                LanguageMenuBar.this.localeAvailabilityCache.put(locale, LanguageMenuBar.this.spellChecker.isLocaleAvailable(locale));
            }
            ImageIcon flagIcon = LanguageMenuBar.getLocaleIcon(locale, (Boolean)LanguageMenuBar.this.localeAvailabilityCache.get(locale));
            String localeLabel = locale.getLabel();
            if (locale.isLoading()) {
                this.setText("<html>" + localeLabel + " <font color='gray'><i>loading...</i></font><html>");
            } else {
                this.setText(localeLabel);
            }
            this.setIcon(flagIcon);
            return this;
        }
    }

    public class SetSpellChecker
    extends SwingWorker {
        private final Parameters.Locale locale;
        private final JList sourceList;
        private boolean skipFiring = false;

        public SetSpellChecker(Parameters.Locale locale, JList sourceList) {
            this.locale = locale;
            this.sourceList = sourceList;
        }

        public void finished() {
            if (this.get() != null) {
                this.sourceList.setEnabled(true);
                LanguageMenuBar.this.localeAvailabilityCache.put(this.locale, true);
                ImageIcon flagIcon = LanguageMenuBar.getLocaleIcon(this.locale, (Boolean)LanguageMenuBar.this.localeAvailabilityCache.get(this.locale));
                SelectedObject selectedObject = new SelectedObject((Icon)flagIcon, (Object)this.locale);
                LanguageMenuBar.this.menu.setSelected(selectedObject);
            } else {
                this.skipFiring = true;
                ImageIcon flagIcon = LanguageMenuBar.getLocaleIcon(this.locale, (Boolean)LanguageMenuBar.this.localeAvailabilityCache.get(this.locale));
                SelectedObject selectedObject = new SelectedObject((Icon)flagIcon, (Object)this.locale);
                LanguageMenuBar.this.menu.setSelected(selectedObject);
                this.skipFiring = false;
                this.sourceList.setEnabled(true);
            }
            this.locale.setLoading(false);
            this.sourceList.removeListSelectionListener(this.sourceList.getListSelectionListeners()[0]);
            LanguageMenuBar.this.setModelElements((DefaultListModel)this.sourceList.getModel());
            this.sourceList.setSelectedValue(this.locale, true);
            LanguageMenuBar.this.removeItem.setEnabled(!LanguageMenuBar.this.spellChecker.getLocale().getIsoCode().equals(Parameters.getDefault(Parameters.Default.LOCALE)) && LanguageMenuBar.this.spellChecker.isUserLocale(LanguageMenuBar.this.spellChecker.getLocale()));
            this.sourceList.addListSelectionListener(new LanguageListSelectionListener());
        }

        public Object construct() throws Exception {
            try {
                if (this.skipFiring) {
                    return null;
                }
                LanguageMenuBar.this.spellChecker.setLocale(this.locale);
                return this.locale;
            }
            catch (Exception exc) {
                logger.warn((Object)("Unable to retrieve dictionary for " + this.locale), (Throwable)exc);
                PopupDialog dialog = SpellCheckActivator.getUIService().getPopupDialog();
                String message = Resources.getString("plugin.spellcheck.DICT_ERROR");
                if (exc instanceof IOException) {
                    message = Resources.getString("plugin.spellcheck.DICT_RETRIEVE_ERROR") + ":\n" + this.locale.getDictUrl();
                } else if (exc instanceof IllegalArgumentException) {
                    message = Resources.getString("plugin.spellcheck.DICT_PROCESS_ERROR");
                }
                dialog.showMessagePopupDialog((Object)message, Resources.getString("plugin.spellcheck.DICT_ERROR_TITLE"), 2);
                return null;
            }
        }
    }

    private static class SelectorMenu
    extends SIPCommMenu {
        private static final long serialVersionUID = 0L;
        Image image = Resources.getImage("service.gui.icons.DOWN_ARROW_ICON").getImage();

        private SelectorMenu() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.image, this.getWidth() - this.image.getWidth((ImageObserver)((Object)this)) - 1, (this.getHeight() - this.image.getHeight((ImageObserver)((Object)this)) - 1) / 2, (ImageObserver)((Object)this));
        }
    }
}

