/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.callhistory;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import net.java.sip.communicator.impl.callhistory.CallHistoryServiceImpl;
import net.java.sip.communicator.service.callhistory.CallHistoryQuery;
import net.java.sip.communicator.service.callhistory.CallRecord;
import net.java.sip.communicator.service.callhistory.event.CallHistoryQueryListener;
import net.java.sip.communicator.service.callhistory.event.CallHistoryQueryStatusEvent;
import net.java.sip.communicator.service.callhistory.event.CallRecordEvent;
import net.java.sip.communicator.service.history.HistoryQuery;
import net.java.sip.communicator.service.history.event.HistoryQueryListener;
import net.java.sip.communicator.service.history.event.HistoryQueryStatusEvent;
import net.java.sip.communicator.service.history.event.HistoryRecordEvent;
import net.java.sip.communicator.service.history.records.HistoryRecord;

public class CallHistoryQueryImpl
implements CallHistoryQuery {
    private final Collection<CallHistoryQueryListener> queryListeners = new LinkedList<CallHistoryQueryListener>();
    private final Collection<CallRecord> callRecords = new Vector<CallRecord>();
    private final HistoryQuery historyQuery;

    public CallHistoryQueryImpl(HistoryQuery query) {
        this.historyQuery = query;
        this.historyQuery.addHistoryRecordsListener(new HistoryQueryListener(){

            public void historyRecordReceived(HistoryRecordEvent event) {
                CallRecord callRecord = CallHistoryServiceImpl.convertHistoryRecordToCallRecord(event.getHistoryRecord());
                CallHistoryQueryImpl.this.callRecords.add(callRecord);
                CallHistoryQueryImpl.this.fireQueryEvent(callRecord);
            }

            public void queryStatusChanged(HistoryQueryStatusEvent event) {
                CallHistoryQueryImpl.this.fireQueryStatusEvent(event.getEventType());
            }
        });
        Iterator historyRecords = this.historyQuery.getHistoryRecords().iterator();
        while (historyRecords.hasNext()) {
            CallRecord callRecord = CallHistoryServiceImpl.convertHistoryRecordToCallRecord((HistoryRecord)historyRecords.next());
            this.callRecords.add(callRecord);
        }
    }

    @Override
    public void cancel() {
        this.historyQuery.cancel();
    }

    @Override
    public Collection<CallRecord> getCallRecords() {
        return new Vector<CallRecord>(this.callRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueryListener(CallHistoryQueryListener l) {
        Collection<CallHistoryQueryListener> collection = this.queryListeners;
        synchronized (collection) {
            this.queryListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueryListener(CallHistoryQueryListener l) {
        Collection<CallHistoryQueryListener> collection = this.queryListeners;
        synchronized (collection) {
            this.queryListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueryEvent(CallRecord record) {
        CallRecordEvent event = new CallRecordEvent(this, record);
        Collection<CallHistoryQueryListener> collection = this.queryListeners;
        synchronized (collection) {
            for (CallHistoryQueryListener l : this.queryListeners) {
                l.callRecordReceived(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueryStatusEvent(int newStatus) {
        CallHistoryQueryStatusEvent event = new CallHistoryQueryStatusEvent(this, newStatus);
        Collection<CallHistoryQueryListener> collection = this.queryListeners;
        synchronized (collection) {
            for (CallHistoryQueryListener l : this.queryListeners) {
                l.queryStatusChanged(event);
            }
        }
    }

    @Override
    public String getQueryString() {
        return this.historyQuery.getQueryString();
    }
}

