/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.branding;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.java.sip.communicator.plugin.branding.BrandingActivator;
import net.java.sip.communicator.plugin.branding.Constants;
import net.java.sip.communicator.plugin.branding.StyledHTMLEditorPane;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.UIAction;
import net.java.sip.communicator.plugin.desktoputil.WindowUtils;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTextFieldUI;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.gui.WindowID;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.ServiceReference;

public class AboutWindow
extends JDialog
implements HyperlinkListener,
ActionListener,
ExportedWindow,
Skinnable {
    private static final long serialVersionUID = 0L;
    private static AboutWindow aboutWindow;
    private static final String uiClassID;
    private final JTextField versionLabel;
    private static final int DEFAULT_TEXT_INDENT;

    public static void showAboutWindow() {
        if (aboutWindow == null) {
            aboutWindow = new AboutWindow(null);
            aboutWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (aboutWindow == e.getWindow()) {
                        aboutWindow = null;
                    }
                }
            });
        }
        aboutWindow.setVisible(true);
    }

    public AboutWindow(Frame owner) {
        super(owner);
        ResourceManagementService resources = BrandingActivator.getResources();
        String applicationName = resources.getSettingsString("service.gui.APPLICATION_NAME");
        String website = resources.getSettingsString("service.gui.APPLICATION_WEB_SITE");
        this.setTitle(resources.getI18NString("plugin.branding.ABOUT_WINDOW_TITLE", new String[]{applicationName}));
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        WindowBackground mainPanel = new WindowBackground();
        mainPanel.setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.setPreferredSize(new Dimension(470, 280));
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        textPanel.setOpaque(false);
        JLabel titleLabel = new JLabel(applicationName);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1, 28.0f));
        titleLabel.setForeground(Constants.TITLE_COLOR);
        titleLabel.setAlignmentX(1.0f);
        this.versionLabel = new JTextField(" " + System.getProperty("sip-communicator.version")){

            @Override
            public String getUIClassID() {
                return uiClassID;
            }
        };
        this.versionLabel.setBorder(null);
        this.versionLabel.setOpaque(false);
        this.versionLabel.setEditable(false);
        this.versionLabel.setFont(this.versionLabel.getFont().deriveFont(1, 18.0f));
        this.versionLabel.setForeground(Constants.TITLE_COLOR);
        this.versionLabel.setAlignmentX(1.0f);
        this.versionLabel.setHorizontalAlignment(4);
        int logoAreaFontSize = resources.getSettingsInt("plugin.branding.ABOUT_LOGO_FONT_SIZE");
        JTextArea logoArea = new JTextArea(resources.getI18NString("plugin.branding.LOGO_MESSAGE"));
        logoArea.setFont(logoArea.getFont().deriveFont(1, logoAreaFontSize));
        logoArea.setForeground(Constants.TITLE_COLOR);
        logoArea.setOpaque(false);
        logoArea.setLineWrap(true);
        logoArea.setWrapStyleWord(true);
        logoArea.setEditable(false);
        logoArea.setAlignmentX(1.0f);
        logoArea.setBorder(BorderFactory.createEmptyBorder(30, DEFAULT_TEXT_INDENT, 0, 0));
        StyledHTMLEditorPane rightsArea = new StyledHTMLEditorPane();
        rightsArea.setContentType("text/html");
        String host = website;
        try {
            host = new URL(website).getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        rightsArea.appendToEnd(resources.getI18NString("plugin.branding.COPYRIGHT_LICENSE", new String[]{Constants.TEXT_COLOR, Integer.toString(Calendar.getInstance().get(1)), website, host, applicationName, "http://www.apache.org/licenses/LICENSE-2.0", "Apache License 2.0"}));
        rightsArea.setBorder(BorderFactory.createEmptyBorder(0, DEFAULT_TEXT_INDENT, 0, 0));
        rightsArea.setOpaque(false);
        rightsArea.setEditable(false);
        rightsArea.setAlignmentX(1.0f);
        rightsArea.addHyperlinkListener(this);
        textPanel.add(titleLabel);
        textPanel.add(this.versionLabel);
        textPanel.add(logoArea);
        textPanel.add(rightsArea);
        JButton okButton = new JButton(resources.getI18NString("service.gui.OK"));
        this.getRootPane().setDefaultButton(okButton);
        okButton.setMnemonic(resources.getI18nMnemonic("service.gui.OK"));
        okButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(okButton);
        buttonPanel.setOpaque(false);
        mainPanel.add((Component)textPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().getActionMap().put("close", (Action)((Object)new CloseAction()));
        InputMap imap = this.getRootPane().getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(27, 0), "close");
        if (OSUtils.IS_MAC) {
            imap.put(KeyStroke.getKeyStroke(87, 256), "close");
            imap.put(KeyStroke.getKeyStroke(87, 128), "close");
        }
        WindowUtils.addWindow((Window)this);
    }

    public void loadSkin() {
        if (this.versionLabel.getUI() instanceof Skinnable) {
            ((Skinnable)this.versionLabel.getUI()).loadSkin();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        ServiceReference serviceReference;
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (serviceReference = BrandingActivator.getBundleContext().getServiceReference(BrowserLauncherService.class)) != null) {
            BrowserLauncherService browserLauncherService = (BrowserLauncherService)BrandingActivator.getBundleContext().getService(serviceReference);
            browserLauncherService.openURL(e.getDescription());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public WindowID getIdentifier() {
        return ExportedWindow.ABOUT_WINDOW;
    }

    public void minimize() {
    }

    public void maximize() {
    }

    public void bringToFront() {
        this.toFront();
    }

    public Object getSource() {
        return this;
    }

    public void setParams(Object[] windowParams) {
    }

    static {
        uiClassID = AboutWindow.class.getName() + "$VersionTextFieldUI";
        UIManager.getDefaults().put(uiClassID, SIPCommTextFieldUI.class.getName());
        DEFAULT_TEXT_INDENT = BrandingActivator.getResources().getSettingsInt("plugin.branding.ABOUT_TEXT_INDENT");
    }

    private class CloseAction
    extends UIAction {
        private static final long serialVersionUID = 0L;

        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AboutWindow.this.setVisible(false);
            AboutWindow.this.dispose();
        }
    }

    private static class WindowBackground
    extends JPanel
    implements Skinnable {
        private static final long serialVersionUID = 0L;
        private static final Logger logger = Logger.getLogger(WindowBackground.class);
        private Image bgImage = null;

        public WindowBackground() {
            this.loadSkin();
        }

        public void loadSkin() {
            try {
                this.bgImage = ImageIO.read(BrandingActivator.getResources().getImageURL("plugin.branding.ABOUT_WINDOW_BACKGROUND"));
                this.setPreferredSize(new Dimension(this.bgImage.getWidth(this), this.bgImage.getHeight(this)));
            }
            catch (IOException e) {
                logger.error((Object)"Error cannot obtain background image", (Throwable)e);
                this.bgImage = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g = g.create();
            try {
                AntialiasingManager.activateAntialiasing((Graphics)g);
                int bgImageWidth = this.bgImage.getWidth(null);
                int bgImageHeight = this.bgImage.getHeight(null);
                boolean bgImageHasBeenDrawn = false;
                if (bgImageWidth != -1 && bgImageHeight != -1) {
                    int width = this.getWidth();
                    int height = this.getHeight();
                    if (bgImageWidth < width || bgImageHeight < height) {
                        g.drawImage(this.bgImage, 0, 0, width, height, null);
                        bgImageHasBeenDrawn = true;
                    }
                }
                if (!bgImageHasBeenDrawn) {
                    g.drawImage(this.bgImage, 0, 0, null);
                }
            }
            finally {
                g.dispose();
            }
        }
    }
}

