/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.thunderbird;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.thunderbird.ThunderbirdActivator;
import net.java.sip.communicator.plugin.thunderbird.ThunderbirdContactSourceService;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;

public class ThunderbirdConfigForm
extends TransparentPanel
implements ConfigurationForm,
ActionListener,
DocumentListener {
    private static final long serialVersionUID = 0L;
    private ResourceManagementService R = ThunderbirdActivator.getResources();
    private JTextField txtFilename;
    private JTextField txtPrefix;
    private JButton cmdBrowse;
    private JCheckBox chkEnabled;

    public ThunderbirdConfigForm() {
        super((LayoutManager)new BorderLayout());
        this.initComponents();
    }

    private void initComponents() {
        TransparentPanel pnl = new TransparentPanel();
        pnl.setLayout(new GridLayout(0, 2));
        this.add((Component)pnl, "North");
        this.chkEnabled = new SIPCommCheckBox(this.R.getI18NString("plugin.thunderbird.ENABLED"));
        pnl.add(this.chkEnabled);
        pnl.add(new JLabel(""));
        this.txtFilename = new JTextField();
        this.txtFilename.setEditable(false);
        pnl.add(this.txtFilename);
        this.cmdBrowse = new JButton(this.R.getI18NString("service.gui.BROWSE") + "...");
        pnl.add(this.cmdBrowse);
        JLabel lblPrefix = new JLabel(this.R.getI18NString("plugin.thunderbird.PHONE_PREFIX"));
        pnl.add(lblPrefix);
        this.txtPrefix = new JTextField();
        this.txtPrefix.getDocument().addDocumentListener(this);
        pnl.add(this.txtPrefix);
        List<ThunderbirdContactSourceService> activeServices = ThunderbirdActivator.getActiveServices();
        if (activeServices.size() > 0) {
            this.chkEnabled.setSelected(true);
            ThunderbirdContactSourceService service = activeServices.get(0);
            this.txtFilename.setText(service.getFilename());
            this.txtPrefix.setText(service.getPhoneNumberPrefix());
        } else {
            this.chkEnabled.setSelected(false);
        }
        this.updateStates();
        this.chkEnabled.addActionListener(this);
        this.txtFilename.getDocument().addDocumentListener(this);
        this.cmdBrowse.addActionListener(this);
    }

    public String getTitle() {
        return this.R.getI18NString("plugin.thunderbird.CONFIG_FORM_TITLE");
    }

    public byte[] getIcon() {
        return null;
    }

    public Object getForm() {
        return this;
    }

    public int getIndex() {
        return 3;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmdBrowse) {
            this.browseForMab();
            ThunderbirdActivator.getActiveServices().get(0).setFilename(this.txtFilename.getText());
        } else if (e.getSource() == this.chkEnabled) {
            if (this.chkEnabled.isSelected()) {
                this.browseForMab();
                if (this.txtFilename.getText() != null) {
                    String bprop = "net.java.sip.communicator.plugin.thunderbird.source.1";
                    ConfigurationService config = ThunderbirdActivator.getConfigService();
                    config.setProperty(bprop, (Object)"1");
                    config.setProperty(bprop + "." + "INDEX", (Object)1);
                    config.setProperty(bprop + "." + "FILENAME", (Object)this.txtFilename.getText());
                    config.setProperty(bprop + "." + "DISPLAYNAME", (Object)"Thunderbird");
                    config.setProperty(bprop + "." + "PREFIX", (Object)this.txtPrefix.getText());
                    ThunderbirdActivator.add(bprop);
                }
            } else {
                for (ThunderbirdContactSourceService svc : ThunderbirdActivator.getActiveServices()) {
                    ThunderbirdActivator.remove(svc);
                }
                this.txtFilename.setText(null);
                this.txtPrefix.setText(null);
            }
            this.updateStates();
        }
    }

    private void browseForMab() {
        File f;
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String extension = "";
                int i = name.lastIndexOf(46);
                if (i > 0) {
                    extension = name.substring(i + 1);
                }
                return "mab".equals(extension);
            }
        };
        FileDialog fd = new FileDialog((Frame)null);
        fd.setFilenameFilter(ff);
        if (OSUtils.IS_WINDOWS) {
            f = new File(new File(System.getenv("APPDATA"), "Thunderbird"), "Profiles");
            if (f.exists()) {
                fd.setDirectory(f.getAbsolutePath());
            }
        } else if (OSUtils.IS_LINUX) {
            f = new File(System.getProperty("user.home"), ".thunderbird");
            if (!f.exists()) {
                f = new File(System.getProperty("user.home"), ".mozilla-thunderbird");
            }
            if (f.exists()) {
                fd.setDirectory(f.getAbsolutePath());
            }
        } else if (OSUtils.IS_MAC) {
            f = new File(System.getProperty("user.home"), "/Library/Profiles");
            if (!f.exists()) {
                f = new File(System.getProperty("user.home"), "Application Support/Thunderbird/Profiles");
            }
            if (f.exists()) {
                fd.setDirectory(f.getAbsolutePath());
            }
        }
        fd.setVisible(true);
        if (fd.getFile() != null && (f = new File(fd.getDirectory(), fd.getFile())).exists()) {
            this.txtFilename.setText(f.getAbsolutePath());
        }
    }

    private void updateStates() {
        this.txtFilename.setEnabled(this.chkEnabled.isSelected());
        this.txtPrefix.setEnabled(this.chkEnabled.isSelected());
        this.cmdBrowse.setEnabled(this.chkEnabled.isSelected());
    }

    public boolean isAdvanced() {
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (e.getDocument() == this.txtPrefix.getDocument()) {
            ThunderbirdActivator.getActiveServices().get(0).setPhoneNumberPrefix(this.txtPrefix.getText());
        }
    }
}

