/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.TransformLayer;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;

public class OtrTransformLayer
implements TransformLayer {
    public MessageDeliveredEvent messageDelivered(MessageDeliveredEvent evt) {
        if (OtrActivator.scOtrEngine.isMessageUIDInjected(evt.getSourceMessage().getMessageUID())) {
            return null;
        }
        return evt;
    }

    public MessageDeliveryFailedEvent messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
        return evt;
    }

    public MessageDeliveredEvent[] messageDeliveryPending(MessageDeliveredEvent evt) {
        Contact contact = evt.getDestinationContact();
        OtrContactManager.OtrContact otrContact = OtrContactManager.getOtrContact(contact, evt.getContactResource());
        if (OtrActivator.scOtrEngine.isMessageUIDInjected(evt.getSourceMessage().getMessageUID())) {
            return new MessageDeliveredEvent[]{evt};
        }
        String msgContent = evt.getSourceMessage().getContent();
        String[] processedMessageContent = OtrActivator.scOtrEngine.transformSending(otrContact, msgContent);
        if (processedMessageContent == null || processedMessageContent.length <= 0 || processedMessageContent[0].length() < 1) {
            return new MessageDeliveredEvent[0];
        }
        if (processedMessageContent.length == 1 && processedMessageContent[0].equals(msgContent)) {
            return new MessageDeliveredEvent[]{evt};
        }
        MessageDeliveredEvent[] processedEvents = new MessageDeliveredEvent[processedMessageContent.length];
        for (int i = 0; i < processedMessageContent.length; ++i) {
            String fragmentContent = processedMessageContent[i];
            OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
            Message processedMessage = imOpSet.createMessage(fragmentContent, evt.getSourceMessage().getContentType(), evt.getSourceMessage().getEncoding(), evt.getSourceMessage().getSubject());
            MessageDeliveredEvent processedEvent = new MessageDeliveredEvent(processedMessage, contact, evt.getTimestamp());
            if (processedMessage.getContent().contains("?OTR")) {
                processedEvent.setMessageEncrypted(true);
            }
            processedEvents[i] = processedEvent;
        }
        return processedEvents;
    }

    public MessageReceivedEvent messageReceived(MessageReceivedEvent evt) {
        String msgContent;
        Contact contact = evt.getSourceContact();
        OtrContactManager.OtrContact otrContact = OtrContactManager.getOtrContact(contact, evt.getContactResource());
        String processedMessageContent = OtrActivator.scOtrEngine.transformReceiving(otrContact, msgContent = evt.getSourceMessage().getContent());
        if (processedMessageContent == null || processedMessageContent.length() < 1) {
            return null;
        }
        if (processedMessageContent.equals(msgContent)) {
            return evt;
        }
        OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        Message processedMessage = imOpSet.createMessageWithUID(processedMessageContent, evt.getSourceMessage().getContentType(), evt.getSourceMessage().getMessageUID());
        MessageReceivedEvent processedEvent = new MessageReceivedEvent(processedMessage, contact, evt.getContactResource(), evt.getTimestamp(), evt.getCorrectedMessageUID());
        return processedEvent;
    }
}

