/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr.authdialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.service.protocol.Contact;

public class SmpProgressDialog
extends SIPCommDialog {
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private final Color successColor = new Color(86, 140, 2);
    private final Color failColor = new Color(204, 0, 0);
    private final JLabel iconLabel = new JLabel();

    public SmpProgressDialog(Contact contact) {
        this.setTitle(OtrActivator.resourceService.getI18NString("plugin.otr.smpprogressdialog.TITLE"));
        TransparentPanel mainPanel = new TransparentPanel();
        mainPanel.setLayout(new BoxLayout((Container)mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setPreferredSize(new Dimension(300, 70));
        String authFromText = String.format(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.AUTHENTICATION_FROM", new String[]{contact.getDisplayName()}), new Object[0]);
        TransparentPanel labelsPanel = new TransparentPanel();
        labelsPanel.setLayout(new BoxLayout((Container)labelsPanel, 0));
        labelsPanel.add(this.iconLabel);
        labelsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        labelsPanel.add(new JLabel(authFromText));
        mainPanel.add((Component)labelsPanel);
        mainPanel.add(this.progressBar);
        this.init();
        this.getContentPane().add((Component)mainPanel);
        this.pack();
    }

    public void init() {
        this.progressBar.setUI(new BasicProgressBarUI(){
            private Rectangle r = new Rectangle();

            @Override
            protected void paintIndeterminate(Graphics g, JComponent c) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.r = this.getBox(this.r);
                g.setColor(this.progressBar.getForeground());
                g.fillOval(this.r.x, this.r.y, this.r.width, this.r.height);
            }
        });
        this.progressBar.setValue(33);
        this.progressBar.setForeground(this.successColor);
        this.progressBar.setStringPainted(false);
        this.iconLabel.setIcon(OtrActivator.resourceService.getImage("plugin.otr.ENCRYPTED_UNVERIFIED_ICON_22x22"));
    }

    public void incrementProgress() {
        this.progressBar.setValue(66);
    }

    public void setProgressSuccess() {
        this.progressBar.setValue(100);
        this.progressBar.setForeground(this.successColor);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(OtrActivator.resourceService.getI18NString("plugin.otr.smpprogressdialog.AUTHENTICATION_SUCCESS"));
        this.iconLabel.setIcon(OtrActivator.resourceService.getImage("plugin.otr.ENCRYPTED_ICON_22x22"));
    }

    public void setProgressFail() {
        this.progressBar.setValue(100);
        this.progressBar.setForeground(this.failColor);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(OtrActivator.resourceService.getI18NString("plugin.otr.smpprogressdialog.AUTHENTICATION_FAIL"));
    }
}

