/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;

public abstract class AbstractAddrBookContactQuery<T extends ContactSourceService>
extends AsyncContactQuery<T> {
    protected final List<SourceContact> sourceContacts = new LinkedList<SourceContact>();

    public AbstractAddrBookContactQuery(T contactSource, Pattern query) {
        super(contactSource, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactReceived(SourceContact contact) {
        List<SourceContact> list = this.sourceContacts;
        synchronized (list) {
            this.sourceContacts.add(contact);
        }
        super.fireContactReceived(contact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactRemoved(SourceContact contact) {
        List<SourceContact> list = this.sourceContacts;
        synchronized (list) {
            this.sourceContacts.remove(contact);
        }
        super.fireContactRemoved(contact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<SourceContact> list = this.sourceContacts;
        synchronized (list) {
            this.sourceContacts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceContact findSourceContactByID(String id) {
        List<SourceContact> list = this.sourceContacts;
        synchronized (list) {
            for (SourceContact sc : this.sourceContacts) {
                Object scID = sc.getData((Object)SourceContact.DATA_ID);
                if (!id.equals(scID)) continue;
                return sc;
            }
        }
        return null;
    }
}

