/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.macosx;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.java.sip.communicator.plugin.addrbook.AbstractAddrBookContactQuery;
import net.java.sip.communicator.plugin.addrbook.AddrBookActivator;
import net.java.sip.communicator.plugin.addrbook.PtrCallback;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookContactDetail;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookContactSourceService;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookSourceContact;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.util.Logger;

public class MacOSXAddrBookContactQuery
extends AbstractAddrBookContactQuery<MacOSXAddrBookContactSourceService> {
    private static final Logger logger = Logger.getLogger(MacOSXAddrBookContactQuery.class);
    public static final long[] ABPERSON_PROPERTIES = new long[]{MacOSXAddrBookContactQuery.kABAIMInstantProperty(), MacOSXAddrBookContactQuery.kABEmailProperty(), MacOSXAddrBookContactQuery.kABFirstNameProperty(), MacOSXAddrBookContactQuery.kABFirstNamePhoneticProperty(), MacOSXAddrBookContactQuery.kABICQInstantProperty(), MacOSXAddrBookContactQuery.kABJabberInstantProperty(), MacOSXAddrBookContactQuery.kABLastNameProperty(), MacOSXAddrBookContactQuery.kABLastNamePhoneticProperty(), MacOSXAddrBookContactQuery.kABMiddleNameProperty(), MacOSXAddrBookContactQuery.kABMiddleNamePhoneticProperty(), MacOSXAddrBookContactQuery.kABMSNInstantProperty(), MacOSXAddrBookContactQuery.kABNicknameProperty(), MacOSXAddrBookContactQuery.kABPhoneProperty(), MacOSXAddrBookContactQuery.kABYahooInstantProperty(), MacOSXAddrBookContactQuery.kABPersonFlags(), MacOSXAddrBookContactQuery.kABOrganizationProperty(), MacOSXAddrBookContactQuery.kABMaidenNameProperty(), MacOSXAddrBookContactQuery.kABBirthdayProperty(), MacOSXAddrBookContactQuery.kABJobTitleProperty(), MacOSXAddrBookContactQuery.kABHomePageProperty(), MacOSXAddrBookContactQuery.kABURLsProperty(), MacOSXAddrBookContactQuery.kABCalendarURIsProperty(), MacOSXAddrBookContactQuery.kABAddressProperty(), MacOSXAddrBookContactQuery.kABOtherDatesProperty(), MacOSXAddrBookContactQuery.kABRelatedNamesProperty(), MacOSXAddrBookContactQuery.kABDepartmentProperty(), MacOSXAddrBookContactQuery.kABNoteProperty(), MacOSXAddrBookContactQuery.kABTitleProperty(), MacOSXAddrBookContactQuery.kABSuffixProperty()};
    public static final int kABAIMInstantProperty = 0;
    public static final int kABEmailProperty = 1;
    public static final int kABFirstNameProperty = 2;
    public static final int kABFirstNamePhoneticProperty = 3;
    public static final int kABICQInstantProperty = 4;
    public static final int kABJabberInstantProperty = 5;
    public static final int kABLastNameProperty = 6;
    public static final int kABLastNamePhoneticProperty = 7;
    public static final int kABMiddleNameProperty = 8;
    public static final int kABMiddleNamePhoneticProperty = 9;
    public static final int kABMSNInstantProperty = 10;
    public static final int kABNicknameProperty = 11;
    public static final int kABOrganizationProperty = 15;
    public static final int kABPersonFlags = 14;
    public static final int kABPhoneProperty = 12;
    public static final long kABShowAsCompany = 1L;
    public static final long kABShowAsMask = 7L;
    public static final int kABYahooInstantProperty = 13;
    public static final int kABMaidenNameProperty = 16;
    public static final int kABBirthdayProperty = 17;
    public static final int kABJobTitleProperty = 18;
    public static final int kABHomePageProperty = 19;
    public static final int kABURLsProperty = 20;
    public static final int kABCalendarURIsProperty = 21;
    public static final int kABAddressProperty = 22;
    public static final int kABOtherDatesProperty = 23;
    public static final int kABRelatedNamesProperty = 24;
    public static final int kABDepartmentProperty = 25;
    public static final int kABNoteProperty = 26;
    public static final int kABTitleProperty = 27;
    public static final int kABSuffixProperty = 28;
    private static final Pattern LABEL_PATTERN = Pattern.compile("kAB|Email|Phone|Label|(\\p{Punct}*)", 2);

    public MacOSXAddrBookContactQuery(MacOSXAddrBookContactSourceService contactSource, Pattern query) {
        super(contactSource, query);
    }

    public static native byte[] ABPerson_imageData(long var0);

    public static native Object[] ABRecord_valuesForProperties(long var0, long[] var2);

    public static native String ABRecord_uniqueId(long var0);

    public static native boolean setProperty(String var0, long var1, String var3, Object var4);

    public static native boolean removeProperty(String var0, long var1);

    public static native boolean deleteContact(String var0);

    public static native String createContact();

    public static native long getContactPointer(String var0);

    private ContactDetail createContactDetail(int property, String contactAddress, Object label, String additionalProperty, String id) {
        ContactDetail.Category c;
        Object sc = null;
        switch (property) {
            case 1: {
                c = ContactDetail.Category.Email;
                break;
            }
            case 12: {
                c = ContactDetail.Category.Phone;
                break;
            }
            case 0: {
                sc = ContactDetail.SubCategory.AIM;
                c = ContactDetail.Category.InstantMessaging;
                break;
            }
            case 4: {
                sc = ContactDetail.SubCategory.ICQ;
                c = ContactDetail.Category.InstantMessaging;
                break;
            }
            case 5: {
                sc = ContactDetail.SubCategory.Jabber;
                c = ContactDetail.Category.InstantMessaging;
                break;
            }
            case 10: {
                sc = ContactDetail.SubCategory.Skype;
                c = ContactDetail.Category.InstantMessaging;
                break;
            }
            case 13: {
                sc = ContactDetail.SubCategory.Yahoo;
                c = ContactDetail.Category.InstantMessaging;
                break;
            }
            case 2: 
            case 16: {
                sc = ContactDetail.SubCategory.Name;
                c = ContactDetail.Category.Personal;
                break;
            }
            case 3: {
                sc = ContactDetail.SubCategory.Name;
                c = ContactDetail.Category.Personal;
                break;
            }
            case 6: {
                sc = ContactDetail.SubCategory.LastName;
                c = ContactDetail.Category.Personal;
                break;
            }
            case 7: {
                sc = ContactDetail.SubCategory.LastName;
                c = ContactDetail.Category.Personal;
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                sc = ContactDetail.SubCategory.Nickname;
                c = ContactDetail.Category.Personal;
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                sc = ContactDetail.SubCategory.HomePage;
                c = ContactDetail.Category.Personal;
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                c = ContactDetail.Category.Personal;
                break;
            }
            case 15: 
            case 18: {
                sc = ContactDetail.SubCategory.JobTitle;
                c = ContactDetail.Category.Organization;
                break;
            }
            case 25: {
                c = ContactDetail.Category.Organization;
                sc = ContactDetail.SubCategory.Name;
                break;
            }
            case 22: {
                c = ContactDetail.Category.Address;
                break;
            }
            default: {
                c = null;
            }
        }
        if (sc == null) {
            sc = label == null ? null : this.getSubCategoryFromLabel(label);
        }
        ContactDetail.SubCategory additionalSubCategory = null;
        if (additionalProperty != null) {
            additionalSubCategory = this.getSubCategoryFromLabel(additionalProperty);
        }
        ContactDetail.SubCategory[] subCategories = additionalSubCategory != null ? new ContactDetail.SubCategory[]{sc, additionalSubCategory} : new ContactDetail.SubCategory[]{sc};
        return new MacOSXAddrBookContactDetail(property, contactAddress, c, subCategories, additionalProperty, id);
    }

    private ContactDetail.SubCategory getSubCategoryFromLabel(Object label) {
        String labelString = LABEL_PATTERN.matcher((String)label).replaceAll("").trim();
        if (labelString.length() < 1) {
            return null;
        }
        ContactDetail.SubCategory subCategory = null;
        if (labelString.equalsIgnoreCase("home")) {
            subCategory = ContactDetail.SubCategory.Home;
        } else if (labelString.equalsIgnoreCase("work")) {
            subCategory = ContactDetail.SubCategory.Work;
        } else if (labelString.equalsIgnoreCase("other")) {
            subCategory = ContactDetail.SubCategory.Other;
        } else if (labelString.equalsIgnoreCase("mobile")) {
            subCategory = ContactDetail.SubCategory.Mobile;
        } else if (labelString.equalsIgnoreCase("homepage")) {
            subCategory = ContactDetail.SubCategory.HomePage;
        } else if (labelString.equalsIgnoreCase("street")) {
            subCategory = ContactDetail.SubCategory.Street;
        } else if (labelString.equalsIgnoreCase("state")) {
            subCategory = ContactDetail.SubCategory.State;
        } else if (labelString.equalsIgnoreCase("ZIP")) {
            subCategory = ContactDetail.SubCategory.PostalCode;
        } else if (labelString.equalsIgnoreCase("country")) {
            subCategory = ContactDetail.SubCategory.Country;
        } else if (labelString.equalsIgnoreCase("city")) {
            subCategory = ContactDetail.SubCategory.City;
        } else if (labelString.equalsIgnoreCase("InstantMessageUsername")) {
            subCategory = ContactDetail.SubCategory.Nickname;
        } else if (labelString.equalsIgnoreCase("workfax")) {
            subCategory = ContactDetail.SubCategory.Fax;
        } else if (labelString.equalsIgnoreCase("fax")) {
            subCategory = ContactDetail.SubCategory.Fax;
        }
        return subCategory;
    }

    private static native void foreachPerson(String var0, PtrCallback var1);

    private List<ContactDetail> getContactDetails(Object[] values, String id) {
        LinkedList<ContactDetail> contactDetails = new LinkedList<ContactDetail>();
        for (int i = 0; i < ABPERSON_PROPERTIES.length; ++i) {
            int property = i;
            Object value = values[property];
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.length() == 0) continue;
                if (12 == property) {
                    stringValue = AddrBookActivator.getPhoneNumberI18nService().normalize(stringValue);
                }
                contactDetails.add(this.setCapabilities(this.createContactDetail(property, stringValue, null, null, id), property));
                continue;
            }
            if (!(value instanceof Object[])) continue;
            this.parseMultiDetails(contactDetails, (Object[])value, property, null, id);
        }
        return contactDetails;
    }

    private void parseMultiDetails(List<ContactDetail> contactDetails, Object[] multiValue, int property, String label, String id) {
        if (multiValue == null) {
            return;
        }
        for (int multiValueIndex = 0; multiValueIndex < multiValue.length; multiValueIndex += 2) {
            Object subValue = multiValue[multiValueIndex];
            if (subValue instanceof String) {
                String stringSubValue = (String)subValue;
                if (stringSubValue.length() == 0) continue;
                if (12 == property) {
                    stringSubValue = AddrBookActivator.getPhoneNumberI18nService().normalize(stringSubValue);
                }
                Object l = multiValue[multiValueIndex + 1];
                contactDetails.add(this.setCapabilities(this.createContactDetail(property, stringSubValue, l, label, id), property));
                continue;
            }
            if (!(subValue instanceof Object[])) continue;
            String l = null;
            Object lObject = multiValue[multiValueIndex + 1];
            if (lObject instanceof String) {
                l = (String)lObject;
            }
            this.parseMultiDetails(contactDetails, (Object[])subValue, property, l, id);
        }
    }

    private static String getDisplayName(Object[] values) {
        String lastName;
        String firstName;
        String displayName;
        long personFlags;
        long l = personFlags = values[14] instanceof Long ? (Long)values[14] : 0L;
        if ((personFlags & 7L) == 1L) {
            String string = displayName = values[15] instanceof String ? (String)values[15] : "";
            if (displayName.length() != 0) {
                return displayName;
            }
        }
        String string = displayName = values[11] instanceof String ? (String)values[11] : "";
        if (displayName.length() != 0) {
            return displayName;
        }
        String string2 = firstName = values[2] instanceof String ? (String)values[2] : "";
        if (firstName.length() == 0 && values[3] instanceof String) {
            firstName = (String)values[3];
        }
        String string3 = lastName = values[6] instanceof String ? (String)values[6] : "";
        if (lastName.length() == 0 && values[7] instanceof String) {
            lastName = (String)values[7];
        }
        if (lastName.length() == 0 && values[8] instanceof String) {
            lastName = (String)values[8];
        }
        if (lastName.length() == 0 && values[9] instanceof String) {
            lastName = (String)values[9];
        }
        if (firstName.length() == 0) {
            displayName = lastName;
        } else {
            String string4 = displayName = lastName.length() == 0 ? firstName : firstName + " " + lastName;
        }
        if (displayName.length() != 0) {
            return displayName;
        }
        block0: for (int i = 0; i < ABPERSON_PROPERTIES.length; ++i) {
            Object value = values[i];
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.length() == 0) continue;
                displayName = stringValue;
                break;
            }
            if (!(value instanceof Object[])) continue;
            Object[] multiValue = (Object[])value;
            for (int multiValueIndex = 0; multiValueIndex < multiValue.length; multiValueIndex += 2) {
                String stringSubValue;
                Object subValue = multiValue[multiValueIndex];
                if (!(subValue instanceof String) || (stringSubValue = (String)subValue).length() == 0) continue;
                displayName = stringSubValue;
                continue block0;
            }
        }
        return displayName;
    }

    private static String getOrganization(Object[] values) {
        long personFlags;
        String organization = "";
        long l = personFlags = values[14] instanceof Long ? (Long)values[14] : 0L;
        if ((personFlags & 7L) != 1L) {
            organization = values[15] instanceof String ? (String)values[15] : "";
        }
        return organization;
    }

    public static native long kABAIMInstantProperty();

    public static native long kABEmailProperty();

    public static native long kABFirstNameProperty();

    public static native long kABFirstNamePhoneticProperty();

    public static native long kABICQInstantProperty();

    public static native long kABJabberInstantProperty();

    public static native long kABLastNameProperty();

    public static native long kABLastNamePhoneticProperty();

    public static native long kABMiddleNameProperty();

    public static native long kABMiddleNamePhoneticProperty();

    public static native long kABMSNInstantProperty();

    public static native long kABNicknameProperty();

    public static native long kABOrganizationProperty();

    public static native long kABPersonFlags();

    public static native long kABPhoneProperty();

    public static native long kABYahooInstantProperty();

    public static native long kABMaidenNameProperty();

    public static native long kABBirthdayProperty();

    public static native long kABJobTitleProperty();

    public static native long kABHomePageProperty();

    public static native long kABURLsProperty();

    public static native long kABCalendarURIsProperty();

    public static native long kABAddressProperty();

    public static native long kABOtherDatesProperty();

    public static native long kABRelatedNamesProperty();

    public static native long kABDepartmentProperty();

    public static native long kABInstantMessageProperty();

    public static native long kABNoteProperty();

    public static native long kABTitleProperty();

    public static native long kABSuffixProperty();

    public static native String kABEmailWorkLabel();

    public static native String kABEmailHomeLabel();

    public static native String kABAddressHomeLabel();

    public static native String kABAddressWorkLabel();

    public static native String kABPhoneWorkLabel();

    public static native String kABPhoneHomeLabel();

    public static native String kABPhoneMobileLabel();

    public static native String kABPhoneMainLabel();

    public static native String kABPhoneWorkFAXLabel();

    public static native String kABHomeLabel();

    public static native String kABWorkLabel();

    public static native String kABOtherLabel();

    public static native String kABAddressStreetKey();

    public static native String kABAddressCityKey();

    public static native String kABAddressStateKey();

    public static native String kABAddressZIPKey();

    public static native String kABAddressCountryKey();

    private boolean matches(int property, String value) {
        return this.query.matcher(value).find() || 12 == property && this.phoneNumberMatches(value);
    }

    private boolean matches(Object[] values) {
        int property = 0;
        for (Object value : values) {
            if (value instanceof String) {
                if (this.matches(property, (String)value)) {
                    return true;
                }
            } else if (value instanceof Object[]) {
                Object[] multiValue = (Object[])value;
                for (int multiValueIndex = 0; multiValueIndex < multiValue.length; multiValueIndex += 2) {
                    Object subValue = multiValue[multiValueIndex];
                    if (!(subValue instanceof String) || !this.matches(property, (String)subValue)) continue;
                    return true;
                }
            }
            ++property;
        }
        return false;
    }

    private boolean onPerson(long person) {
        List<ContactDetail> contactDetails;
        Object[] values = MacOSXAddrBookContactQuery.ABRecord_valuesForProperties(person, ABPERSON_PROPERTIES);
        String id = MacOSXAddrBookContactQuery.ABRecord_uniqueId(person);
        String displayName = MacOSXAddrBookContactQuery.getDisplayName(values);
        if (displayName.length() != 0 && (this.query.matcher(displayName).find() || this.matches(values)) && !(contactDetails = this.getContactDetails(values, id)).isEmpty()) {
            MacOSXAddrBookSourceContact sourceContact = new MacOSXAddrBookSourceContact(this.getContactSource(), displayName, contactDetails);
            sourceContact.setData(SourceContact.DATA_ID, id);
            sourceContact.setDisplayDetails(MacOSXAddrBookContactQuery.getOrganization(values));
            try {
                byte[] image = MacOSXAddrBookContactQuery.ABPerson_imageData(person);
                if (image != null) {
                    sourceContact.setImage(image);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            this.addQueryResult((SourceContact)sourceContact);
        }
        return this.getStatus() == 3;
    }

    protected void run() {
        MacOSXAddrBookContactQuery.foreachPerson(this.query.toString(), new PtrCallback(){

            @Override
            public boolean callback(long person) {
                return MacOSXAddrBookContactQuery.this.onPerson(person);
            }
        });
    }

    private ContactDetail setCapabilities(ContactDetail contactDetail, int property) {
        LinkedList<Class<OperationSetBasicTelephony>> supportedOpSets = new LinkedList<Class<OperationSetBasicTelephony>>();
        HashMap<Class, String> preferredProtocols = new HashMap<Class, String>();
        supportedOpSets.add(OperationSetPersistentPresence.class);
        switch (property) {
            case 0: {
                supportedOpSets.add(OperationSetBasicInstantMessaging.class);
                preferredProtocols.put(OperationSetBasicInstantMessaging.class, "AIM");
                break;
            }
            case 1: {
                supportedOpSets.add(OperationSetBasicTelephony.class);
                break;
            }
            case 4: {
                supportedOpSets.add(OperationSetBasicInstantMessaging.class);
                preferredProtocols.put(OperationSetBasicInstantMessaging.class, "ICQ");
                break;
            }
            case 5: {
                supportedOpSets.add(OperationSetBasicInstantMessaging.class);
                preferredProtocols.put(OperationSetBasicInstantMessaging.class, "Jabber");
                supportedOpSets.add(OperationSetBasicTelephony.class);
                preferredProtocols.put(OperationSetBasicTelephony.class, "Jabber");
                break;
            }
            case 12: {
                supportedOpSets.add(OperationSetBasicTelephony.class);
                break;
            }
        }
        contactDetail.setSupportedOpSets(supportedOpSets);
        if (!preferredProtocols.isEmpty()) {
            contactDetail.setPreferredProtocols(preferredProtocols);
        }
        return contactDetail;
    }

    public void inserted(long person) {
        this.onPerson(person);
    }

    public void updated(long person) {
        SourceContact sourceContact = this.findSourceContactByID(MacOSXAddrBookContactQuery.ABRecord_uniqueId(person));
        if (sourceContact != null && sourceContact instanceof MacOSXAddrBookSourceContact) {
            Object[] values = MacOSXAddrBookContactQuery.ABRecord_valuesForProperties(person, ABPERSON_PROPERTIES);
            String displayName = MacOSXAddrBookContactQuery.getDisplayName(values);
            String id = MacOSXAddrBookContactQuery.ABRecord_uniqueId(person);
            MacOSXAddrBookSourceContact editableSourceContact = (MacOSXAddrBookSourceContact)sourceContact;
            editableSourceContact.setDisplayName(displayName);
            editableSourceContact.setDisplayDetails(MacOSXAddrBookContactQuery.getOrganization(values));
            List<ContactDetail> contactDetails = this.getContactDetails(values, id);
            editableSourceContact.setDetails(contactDetails);
            this.fireContactChanged(sourceContact);
        }
    }

    public void deleted(String id) {
        SourceContact sourceContact = this.findSourceContactByID(id);
        if (sourceContact != null) {
            this.fireContactRemoved(sourceContact);
        }
    }

    public static int getProperty(ContactDetail.Category category, Collection<ContactDetail.SubCategory> subCategories) {
        switch (category) {
            case Personal: {
                if (subCategories.contains(ContactDetail.SubCategory.Name)) {
                    return 2;
                }
                if (subCategories.contains(ContactDetail.SubCategory.LastName)) {
                    return 6;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Nickname)) {
                    return 11;
                }
                if (!subCategories.contains(ContactDetail.SubCategory.HomePage)) break;
                return 19;
            }
            case Organization: {
                if (subCategories.contains(ContactDetail.SubCategory.JobTitle)) {
                    return 18;
                }
                return 25;
            }
            case Email: {
                return 1;
            }
            case InstantMessaging: {
                if (subCategories.contains(ContactDetail.SubCategory.AIM)) {
                    return 0;
                }
                if (subCategories.contains(ContactDetail.SubCategory.ICQ)) {
                    return 4;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Skype)) {
                    return 10;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Jabber)) {
                    return 5;
                }
                if (!subCategories.contains(ContactDetail.SubCategory.Yahoo)) break;
                return 13;
            }
            case Phone: {
                return 12;
            }
            case Address: {
                return 22;
            }
            default: {
                return -1;
            }
        }
        return -1;
    }

    public static String getLabel(int property, ContactDetail.SubCategory subCategory, String subProperty) {
        switch (property) {
            case 1: {
                if (subCategory == ContactDetail.SubCategory.Home) {
                    return MacOSXAddrBookContactQuery.kABEmailHomeLabel();
                }
                if (subCategory != ContactDetail.SubCategory.Work) break;
                return MacOSXAddrBookContactQuery.kABEmailWorkLabel();
            }
            case 0: 
            case 4: 
            case 5: 
            case 10: 
            case 13: {
                return subProperty;
            }
            case 12: {
                if (subCategory == ContactDetail.SubCategory.Home) {
                    return MacOSXAddrBookContactQuery.kABPhoneHomeLabel();
                }
                if (subCategory == ContactDetail.SubCategory.Work) {
                    return MacOSXAddrBookContactQuery.kABPhoneWorkLabel();
                }
                if (subCategory == ContactDetail.SubCategory.Fax) {
                    return MacOSXAddrBookContactQuery.kABPhoneWorkFAXLabel();
                }
                if (subCategory == ContactDetail.SubCategory.Mobile) {
                    return MacOSXAddrBookContactQuery.kABPhoneMobileLabel();
                }
                if (subCategory != ContactDetail.SubCategory.Other) break;
                return "other";
            }
            case 22: {
                if (subCategory == ContactDetail.SubCategory.Street) {
                    return MacOSXAddrBookContactQuery.kABAddressStreetKey();
                }
                if (subCategory == ContactDetail.SubCategory.City) {
                    return MacOSXAddrBookContactQuery.kABAddressCityKey();
                }
                if (subCategory == ContactDetail.SubCategory.State) {
                    return MacOSXAddrBookContactQuery.kABAddressStateKey();
                }
                if (subCategory == ContactDetail.SubCategory.Country) {
                    return MacOSXAddrBookContactQuery.kABAddressCountryKey();
                }
                if (subCategory != ContactDetail.SubCategory.PostalCode) break;
                return MacOSXAddrBookContactQuery.kABAddressZIPKey();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public void addEmptyContact(String id) {
        if (id != null) {
            MacOSXAddrBookSourceContact sourceContact = new MacOSXAddrBookSourceContact(this.getContactSource(), null, new LinkedList<ContactDetail>());
            sourceContact.setData(SourceContact.DATA_ID, id);
            this.addQueryResult((SourceContact)sourceContact);
        }
    }

    public void contactChanged(SourceContact sourceContact) {
        this.fireContactChanged(sourceContact);
    }

    static {
        System.loadLibrary("jmacosxaddrbook");
    }
}

