/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.contactlist;

import java.util.Iterator;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.contactlist.MclSlickFixture;
import net.java.sip.communicator.slick.contactlist.MetaContactListServiceLick;

public class TestMetaContactGroup
extends TestCase {
    MclSlickFixture fixture = new MclSlickFixture(((Object)((Object)this)).getClass().getName());
    MetaContactGroup metaGroup = null;
    MockContactGroup mockGroup = null;

    public TestMetaContactGroup(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        OperationSetPersistentPresence opSetPresence = (OperationSetPersistentPresence)MclSlickFixture.mockProvider.getOperationSet(OperationSetPersistentPresence.class);
        this.mockGroup = (MockContactGroup)opSetPresence.getServerStoredContactListRoot();
        this.mockGroup = (MockContactGroup)this.mockGroup.getGroup("SomePeople");
        this.metaGroup = this.fixture.metaClService.getRoot().getMetaContactSubgroup(this.mockGroup.getGroupName());
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        this.fixture = null;
        super.tearDown();
    }

    public void testCountChildContacts() {
        TestMetaContactGroup.assertEquals((String)"MetaContactGroup.countChildContacts failed", (int)this.metaGroup.countChildContacts(), (int)this.mockGroup.countContacts());
    }

    public void testCountSubgroups() {
        TestMetaContactGroup.assertEquals((String)"MetaContactGroup.countChildContacts failed", (int)this.metaGroup.countSubgroups(), (int)this.mockGroup.countSubgroups());
    }

    public void testGetChildContacts() {
        Iterator childContactsIter = this.metaGroup.getChildContacts();
        TestMetaContactGroup.assertNotNull((String)"getChildContacts() returned a null iterator.", (Object)childContactsIter);
        TestMetaContactGroup.assertTrue((String)"getChildContacts() returned an empty iterator.", (boolean)childContactsIter.hasNext());
    }

    public void testGetContactGroup() {
        ContactGroup actualReturn = this.metaGroup.getContactGroup(this.mockGroup.getGroupName(), (ProtocolProviderService)MclSlickFixture.mockProvider);
        TestMetaContactGroup.assertNotNull((String)"getContactGroup() return null.", (Object)actualReturn);
        TestMetaContactGroup.assertSame((String)"getContactGroup() did not return the right proto group.", (Object)actualReturn, (Object)this.mockGroup);
    }

    public void testGetContactGroups() {
        Iterator contactGroups = this.metaGroup.getContactGroups();
        TestMetaContactGroup.assertNotNull((String)"contact groups iterator", (Object)contactGroups);
        TestMetaContactGroup.assertTrue((String)"The contact groups iterator was empty.", (boolean)contactGroups.hasNext());
        ContactGroup actualMockGroup = (ContactGroup)contactGroups.next();
        TestMetaContactGroup.assertSame((String)"Iterator did not contain the right contact group", (Object)this.mockGroup, (Object)actualMockGroup);
    }

    public void testGetContactGroupsForProvider() {
        Iterator contactGroups = this.metaGroup.getContactGroups();
        TestMetaContactGroup.assertNotNull((String)"contact groups for provider iterator", (Object)contactGroups);
        TestMetaContactGroup.assertTrue((String)"The contact groups iterator was empty for a mock provider.", (boolean)contactGroups.hasNext());
        ContactGroup actualMockGroup = (ContactGroup)contactGroups.next();
        TestMetaContactGroup.assertSame((String)"A prov. iterator did not contain the right contact group", (Object)this.mockGroup, (Object)actualMockGroup);
    }

    public void testGetGroupName() {
        TestMetaContactGroup.assertEquals((String)("grp: " + this.metaGroup + " had the wrong name."), (String)"SomePeople", (String)this.metaGroup.getGroupName());
    }

    public void testGetMetaContact() {
        MetaContact firstContact = this.metaGroup.getMetaContact(0);
        MetaContact lastContact = this.metaGroup.getMetaContact(this.metaGroup.countChildContacts() - 1);
        TestMetaContactGroup.assertNotNull((String)"getMetaContact(int) returned null for contact 0", (Object)firstContact);
        TestMetaContactGroup.assertNotNull((String)("getMetaContact(int) returned null for its last contact " + (this.metaGroup.countChildContacts() - 1)), (Object)lastContact);
    }

    public void testGetMetaContact2() {
        Iterator childContactsIter = this.metaGroup.getChildContacts();
        TestMetaContactGroup.assertNotNull((String)"getChildContacts() returned a null iterator.", (Object)childContactsIter);
        TestMetaContactGroup.assertTrue((String)"getChildContacts() returned an empty iterator.", (boolean)childContactsIter.hasNext());
        MetaContact expectedChild = (MetaContact)childContactsIter.next();
        MetaContact actualChild = this.metaGroup.getMetaContact(expectedChild.getMetaUID());
        TestMetaContactGroup.assertSame((String)"getMetaContact(metaUID) did not return as expected.", (Object)expectedChild, (Object)actualChild);
    }

    public void testGetMetaContact3() {
        MetaContactGroup metaContactGroup1 = this.fixture.metaClService.findMetaContactGroupByContactGroup((ContactGroup)MetaContactListServiceLick.topLevelMockGroup);
        MetaContact metaContact = metaContactGroup1.getMetaContact((ProtocolProviderService)MclSlickFixture.mockProvider, "Spencer");
        TestMetaContactGroup.assertNotNull((String)"getMetaCont(prov, contactID) returned a MetaC that didn't contain our contact", (Object)metaContact.getContact("Spencer", (ProtocolProviderService)MclSlickFixture.mockProvider));
        TestMetaContactGroup.assertEquals((String)"getMetaCont(prov, contactID) returned a MetaC with a wrong name ", (String)metaContact.getDisplayName(), (String)"Spencer");
    }

    public void testGetMetaContactSubgroup() {
        MetaContactGroup actualGroup = this.metaGroup.getMetaContactSubgroup(0);
        TestMetaContactGroup.assertNotNull((String)"getMetaContact(int) returned null for group 0", (Object)actualGroup);
        TestMetaContactGroup.assertNotNull((String)"The returned group does not appear to really exist", (Object)this.mockGroup.getGroup(actualGroup.getGroupName()));
        TestMetaContactGroup.assertNotNull((String)"Group encapsulated in the returned group did not match", (Object)this.mockGroup.getGroup(((ContactGroup)actualGroup.getContactGroups().next()).getGroupName()));
    }

    public void testGetMetaContactSubgroup2() {
        MetaContactGroup actualGroup = this.metaGroup.getMetaContactSubgroup(((MetaContactGroup)this.metaGroup.getSubgroups().next()).getGroupName());
        TestMetaContactGroup.assertNotNull((String)"getMetaContact(String) returned null for group 0", (Object)actualGroup);
    }

    public void testContains() {
        MetaContactGroup metaContactGroup1 = this.fixture.metaClService.findMetaContactGroupByContactGroup((ContactGroup)MetaContactListServiceLick.topLevelMockGroup);
        MetaContact metaContact = this.fixture.metaClService.findMetaContactByContact((Contact)MetaContactListServiceLick.subLevelContact);
        TestMetaContactGroup.assertTrue((boolean)metaContactGroup1.contains(metaContact));
    }

    public void testContains2() {
        MetaContactGroup metaContactGroup1 = this.fixture.metaClService.findMetaContactGroupByContactGroup((ContactGroup)MetaContactListServiceLick.topLevelMockGroup);
        MetaContactGroup metaContactGroup2 = metaContactGroup1.getMetaContactSubgroup(MetaContactListServiceLick.subLevelGroup.getGroupName());
        TestMetaContactGroup.assertTrue((boolean)metaContactGroup1.contains(metaContactGroup2));
    }

    public void testGetSubgroups() {
        Iterator subgroupsIter = this.metaGroup.getSubgroups();
        TestMetaContactGroup.assertNotNull((String)"getSubgroup() returned a null iterator.", (Object)subgroupsIter);
        TestMetaContactGroup.assertTrue((String)"getSubgroups() returned an empty iterator.", (boolean)subgroupsIter.hasNext());
    }

    public void testIndexOf1() {
        MetaContactGroup metaContactGroup = this.fixture.metaClService.findMetaContactGroupByContactGroup((ContactGroup)MetaContactListServiceLick.topLevelMockGroup);
        for (int i = 0; i < metaContactGroup.countChildContacts(); ++i) {
            MetaContact currentMetaContact = metaContactGroup.getMetaContact(i);
            TestMetaContactGroup.assertEquals((String)("indexOf failed for " + currentMetaContact), (int)i, (int)metaContactGroup.indexOf(currentMetaContact));
        }
    }

    public void testIndexOf2() {
        MetaContactGroup metaContactGroup = this.fixture.metaClService.getRoot();
        for (int i = 0; i < metaContactGroup.countSubgroups(); ++i) {
            MetaContactGroup currentMetaContactGroup = metaContactGroup.getMetaContactSubgroup(i);
            TestMetaContactGroup.assertEquals((String)("indexOf failed for " + currentMetaContactGroup), (int)i, (int)metaContactGroup.indexOf(currentMetaContactGroup));
        }
    }
}

