/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class SimpleServiceActivator<T>
implements BundleActivator {
    private final Logger logger;
    private final Class<?> serviceClass;
    private final String serviceName;
    protected T serviceImpl;

    public SimpleServiceActivator(Class<?> serviceClass, String serviceName) {
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.serviceImpl = this.createServiceImpl();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.serviceName + " STARTED");
        }
        bundleContext.registerService(this.serviceClass.getName(), this.serviceImpl, null);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.serviceName + " REGISTERED");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    protected abstract T createServiceImpl();
}

