/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.generic;

import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationReceivedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationRejectedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomParticipantPresenceChangeEvent;
import net.java.sip.communicator.slick.protocol.generic.AHMUCEventCollector;
import net.java.sip.communicator.slick.protocol.generic.AdHocMultiUserChatSlickFixture;
import net.java.sip.communicator.slick.protocol.generic.AuthHandler;
import net.java.sip.communicator.util.Logger;

public abstract class TestOperationSetAdHocMultiUserChat
extends TestCase {
    private Logger logger = Logger.getLogger(TestOperationSetAdHocMultiUserChat.class);
    protected static String adHocChatRoomName = "AdHocMUC-test";
    protected static String invitationReason = "Free 4 a chat?";
    protected static String invitationRejectReason = "Sorry, no time 4 U.";
    protected AdHocMultiUserChatSlickFixture fixture = null;
    public OperationSetPresence opSetPresence1 = null;
    public OperationSetPresence opSetPresence2 = null;
    public OperationSetPresence opSetPresence3 = null;
    public OperationSetAdHocMultiUserChat opSetAHMUC1 = null;
    public OperationSetAdHocMultiUserChat opSetAHMUC2 = null;
    public OperationSetAdHocMultiUserChat opSetAHMUC3 = null;

    public TestOperationSetAdHocMultiUserChat(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.start();
    }

    public void tearDown() throws Exception {
        this.fixture.tearDown();
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateRoom() throws OperationFailedException, OperationNotSupportedException {
        Object wait;
        AdHocChatRoom adHocChatRoom = this.opSetAHMUC1.createAdHocChatRoom(adHocChatRoomName, new Hashtable());
        TestOperationSetAdHocMultiUserChat.assertNotNull((String)"The created ad-hoc room is null.", (Object)adHocChatRoom);
        Object object = wait = new Object();
        synchronized (object) {
            try {
                wait.wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The room can't be retrieved", (int)1, (int)this.opSetAHMUC1.getAdHocChatRooms().size());
    }

    public void testCreateRoomWithParticipants() throws OperationFailedException, OperationNotSupportedException {
        ArrayList<String> contacts = new ArrayList<String>();
        contacts.add(this.fixture.userID2);
        contacts.add(this.fixture.userID3);
        AHMUCEventCollector collectorUser1 = null;
        AHMUCEventCollector collectorUser2 = new AHMUCEventCollector(this.opSetAHMUC2, 3);
        AHMUCEventCollector collectorUser3 = new AHMUCEventCollector(this.opSetAHMUC3, 3);
        AdHocChatRoom room = this.opSetAHMUC1.createAdHocChatRoom(adHocChatRoomName, contacts, invitationReason);
        TestOperationSetAdHocMultiUserChat.assertNotNull((String)"Returned room is null", (Object)room);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The room can't be retrieved", (int)1, (int)this.opSetAHMUC1.getAdHocChatRooms().size());
        TestOperationSetAdHocMultiUserChat.assertNotNull((String)"The newly created room is null", this.opSetAHMUC1.getAdHocChatRooms().get(0));
        collectorUser2.waitForEvent(40000L);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"User2 didn't receive an invitation. Wrong number of collected events", (int)1, (int)collectorUser2.events.size());
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Unexpected event type", (boolean)(collectorUser2.events.get(0) instanceof AdHocChatRoomInvitationReceivedEvent));
        collectorUser3.waitForEvent(40000L);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"User3 didn't receive an invitation. Wrong number of collected events", (int)1, (int)collectorUser3.events.size());
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Unexpected event type", (boolean)(collectorUser3.events.get(0) instanceof AdHocChatRoomInvitationReceivedEvent));
        AdHocChatRoomInvitationReceivedEvent event2 = (AdHocChatRoomInvitationReceivedEvent)collectorUser2.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT concern the right chatroom", (String)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getName(), (String)event2.getInvitation().getTargetAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT come from expected user", (String)this.fixture.userID1, (String)event2.getInvitation().getInviter());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Invitation's reason does NOT match", (String)invitationReason, (String)event2.getInvitation().getReason());
        AdHocChatRoomInvitationReceivedEvent event3 = (AdHocChatRoomInvitationReceivedEvent)collectorUser3.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT concern the right chatroom", (String)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getName(), (String)event3.getInvitation().getTargetAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT come from expected user", (String)this.fixture.userID1, (String)event3.getInvitation().getInviter());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Invitation's reason does NOT match", (String)invitationReason, (String)event3.getInvitation().getReason());
        collectorUser1 = new AHMUCEventCollector((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0), 2);
        TestOperationSetAdHocMultiUserChat.assertEquals((int)1, (int)this.opSetAHMUC2.getAdHocChatRooms().size());
        TestOperationSetAdHocMultiUserChat.assertNotNull(this.opSetAHMUC2.getAdHocChatRooms().get(0));
        event2.getInvitation().getTargetAdHocChatRoom().join();
        collectorUser1.waitForEvent(40000L);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong count of generated events", (int)1, (int)collectorUser1.events.size());
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Wrong event instance", (boolean)(collectorUser1.events.get(0) instanceof AdHocChatRoomParticipantPresenceChangeEvent));
        AdHocChatRoomParticipantPresenceChangeEvent presenceEvent2 = (AdHocChatRoomParticipantPresenceChangeEvent)collectorUser1.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Presence event does NOT concern expected chatroom", (String)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getName(), (String)presenceEvent2.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong event type", (String)"ContactJoined", (String)presenceEvent2.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Presence event does NOT come from the expected user", (String)this.fixture.userID2, (String)presenceEvent2.getParticipant().getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected participants count", (int)1, (int)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getParticipantsCount());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected room participant", (String)this.fixture.userID2, (String)((Contact)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getParticipants().get(0)).getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((int)1, (int)this.opSetAHMUC3.getAdHocChatRooms().size());
        TestOperationSetAdHocMultiUserChat.assertNotNull(this.opSetAHMUC3.getAdHocChatRooms().get(0));
        event3.getInvitation().getTargetAdHocChatRoom().join();
        collectorUser1.waitForEvent(20000L);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong count of generated events", (int)2, (int)collectorUser1.events.size());
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Wrong event instance", (boolean)(collectorUser1.events.get(1) instanceof AdHocChatRoomParticipantPresenceChangeEvent));
        AdHocChatRoomParticipantPresenceChangeEvent presenceEvent3 = (AdHocChatRoomParticipantPresenceChangeEvent)collectorUser1.events.get(1);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Presence event does NOT concern expected chatroom", (String)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getName(), (String)presenceEvent3.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong event type", (String)"ContactJoined", (String)presenceEvent3.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Presence event does NOT come from the expected user", (String)this.fixture.userID3, (String)presenceEvent3.getParticipant().getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected participants count", (int)2, (int)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getParticipantsCount());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected room participant", (String)this.fixture.userID3, (String)((Contact)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getParticipants().get(1)).getAddress());
        ((AdHocChatRoom)this.opSetAHMUC2.getAdHocChatRooms().get(0)).leave();
        collectorUser1.waitForEvent(40000L);
        presenceEvent2 = (AdHocChatRoomParticipantPresenceChangeEvent)collectorUser1.events.get(2);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong type of event", (String)presenceEvent2.getEventType(), (String)"ContactLeft");
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The event belongs to an unexpected room", (String)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getName(), (String)presenceEvent2.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The event belongs to an unexpected user", (String)this.fixture.userID2, (String)presenceEvent2.getParticipant().getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong count of participants", (int)1, (int)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getParticipantsCount());
        ((AdHocChatRoom)this.opSetAHMUC3.getAdHocChatRooms().get(0)).leave();
        collectorUser1.waitForEvent(10000L);
        presenceEvent3 = (AdHocChatRoomParticipantPresenceChangeEvent)collectorUser1.events.get(3);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong type of event", (String)presenceEvent3.getEventType(), (String)"ContactLeft");
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The event belongs to an unexpected room", (String)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getName(), (String)presenceEvent3.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The event belongs to an unexpected user", (String)this.fixture.userID3, (String)presenceEvent3.getParticipant().getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The room was supposed to be empty, but it still contains participants", (int)0, (int)((AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0)).getParticipantsCount());
    }

    public void testPeerJoined() throws OperationFailedException {
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"There are any rooms to retrieve on user 1 side's", (int)1, (int)this.opSetAHMUC1.getAdHocChatRooms().size());
        AdHocChatRoom adHocChatRoom = (AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0);
        TestOperationSetAdHocMultiUserChat.assertNotNull((String)"The room can NOT been retrieved.", (Object)adHocChatRoom);
        AHMUCEventCollector collector = new AHMUCEventCollector(adHocChatRoom, 2);
        adHocChatRoom.invite(this.fixture.userID2, "");
        adHocChatRoom.invite(this.fixture.userID3, "");
        collector.waitForEvent(10000L);
        collector.waitForEvent(10000L);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong number of collected events", (int)2, (int)collector.events.size());
        AdHocChatRoomParticipantPresenceChangeEvent presenceEvent1 = (AdHocChatRoomParticipantPresenceChangeEvent)collector.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong event type", (String)"ContactJoined", (String)presenceEvent1.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected chatroom", (String)adHocChatRoom.getName(), (String)presenceEvent1.getAdHocChatRoom().getName());
        AdHocChatRoomParticipantPresenceChangeEvent presenceEvent2 = (AdHocChatRoomParticipantPresenceChangeEvent)collector.events.get(1);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong event type", (String)"ContactJoined", (String)presenceEvent2.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected chatroom", (String)adHocChatRoom.getName(), (String)presenceEvent2.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong number of participants", (int)2, (int)adHocChatRoom.getParticipantsCount());
        ArrayList<String> participantsAdress = new ArrayList<String>();
        for (Contact c : adHocChatRoom.getParticipants()) {
            participantsAdress.add(c.getAddress());
        }
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"A participant is missing", (boolean)participantsAdress.contains(this.fixture.userID2));
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"A participant is missing", (boolean)participantsAdress.contains(this.fixture.userID3));
        AHMUCEventCollector collector2 = new AHMUCEventCollector(adHocChatRoom, 1);
        Message message = adHocChatRoom.createMessage("Don't ask your countrywhat it can do for you, ask you what you can do for it.");
        adHocChatRoom.sendMessage(message);
        collector2.waitForEvent(10000L);
        AdHocChatRoomMessageDeliveredEvent deliveredMessage = (AdHocChatRoomMessageDeliveredEvent)collector2.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Message delivered to an unexpected room", (String)adHocChatRoom.getName(), (String)deliveredMessage.getSourceAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong message type", (int)1, (int)deliveredMessage.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Message's content does NOT match", (String)message.getContent(), (String)deliveredMessage.getMessage().getContent());
    }

    public void testInvitations() throws OperationFailedException {
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"There are no rooms to retrieve on user 1 side's", (int)1, (int)this.opSetAHMUC1.getAdHocChatRooms().size());
        AdHocChatRoom adHocChatRoom = (AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0);
        TestOperationSetAdHocMultiUserChat.assertNotNull((String)"The room can NOT been retrieved.", (Object)adHocChatRoom);
        AHMUCEventCollector collectorUser1 = new AHMUCEventCollector(this.opSetAHMUC1, 2);
        AHMUCEventCollector collectorUser2 = new AHMUCEventCollector(this.opSetAHMUC2, 3);
        AHMUCEventCollector collectorUser3 = new AHMUCEventCollector(this.opSetAHMUC3, 3);
        adHocChatRoom.invite(this.fixture.userID2, invitationReason);
        adHocChatRoom.invite(this.fixture.userID3, invitationReason);
        collectorUser2.waitForEvent(10000L);
        collectorUser3.waitForEvent(10000L);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong number of collected events", (int)1, (int)collectorUser2.events.size());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong number of collected events", (int)1, (int)collectorUser3.events.size());
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Unexpected event type", (boolean)(collectorUser2.events.get(0) instanceof AdHocChatRoomInvitationReceivedEvent));
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Unexpected event type", (boolean)(collectorUser3.events.get(0) instanceof AdHocChatRoomInvitationReceivedEvent));
        AdHocChatRoomInvitationReceivedEvent event2 = (AdHocChatRoomInvitationReceivedEvent)collectorUser2.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT concern the right chatroom", (String)adHocChatRoom.getName(), (String)event2.getInvitation().getTargetAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT come from expected user", (String)this.fixture.userID1, (String)event2.getInvitation().getInviter());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Invitation's reason does NOT match", (String)invitationReason, (String)event2.getInvitation().getReason());
        AdHocChatRoomInvitationReceivedEvent event3 = (AdHocChatRoomInvitationReceivedEvent)collectorUser3.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT concern the right chatroom", (String)adHocChatRoom.getName(), (String)event3.getInvitation().getTargetAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT come from expected user", (String)this.fixture.userID1, (String)event3.getInvitation().getInviter());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Invitation's reason does NOT match", (String)invitationReason, (String)event3.getInvitation().getReason());
        event2.getInvitation().getTargetAdHocChatRoom().join();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong count of generated events", (int)1, (int)collectorUser1.events.size());
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Wrong event instance", (boolean)(collectorUser1.events.get(0) instanceof AdHocChatRoomParticipantPresenceChangeEvent));
        AdHocChatRoomParticipantPresenceChangeEvent presenceEvent2 = (AdHocChatRoomParticipantPresenceChangeEvent)collectorUser1.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Presence event does NOT concern expected chatroom", (String)adHocChatRoom.getName(), (String)presenceEvent2.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong event type", (String)"ContactJoined", (String)presenceEvent2.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Presence event does NOT come from the expected user", (String)this.fixture.userID2, (String)presenceEvent2.getParticipant().getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected participants count", (int)1, (int)adHocChatRoom.getParticipantsCount());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected room participant", (String)this.fixture.userID2, (String)((Contact)adHocChatRoom.getParticipants().get(0)).getAddress());
        this.opSetAHMUC3.rejectInvitation(event3.getInvitation(), invitationRejectReason);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong count of generated events", (int)2, (int)collectorUser1.events.size());
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Wrong event instance", (boolean)(collectorUser1.events.get(1) instanceof AdHocChatRoomInvitationRejectedEvent));
        AdHocChatRoomInvitationRejectedEvent rejectEvent = (AdHocChatRoomInvitationRejectedEvent)collectorUser1.events.get(1);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Reject event does NOT concern expected room", (String)adHocChatRoom.getName(), (String)rejectEvent.getChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Reject event does NOT come from expected user", (String)this.fixture.userID3, (String)rejectEvent.getInvitee());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Reject event's reason does NOT match with expected one", (String)invitationRejectReason, (String)rejectEvent.getReason());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected participants count", (int)1, (int)adHocChatRoom.getParticipantsCount());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected room participant", (String)this.fixture.userID2, (String)((Contact)adHocChatRoom.getParticipants().get(0)).getAddress());
        adHocChatRoom.invite(this.fixture.userID3, "");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong number of collected events", (int)2, (int)collectorUser3.events.size());
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Unexpected event type", (boolean)(collectorUser3.events.get(1) instanceof AdHocChatRoomInvitationReceivedEvent));
        event3 = (AdHocChatRoomInvitationReceivedEvent)collectorUser3.events.get(1);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT concern the right chatroom", (String)adHocChatRoom.getName(), (String)event3.getInvitation().getTargetAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Received invitation does NOT come from expected user", (String)this.fixture.userID1, (String)event3.getInvitation().getInviter());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Invitation's reason does NOT match", (String)invitationReason, (String)event3.getInvitation().getReason());
        event3.getInvitation().getTargetAdHocChatRoom().join();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong count of generated events", (Object)3, (Object)(collectorUser1.events.size() == 1 ? 1 : 0));
        TestOperationSetAdHocMultiUserChat.assertTrue((String)"Wrong event instance", (boolean)(collectorUser1.events.get(0) instanceof AdHocChatRoomParticipantPresenceChangeEvent));
        AdHocChatRoomParticipantPresenceChangeEvent presenceEvent3 = (AdHocChatRoomParticipantPresenceChangeEvent)collectorUser1.events.get(2);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Presence event does NOT concern expected chatroom", (String)adHocChatRoom.getName(), (String)presenceEvent3.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong event type", (String)"ContactJoined", (String)presenceEvent3.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Presence event does NOT come from the expected user", (String)this.fixture.userID3, (String)presenceEvent3.getParticipant().getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected participants count", (int)2, (int)adHocChatRoom.getParticipantsCount());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Unexpected room participant", (String)this.fixture.userID3, (String)((Contact)adHocChatRoom.getParticipants().get(1)).getAddress());
    }

    public void testSendIM() throws OperationFailedException, OperationNotSupportedException {
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"There are any rooms to retrieve on user 1 side's", (int)1, (int)this.opSetAHMUC1.getAdHocChatRooms().size());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"There are any rooms to retrieve on user 2 side's", (int)1, (int)this.opSetAHMUC2.getAdHocChatRooms().size());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"There are any rooms to retrieve on user 3 side's", (int)1, (int)this.opSetAHMUC3.getAdHocChatRooms().size());
        AdHocChatRoom roomUser1 = (AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0);
        AdHocChatRoom roomUser2 = (AdHocChatRoom)this.opSetAHMUC2.getAdHocChatRooms().get(0);
        AdHocChatRoom roomUser3 = (AdHocChatRoom)this.opSetAHMUC3.getAdHocChatRooms().get(0);
        TestOperationSetAdHocMultiUserChat.assertNotNull((String)"The room can NOT been retrieved on user's 1 side.", (Object)roomUser1);
        TestOperationSetAdHocMultiUserChat.assertNotNull((String)"The room can NOT been retrieved on user's 2 side.", (Object)roomUser2);
        TestOperationSetAdHocMultiUserChat.assertNotNull((String)"The room can NOT been retrieved on user's 3 side.", (Object)roomUser3);
        AHMUCEventCollector collectorUser1 = new AHMUCEventCollector(roomUser1, 1);
        AHMUCEventCollector collectorUser2 = new AHMUCEventCollector(roomUser2, 1);
        AHMUCEventCollector collectorUser3 = new AHMUCEventCollector(roomUser3, 1);
        Message message = roomUser1.createMessage("Quick brown fox jumps over the lazy dog");
        roomUser1.sendMessage(message);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"User 1 did NOT receive a message delivered event. Wrong event collected number", (int)1, (int)collectorUser1.events.size());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"User 2 did NOT receive a message received event. Wrong event collected number", (int)1, (int)collectorUser2.events.size());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"User 3 did NOT receive a message received event. Wrong event collected number", (int)1, (int)collectorUser3.events.size());
        AdHocChatRoomMessageDeliveredEvent deliveredMessage = (AdHocChatRoomMessageDeliveredEvent)collectorUser1.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Message delivered to an unexpected room", (String)roomUser1.getName(), (String)deliveredMessage.getSourceAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong message type", (int)1, (int)deliveredMessage.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Message's content does NOT match", (String)message.getContent(), (String)deliveredMessage.getMessage().getContent());
        AdHocChatRoomMessageReceivedEvent receivedMessage = (AdHocChatRoomMessageReceivedEvent)collectorUser2.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Message does NOT belong to this room", (String)roomUser2.getName(), (String)receivedMessage.getSourceChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong message type", (int)1, (int)receivedMessage.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Message's content does NOT match", (String)message.getContent(), (String)receivedMessage.getMessage().getContent());
        receivedMessage = (AdHocChatRoomMessageReceivedEvent)collectorUser3.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Message does NOT belong to this room", (String)roomUser3.getName(), (String)receivedMessage.getSourceChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong message type", (int)1, (int)receivedMessage.getEventType());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Message's content does NOT match", (String)message.getContent(), (String)receivedMessage.getMessage().getContent());
    }

    public void testPeerLeaved() {
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"There are any rooms to retrieve on user 1 side's", (int)1, (int)this.opSetAHMUC1.getAdHocChatRooms().size());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"There are any rooms to retrieve on user 2 side's", (int)1, (int)this.opSetAHMUC2.getAdHocChatRooms().size());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"There are any rooms to retrieve on user 3 side's", (int)1, (int)this.opSetAHMUC3.getAdHocChatRooms().size());
        AdHocChatRoom room = (AdHocChatRoom)this.opSetAHMUC1.getAdHocChatRooms().get(0);
        AHMUCEventCollector collector = new AHMUCEventCollector(room, 2);
        ((AdHocChatRoom)this.opSetAHMUC2.getAdHocChatRooms().get(0)).leave();
        collector.waitForEvent(10000L);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong events count when first peer leaved the room", (int)1, (int)collector.events.size());
        AdHocChatRoomParticipantPresenceChangeEvent presenceEvent = (AdHocChatRoomParticipantPresenceChangeEvent)collector.events.get(0);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong type of event", (String)presenceEvent.getEventType(), (String)"ContactLeft");
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The event belongs to an unexpected room", (String)room.getName(), (String)presenceEvent.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The event belongs to an unexpected user", (String)this.fixture.userID2, (String)presenceEvent.getParticipant().getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"No event was generated when second peer leaved the room", (int)1, (int)room.getParticipantsCount());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The room was not supposed to contain this user anymore", (String)this.fixture.userID3, (String)((Contact)room.getParticipants().get(0)).getAddress());
        ((AdHocChatRoom)this.opSetAHMUC3.getAdHocChatRooms().get(0)).leave();
        collector.waitForEvent(10000L);
        presenceEvent = (AdHocChatRoomParticipantPresenceChangeEvent)collector.events.get(1);
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"Wrong type of event", (String)presenceEvent.getEventType(), (String)"ContactLeft");
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The event belongs to an unexpected room", (String)room.getName(), (String)presenceEvent.getAdHocChatRoom().getName());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The event belongs to an unexpected user", (String)this.fixture.userID3, (String)presenceEvent.getParticipant().getAddress());
        TestOperationSetAdHocMultiUserChat.assertEquals((String)"The room was supposed to be empty, but it still contains participants", (int)0, (int)room.getParticipantsCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareContactList() throws Exception {
        Object o;
        this.fixture.clearProvidersLists();
        try {
            this.opSetPresence1.setAuthorizationHandler((AuthorizationHandler)new AuthHandler());
            this.opSetPresence1.subscribe(this.fixture.userID2);
            this.opSetPresence1.subscribe(this.fixture.userID3);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        try {
            this.opSetPresence2.setAuthorizationHandler((AuthorizationHandler)new AuthHandler());
            this.opSetPresence2.subscribe(this.fixture.userID1);
            this.opSetPresence2.subscribe(this.fixture.userID3);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        try {
            this.opSetPresence3.setAuthorizationHandler((AuthorizationHandler)new AuthHandler());
            this.opSetPresence3.subscribe(this.fixture.userID1);
            this.opSetPresence3.subscribe(this.fixture.userID2);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        this.logger.info((Object)"Will wait until the list prepare is completed");
        Object object = o = new Object();
        synchronized (object) {
            o.wait(2000L);
        }
    }
}

