/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestAccountInstallation
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestAccountInstallation.class);
    private Object registrationLock = new Object();
    ProtocolProviderFactory icqProviderFactory = null;

    public TestAccountInstallation(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        if (!IcqSlickFixture.onlineTestingDisabled) {
            suite.addTest((Test)new TestAccountInstallation("testRegisterWrongUsername"));
            suite.addTest((Test)new TestAccountInstallation("testRegisterWrongPassword"));
        }
        suite.addTest((Test)new TestAccountInstallation("testInstallAccount"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterWrongUsername() throws OperationFailedException {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=ICQ)";
        try {
            serRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestAccountInstallation.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        TestAccountInstallation.assertTrue((String)"Failed to find a provider factory service for protocol ICQ", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        ProtocolProviderFactory icqProviderFactory = (ProtocolProviderFactory)IcqSlickFixture.bc.getService(serRefs[0]);
        String passwd = System.getProperty("accounts.icq.TESTED_IMPL_PWD", null);
        String uin = System.getProperty("accounts.icq.TESTED_IMPL_ACCOUNT_ID", null);
        uin = uin + "1234";
        Hashtable<String, String> icqAccountProperties = new Hashtable<String, String>();
        icqAccountProperties.put("PASSWORD", passwd);
        AccountID icqAccountID = icqProviderFactory.installAccount(uin, icqAccountProperties);
        ServiceReference[] icqProviderRefs = null;
        try {
            icqProviderRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=ICQ)(USER_ID=" + uin + "))");
        }
        catch (InvalidSyntaxException ex) {
            logger.debug((Object)"Our filter seems to be messed up.", (Throwable)ex);
        }
        TestAccountInstallation.assertNotNull((String)("No Protocol Provider was found for ICQ UIN:" + icqAccountID), (Object)icqProviderRefs);
        TestAccountInstallation.assertTrue((String)("No Protocol Provider was found for ICQ UIN:" + icqAccountID), (icqProviderRefs.length > 0 ? 1 : 0) != 0);
        ServiceReference icqServiceRef = icqProviderRefs[0];
        ProtocolProviderService provider = (ProtocolProviderService)IcqSlickFixture.bc.getService(icqServiceRef);
        RegistrationFailedEventCollector regFailedEvtCollector = new RegistrationFailedEventCollector();
        logger.debug((Object)("install " + regFailedEvtCollector));
        provider.addRegistrationStateChangeListener((RegistrationStateChangeListener)regFailedEvtCollector);
        provider.register((SecurityAuthority)new SecurityAuthorityImpl(passwd.toCharArray()));
        try {
            Object object = this.registrationLock;
            synchronized (object) {
                logger.debug((Object)"Waiting for registration to complete ...");
                this.registrationLock.wait(40000L);
                logger.debug((Object)"Registration was completed or we lost patience.");
            }
        }
        catch (InterruptedException ex) {
            logger.debug((Object)"Interrupted while waiting for registration", (Throwable)ex);
        }
        catch (Throwable t) {
            logger.debug((Object)"We got thrown out while waiting for registration", t);
        }
        TestAccountInstallation.assertTrue((String)("No registration event notifying of registration has failed. All events were: " + regFailedEvtCollector.collectedNewStates), (boolean)regFailedEvtCollector.collectedNewStates.contains(RegistrationState.AUTHENTICATION_FAILED));
        TestAccountInstallation.assertEquals((String)"Registration status must be auth failed as we are logging in with wrong uin", (int)regFailedEvtCollector.failedCode, (int)3);
        TestAccountInstallation.assertNotNull((String)"We must have reason for auth failed", (Object)regFailedEvtCollector.failedReason);
        provider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)regFailedEvtCollector);
        icqProviderFactory.uninstallAccount(icqAccountID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterWrongPassword() throws OperationFailedException {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=ICQ)";
        try {
            serRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestAccountInstallation.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        TestAccountInstallation.assertTrue((String)"Failed to find a provider factory service for protocol ICQ", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        ProtocolProviderFactory icqProviderFactory = (ProtocolProviderFactory)IcqSlickFixture.bc.getService(serRefs[0]);
        String passwd = System.getProperty("accounts.icq.TESTED_IMPL_PWD", null);
        String uin = System.getProperty("accounts.icq.TESTED_IMPL_ACCOUNT_ID", null);
        passwd = "dam1234";
        Hashtable<String, String> icqAccountProperties = new Hashtable<String, String>();
        icqAccountProperties.put("PASSWORD", passwd);
        AccountID icqAccountID = icqProviderFactory.installAccount(uin, icqAccountProperties);
        ServiceReference[] icqProviderRefs = null;
        try {
            icqProviderRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=ICQ)(USER_ID=" + icqAccountID.getUserID() + "))");
        }
        catch (InvalidSyntaxException ex1) {
            logger.error((Object)"", (Throwable)ex1);
        }
        TestAccountInstallation.assertNotNull((String)("No Protocol Provider was found for ICQ UIN:" + icqAccountID), (Object)icqProviderRefs);
        TestAccountInstallation.assertTrue((String)("No Protocol Provider was found for ICQ UIN:" + icqAccountID), (icqProviderRefs.length > 0 ? 1 : 0) != 0);
        ServiceReference icqServiceRef = icqProviderRefs[0];
        ProtocolProviderService provider = (ProtocolProviderService)IcqSlickFixture.bc.getService(icqServiceRef);
        RegistrationFailedEventCollector regFailedEvtCollector = new RegistrationFailedEventCollector();
        logger.debug((Object)("install " + regFailedEvtCollector));
        provider.addRegistrationStateChangeListener((RegistrationStateChangeListener)regFailedEvtCollector);
        provider.register((SecurityAuthority)new SecurityAuthorityImpl(passwd.toCharArray()));
        try {
            Object object = this.registrationLock;
            synchronized (object) {
                logger.debug((Object)"Waiting for registration to complete ...");
                this.registrationLock.wait(40000L);
                logger.debug((Object)"Registration was completed or we lost patience.");
            }
        }
        catch (InterruptedException ex) {
            logger.debug((Object)"Interrupted while waiting for registration", (Throwable)ex);
        }
        catch (Throwable t) {
            logger.debug((Object)"We got thrown out while waiting for registration", t);
        }
        TestAccountInstallation.assertTrue((String)("No registration event notifying of registration has failed. All events were: " + regFailedEvtCollector.collectedNewStates), (boolean)regFailedEvtCollector.collectedNewStates.contains(RegistrationState.AUTHENTICATION_FAILED));
        TestAccountInstallation.assertEquals((String)"Registration status must be auth failed as we are logging in with wrong pass", (int)regFailedEvtCollector.failedCode, (int)1);
        TestAccountInstallation.assertNotNull((String)"We must have reason for auth failed", (Object)regFailedEvtCollector.failedReason);
        provider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)regFailedEvtCollector);
        icqProviderFactory.uninstallAccount(icqAccountID);
    }

    public void testInstallAccount() {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=ICQ)";
        try {
            serRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestAccountInstallation.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        TestAccountInstallation.assertTrue((String)"Failed to find a provider factory service for protocol ICQ", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        this.icqProviderFactory = (ProtocolProviderFactory)IcqSlickFixture.bc.getService(serRefs[0]);
        TestAccountInstallation.assertTrue((String)"There was an account registered with the account mananger before we've installed any", (this.icqProviderFactory.getRegisteredAccounts().size() == 0 ? 1 : 0) != 0);
        String passwd = System.getProperty("accounts.icq.TESTED_IMPL_PWD", null);
        String uin = System.getProperty("accounts.icq.TESTED_IMPL_ACCOUNT_ID", null);
        TestAccountInstallation.assertNotNull((String)"In the accounts.icq.TESTED_IMPL_ACCOUNT_ID system property, you need to provide a valid icq UIN for the  slick to use when signing on icq. It's passwd must be set in accounts.icq.TESTED_IMPL_PWD", (Object)uin);
        TestAccountInstallation.assertNotNull((String)("In the accounts.icq.TESTED_IMPL_PWD system property, you need to provide a password for the " + uin + " account."), (Object)passwd);
        Hashtable<String, String> icqAccountProperties = new Hashtable<String, String>();
        icqAccountProperties.put("PASSWORD", passwd);
        try {
            this.icqProviderFactory.installAccount(null, icqAccountProperties);
            TestAccountInstallation.fail((String)"installing an account with a null account id must result in a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        IcqSlickFixture.icqAccountID = this.icqProviderFactory.installAccount(uin, icqAccountProperties);
        try {
            IcqSlickFixture.icqAccountID = this.icqProviderFactory.installAccount(uin, icqAccountProperties);
            TestAccountInstallation.fail((String)"An IllegalStateException must be thrown when trying to install a duplicate account");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestAccountInstallation.assertTrue((String)"The newly installed account was not in the acc man's registered accounts!", (this.icqProviderFactory.getRegisteredAccounts().size() == 1 ? 1 : 0) != 0);
        osgiFilter = "(&(PROTOCOL_NAME=ICQ)(USER_ID=" + IcqSlickFixture.icqAccountID.getUserID() + "))";
        try {
            serRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestAccountInstallation.fail((String)(osgiFilter + "is not a valid osgi filter"));
        }
        TestAccountInstallation.assertTrue((String)"An ICQ protocol provider was apparently not installed as requested.", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        Object icqProtocolProvider = IcqSlickFixture.bc.getService(serRefs[0]);
        TestAccountInstallation.assertTrue((String)"The installed protocol provider does not implement the protocol provider service.", (boolean)(icqProtocolProvider instanceof ProtocolProviderService));
    }

    public class SecurityAuthorityImpl
    implements SecurityAuthority {
        private char[] passwd = null;
        private boolean isUserNameEditable = false;

        public SecurityAuthorityImpl(char[] passwd) {
            this.passwd = passwd;
        }

        public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues, int reasonCode) {
            return this.obtainCredentials(realm, defaultValues);
        }

        public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues) {
            defaultValues.setPassword(this.passwd);
            return defaultValues;
        }

        public void setUserNameEditable(boolean isUserNameEditable) {
            this.isUserNameEditable = isUserNameEditable;
        }

        public boolean isUserNameEditable() {
            return this.isUserNameEditable;
        }
    }

    public class RegistrationFailedEventCollector
    implements RegistrationStateChangeListener {
        public List<RegistrationState> collectedNewStates = new LinkedList<RegistrationState>();
        public int failedCode;
        public String failedReason = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            this.collectedNewStates.add(evt.getNewState());
            if (evt.getNewState().equals((Object)RegistrationState.AUTHENTICATION_FAILED)) {
                this.failedCode = evt.getReasonCode();
                this.failedReason = evt.getReason();
                logger.debug((Object)("Our registration failed - " + this.failedCode + " = " + this.failedReason));
                Object object = TestAccountInstallation.this.registrationLock;
                synchronized (object) {
                    logger.debug((Object)".");
                    TestAccountInstallation.this.registrationLock.notifyAll();
                    logger.debug((Object)".");
                }
            }
        }
    }
}

