/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;

public final class JavaLogger
implements Logger {
    private final java.util.logging.Logger logger;

    JavaLogger(java.util.logging.Logger logger) {
        DefensiveTools.checkNull(logger, "logger");
        this.logger = logger;
    }

    public void logException(String s, Throwable t) {
        this.log(Level.WARNING, s, t);
    }

    public void logWarning(String s) {
        this.log(Level.WARNING, s, null);
    }

    private void log(Level level, String s, Throwable t) {
        LogRecord record = new LogRecord(level, s);
        StackTraceElement frame = this.findLastRealStackFrame();
        if (frame != null) {
            record.setSourceClassName(frame.getClassName());
            record.setSourceMethodName(frame.getMethodName());
        }
        if (t != null) {
            record.setThrown(t);
        }
        this.logger.log(record);
    }

    private StackTraceElement findLastRealStackFrame() {
        StackTraceElement cool = null;
        for (StackTraceElement frame : new Throwable().getStackTrace()) {
            if (frame.getClassName().equals(JavaLogger.class.getName())) continue;
            cool = frame;
            break;
        }
        return cool;
    }

    public void logFine(String s) {
        this.log(Level.FINE, s, null);
    }

    public void logFiner(String s) {
        this.log(Level.FINER, s, null);
    }

    public boolean logWarningEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean logFineEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean logFinerEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }
}

