/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.snaccmd.AbstractChatInfo;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public final class ExchangeInfo
extends AbstractChatInfo
implements LiveWritable {
    private static final int TYPE_URL = 212;
    private final int number;
    private final String url;

    @Nullable
    public static ExchangeInfo readExchangeInfo(ByteBlock block) {
        if (block.getLength() < 2) {
            return null;
        }
        return new ExchangeInfo(block);
    }

    ExchangeInfo(ByteBlock block) {
        this.number = BinaryTools.getUShort(block, 0);
        ByteBlock tlvBlock = block.subBlock(2);
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.readBaseInfo(chain);
        this.url = chain.getString(212);
    }

    public final int getNumber() {
        return this.number;
    }

    public final String getUrl() {
        return this.url;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.number);
        this.writeBaseInfo(out);
        if (this.url != null) {
            Tlv.getStringInstance(212, this.url).write(out);
        }
    }

    public String toString() {
        return "ExchangeInfo for #" + this.number + ", url='" + this.url + "'" + " - " + super.toString();
    }
}

