/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api;

import com.ircclouds.irc.api.IMessageDispatcher;
import com.ircclouds.irc.api.IMessageReader;
import com.ircclouds.irc.api.comms.IConnection;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.domain.messages.interfaces.IMessage;
import com.ircclouds.irc.api.filters.FilterStatus;
import com.ircclouds.irc.api.filters.IMessageFilter;
import com.ircclouds.irc.api.filters.MessageFilterResult;
import com.ircclouds.irc.api.filters.TargetListeners;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiDaemon
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractApiDaemon.class);
    private final IMessageReader reader;
    private final IMessageDispatcher dispatcher;

    public AbstractApiDaemon(IMessageReader aReader, IMessageDispatcher aDispatcher) {
        super("ApiDaemon");
        this.reader = aReader;
        this.dispatcher = aDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.reader.available()) {
                IMessage _msg = this.reader.readMessage();
                if (_msg == null) continue;
                this.dispatcher.dispatchToPrivateListeners(_msg);
                if (this.getMessageFilter() != null) {
                    MessageFilterResult _fr = this.getMessageFilter().filter(_msg);
                    if (!_fr.getFilterStatus().equals((Object)FilterStatus.PASS)) continue;
                    this.dispatcher.dispatch(_fr.getFilteredMessage(), this.getMessageFilter().getTargetListeners());
                    continue;
                }
                this.dispatcher.dispatch(_msg, TargetListeners.ALL);
            }
        }
        catch (IConnection.EndOfStreamException aExc) {
            LOG.debug("Received end of stream, closing connection", (Throwable)aExc);
            this.signalExceptionToApi(aExc);
            this.dispatcher.dispatch(new ClientErrorMessage(aExc), TargetListeners.ALL);
        }
        catch (IOException aExc) {
            LOG.error(this.getName(), (Throwable)aExc);
            this.signalExceptionToApi(aExc);
            this.dispatcher.dispatch(new ClientErrorMessage(aExc), TargetListeners.ALL);
        }
        finally {
            LOG.debug("ApiDaemon Exiting..");
            this.onExit();
        }
    }

    protected abstract void signalExceptionToApi(Exception var1);

    protected abstract void onExit();

    protected abstract IMessageFilter getMessageFilter();
}

