/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.comms;

import com.ircclouds.irc.api.comms.IConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import nl.dannyvanheumen.nio.ProxiedSocketChannel;

public class SocketChannelConnection
implements IConnection {
    private SocketChannel channel;
    private final ByteBuffer buffer = ByteBuffer.allocate(2048);

    @Override
    public int write(String aMessage) throws IOException {
        return this.channel.write(ByteBuffer.wrap(aMessage.getBytes()));
    }

    @Override
    public boolean open(String aHostname, int aPort, SSLContext aCtx, Proxy aProxy, boolean resolveThroughProxy) throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            InetSocketAddress address;
            if (aProxy != null && aProxy.type() == Proxy.Type.SOCKS) {
                this.channel = new ProxiedSocketChannel(aProxy);
                address = resolveThroughProxy ? InetSocketAddress.createUnresolved(aHostname, aPort) : new InetSocketAddress(aHostname, aPort);
            } else {
                this.channel = SocketChannel.open();
                address = new InetSocketAddress(aHostname, aPort);
            }
            return this.channel.connect(address);
        }
        throw new RuntimeException("Socket is already open.");
    }

    @Override
    public String read() throws IOException {
        this.buffer.clear();
        if (this.channel.read(this.buffer) == -1) {
            throw new IConnection.EndOfStreamException();
        }
        this.buffer.flip();
        byte[] _bytes = new byte[this.buffer.limit()];
        this.buffer.get(_bytes);
        return new String(_bytes);
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }
}

