/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.domain.messages;

import com.ircclouds.irc.api.domain.ChannelMode;
import com.ircclouds.irc.api.domain.messages.interfaces.IMessage;
import com.ircclouds.irc.api.domain.messages.interfaces.ISource;
import com.ircclouds.irc.api.utils.StringUtils;
import java.util.List;

public class ChannelModeMessage
implements IMessage {
    private ISource user;
    private String channel;
    private String modeStr;
    private List<ChannelMode> addedModes;
    private List<ChannelMode> removedModes;

    public ChannelModeMessage(ISource aUser, String aChanName, String aModeStr, List<ChannelMode> aAddedModes, List<ChannelMode> aRemModes) {
        this.user = aUser;
        this.channel = aChanName;
        this.modeStr = aModeStr;
        this.addedModes = aAddedModes;
        this.removedModes = aRemModes;
    }

    public String getChannelName() {
        return this.channel;
    }

    @Override
    public ISource getSource() {
        return this.user;
    }

    public List<ChannelMode> getAddedModes() {
        return this.addedModes;
    }

    public List<ChannelMode> getRemovedModes() {
        return this.removedModes;
    }

    public String getModeStr() {
        return this.modeStr;
    }

    @Override
    public String asRaw() {
        return new StringBuffer().append(":").append(this.user).append(" MODE ").append(this.channel).append(" +").append(StringUtils.join(this.addedModes)).append("-").append(StringUtils.join(this.removedModes)).toString();
    }
}

