/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.filters;

import com.ircclouds.irc.api.domain.messages.interfaces.IMessage;
import com.ircclouds.irc.api.filters.FilterStatus;
import com.ircclouds.irc.api.filters.HowMany;
import com.ircclouds.irc.api.filters.IMessageFilter;
import com.ircclouds.irc.api.filters.MessageFilterResult;
import com.ircclouds.irc.api.filters.TargetListeners;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAndMessageFilter
implements IMessageFilter {
    private IMessageFilter filterOne;

    public AbstractAndMessageFilter(IMessageFilter aFilterOne) {
        this.filterOne = aFilterOne;
    }

    @Override
    public MessageFilterResult filter(IMessage aMessage) {
        MessageFilterResult _fr1 = this.filterOne.filter(aMessage);
        if (_fr1.getFilterStatus().equals((Object)FilterStatus.PASS)) {
            return this.getSecondFilter().filter(_fr1.getFilteredMessage());
        }
        return _fr1;
    }

    @Override
    public TargetListeners getTargetListeners() {
        if (this.filterOne.getTargetListeners().getHowMany().equals((Object)HowMany.ALL)) {
            return this.getSecondFilter().getTargetListeners();
        }
        if (this.getSecondFilter().getTargetListeners().getHowMany().equals((Object)HowMany.ALL)) {
            return this.filterOne.getTargetListeners();
        }
        return new TargetListeners(this.getIntersection(this.filterOne.getTargetListeners().getListeners(), this.getSecondFilter().getTargetListeners().getListeners()), HowMany.SOME);
    }

    private <T> List<T> getIntersection(List<T> aFirstList, List<T> aSecondList) {
        ArrayList<T> _arrList = new ArrayList<T>();
        for (T _t : aFirstList) {
            if (!aSecondList.contains(_t)) continue;
            _arrList.add(_t);
        }
        return _arrList;
    }

    protected abstract IMessageFilter getSecondFilter();
}

