/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.xml.namespace.QName;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ListType;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.w3c.dom.Element;

public class ContactGroupSipImpl
implements ContactGroup {
    private Vector<Contact> contacts = new Vector();
    private Vector<ContactGroup> subGroups = new Vector();
    private ContactGroupSipImpl parentGroup = null;
    private boolean isPersistent = true;
    private ProtocolProviderServiceSipImpl parentProvider = null;
    private boolean isResolved = true;
    private String uid = null;
    private static final String UID_SUFFIX = ".uid";
    private final ListType list = new ListType();

    public ContactGroupSipImpl(String groupName, ProtocolProviderServiceSipImpl parentProvider) {
        this.list.setName(groupName);
        this.uid = this.list.getName() + UID_SUFFIX;
        this.parentProvider = parentProvider;
    }

    ListType getList() {
        return this.list;
    }

    void setOtherAttributes(Map<QName, String> otherAttributes) {
        this.list.setAnyAttributes(otherAttributes);
    }

    void setAny(List<Element> any) {
        this.list.setAny(any);
    }

    void setName(String newName) {
        this.list.setName(newName);
    }

    public boolean canContainSubgroups() {
        return true;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.parentProvider;
    }

    public Iterator<Contact> contacts() {
        return this.contacts.iterator();
    }

    public void addContact(ContactSipImpl contactToAdd) {
        this.contacts.add((Contact)contactToAdd);
        contactToAdd.setParentGroup(this);
        if (contactToAdd.isPersistent()) {
            this.list.getEntries().add(contactToAdd.getEntry());
        }
    }

    public int countContacts() {
        return this.contacts.size();
    }

    public int countSubgroups() {
        return this.subGroups.size();
    }

    void setParentGroup(ContactGroupSipImpl parent) {
        this.parentGroup = parent;
    }

    public ContactGroup getParentContactGroup() {
        return this.parentGroup;
    }

    public void addSubgroup(ContactGroupSipImpl subgroup) {
        this.subGroups.add(subgroup);
        subgroup.setParentGroup(this);
        if (subgroup.isPersistent()) {
            this.list.getLists().add(subgroup.getList());
        }
    }

    public void removeSubGroup(ContactGroupSipImpl subgroup) {
        this.subGroups.remove(subgroup);
        subgroup.setParentGroup(null);
        if (subgroup.isPersistent()) {
            this.list.getLists().remove(subgroup.getList());
        }
    }

    public ContactGroupSipImpl findGroupParent(ContactGroupSipImpl sipGroup) {
        if (this.subGroups.contains(sipGroup)) {
            return this;
        }
        Iterator<ContactGroup> subGroupsIter = this.subgroups();
        while (subGroupsIter.hasNext()) {
            ContactGroupSipImpl subgroup = (ContactGroupSipImpl)subGroupsIter.next();
            ContactGroupSipImpl parent = subgroup.findGroupParent(sipGroup);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public ContactGroupSipImpl findContactParent(ContactSipImpl sipContact) {
        if (this.contacts.contains((Object)sipContact)) {
            return this;
        }
        Iterator<ContactGroup> subGroupsIter = this.subgroups();
        while (subGroupsIter.hasNext()) {
            ContactGroupSipImpl subgroup = (ContactGroupSipImpl)subGroupsIter.next();
            ContactGroupSipImpl parent = subgroup.findContactParent(sipContact);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public Contact getContact(String id) {
        Iterator<Contact> contactsIter = this.contacts();
        while (contactsIter.hasNext()) {
            ContactSipImpl contact = (ContactSipImpl)contactsIter.next();
            if (!contact.getUri().equals(id) && !contact.getAddress().equals(id)) continue;
            return contact;
        }
        return null;
    }

    public ContactGroup getGroup(int index) {
        return this.subGroups.get(index);
    }

    public ContactGroup getGroup(String groupName) {
        Iterator<ContactGroup> groupsIter = this.subgroups();
        while (groupsIter.hasNext()) {
            ContactGroupSipImpl contactGroup = (ContactGroupSipImpl)groupsIter.next();
            if (!contactGroup.getGroupName().equals(groupName)) continue;
            return contactGroup;
        }
        return null;
    }

    public String getGroupName() {
        return this.list.getName();
    }

    public Iterator<ContactGroup> subgroups() {
        return this.subGroups.iterator();
    }

    public void removeContact(ContactSipImpl contact) {
        this.contacts.remove((Object)contact);
        if (contact.isPersistent()) {
            this.list.getEntries().remove(contact.getEntry());
        }
    }

    public ContactSipImpl findContactByID(String id) {
        Iterator<Contact> contactsIter = this.contacts();
        while (contactsIter.hasNext()) {
            ContactSipImpl mContact = (ContactSipImpl)contactsIter.next();
            if (!mContact.getAddress().equals(id)) continue;
            return mContact;
        }
        Iterator<ContactGroup> groupsIter = this.subgroups();
        while (groupsIter.hasNext()) {
            ContactGroupSipImpl mGroup = (ContactGroupSipImpl)groupsIter.next();
            ContactSipImpl mContact = mGroup.findContactByID(id);
            if (mContact == null) continue;
            return mContact;
        }
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.getGroupName());
        buff.append(".subGroups=" + this.countSubgroups() + ":\n");
        Iterator<ContactGroup> subGroups = this.subgroups();
        while (subGroups.hasNext()) {
            ContactGroupSipImpl group = (ContactGroupSipImpl)subGroups.next();
            buff.append(group.toString());
            if (!subGroups.hasNext()) continue;
            buff.append("\n");
        }
        buff.append("\nChildContacts=" + this.countContacts() + ":[");
        Iterator<Contact> contacts = this.contacts();
        while (contacts.hasNext()) {
            ContactSipImpl contact = (ContactSipImpl)contacts.next();
            buff.append(contact.toString());
            if (!contacts.hasNext()) continue;
            buff.append(", ");
        }
        return buff.append("]").toString();
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public String getPersistentData() {
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setResolved(boolean resolved) {
        this.isResolved = resolved;
    }

    public String getUID() {
        return this.uid;
    }

    static String createNameFromUID(String uid) {
        return uid.substring(0, uid.length() - UID_SUFFIX.length());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ContactGroupSipImpl)) {
            return false;
        }
        ContactGroupSipImpl sipGroup = (ContactGroupSipImpl)obj;
        if (!sipGroup.getGroupName().equals(this.getGroupName()) || !sipGroup.getUID().equals(this.getUID()) || sipGroup.countContacts() != this.countContacts() || sipGroup.countSubgroups() != this.countSubgroups()) {
            return false;
        }
        if (this.getProtocolProvider() != ((ContactGroup)obj).getProtocolProvider()) {
            return false;
        }
        Iterator<Contact> theirContacts = sipGroup.contacts();
        while (theirContacts.hasNext()) {
            ContactSipImpl theirContact = (ContactSipImpl)theirContacts.next();
            ContactSipImpl ourContact = (ContactSipImpl)this.getContact(theirContact.getAddress());
            if (ourContact != null && ourContact.equals((Object)theirContact)) continue;
            return false;
        }
        Iterator<ContactGroup> theirSubgroups = sipGroup.subgroups();
        while (theirSubgroups.hasNext()) {
            ContactGroupSipImpl theirSubgroup = (ContactGroupSipImpl)theirSubgroups.next();
            ContactGroupSipImpl ourSubgroup = (ContactGroupSipImpl)this.getGroup(theirSubgroup.getGroupName());
            if (ourSubgroup != null && ourSubgroup.equals(theirSubgroup)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(this.getGroupName());
        objects.add(this.getUID());
        objects.add(this.countContacts());
        objects.add(this.countSubgroups());
        objects.add(this.getProtocolProvider());
        for (Contact c : this.contacts) {
            objects.add(c.getAddress());
        }
        for (ContactGroup g : this.subGroups) {
            objects.add(g.getGroupName());
        }
        return Objects.hash(objects.toArray());
    }
}

