/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.text.ParseException;
import java.util.UUID;
import javax.sip.ServerTransaction;
import javax.sip.SipProvider;
import javax.sip.header.Header;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;

public class DesktopSharingCallSipImpl
extends CallSipImpl {
    public static final String ENABLE_OUTOFDIALOG_DESKTOP_CONTROL_PROP = "net.java.sip.communicator.impl.protocol.sip.ENABLE_OUTOFDIALOG_DESKTOP_CONTROL_PROP";
    public static final String DSSID_HEADER = "DSSID";
    private String desktopSharingSessionID = null;

    protected DesktopSharingCallSipImpl(OperationSetBasicTelephonySipImpl parentOpSet) {
        super(parentOpSet);
    }

    public String getDesktopSharingSessionID() {
        return this.desktopSharingSessionID;
    }

    @Override
    public CallPeerSipImpl processInvite(SipProvider jainSipProvider, ServerTransaction serverTran) {
        Request invite = serverTran.getRequest();
        Header dssidHeader = invite.getHeader(DSSID_HEADER);
        if (dssidHeader != null) {
            String dssid;
            this.desktopSharingSessionID = dssid = dssidHeader.toString().replaceAll(dssidHeader.getName() + ":", "").trim();
            this.setData(DSSID_HEADER, this.desktopSharingSessionID);
        }
        return super.processInvite(jainSipProvider, serverTran);
    }

    @Override
    protected void processExtraHeaders(Message message) throws ParseException {
        if (message instanceof Request) {
            if (this.desktopSharingSessionID == null) {
                this.desktopSharingSessionID = UUID.randomUUID().toString();
                this.setData(DSSID_HEADER, this.desktopSharingSessionID);
            }
            Header dssidHeader = this.getProtocolProvider().getHeaderFactory().createHeader(DSSID_HEADER, this.desktopSharingSessionID);
            message.setHeader(dssidHeader);
        } else if (message instanceof Response && this.desktopSharingSessionID != null) {
            Header dssidHeader = this.getProtocolProvider().getHeaderFactory().createHeader(DSSID_HEADER, this.desktopSharingSessionID);
            message.setHeader(dssidHeader);
        }
    }
}

