/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.header.extensions.Replaces;
import gov.nist.javax.sip.header.extensions.ReplacesHeader;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ReferToHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.WarningHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.ActiveCallsRepositorySipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallPeerMediaHandlerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.DesktopSharingCallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.EventPackageUtils;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessor;
import net.java.sip.communicator.impl.protocol.sip.OperationSetAutoAnswerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;
import net.java.sip.communicator.service.protocol.OperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetSecureSDesTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSecureZrtpTelephony;
import net.java.sip.communicator.service.protocol.TransferAuthority;
import net.java.sip.communicator.service.protocol.event.CallChangeAdapter;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.Logger;

public class OperationSetBasicTelephonySipImpl
extends AbstractOperationSetBasicTelephony<ProtocolProviderServiceSipImpl>
implements MethodProcessor,
OperationSetAdvancedTelephony<ProtocolProviderServiceSipImpl>,
OperationSetSecureZrtpTelephony,
OperationSetSecureSDesTelephony {
    private static final Logger logger = Logger.getLogger(OperationSetBasicTelephonySipImpl.class);
    private final ProtocolProviderServiceSipImpl protocolProvider;
    private final SipMessageFactory messageFactory;
    private final ActiveCallsRepositorySipImpl activeCallsRepository = new ActiveCallsRepositorySipImpl(this);
    private TransferAuthority transferAuthority = null;
    private boolean desktopControlOutOfDialogEnabled = false;

    public OperationSetBasicTelephonySipImpl(ProtocolProviderServiceSipImpl protocolProvider) {
        this.protocolProvider = protocolProvider;
        this.messageFactory = protocolProvider.getMessageFactory();
        protocolProvider.registerMethodProcessor("INVITE", this);
        protocolProvider.registerMethodProcessor("CANCEL", this);
        protocolProvider.registerMethodProcessor("ACK", this);
        protocolProvider.registerMethodProcessor("BYE", this);
        protocolProvider.registerMethodProcessor("REFER", this);
        protocolProvider.registerMethodProcessor("NOTIFY", this);
        protocolProvider.registerMethodProcessor("UPDATE", this);
        protocolProvider.registerEvent("refer");
        this.desktopControlOutOfDialogEnabled = SipActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.protocol.sip.ENABLE_OUTOFDIALOG_DESKTOP_CONTROL_PROP", false);
    }

    public Call createCall(String callee, CallConference conference) throws OperationFailedException, ParseException {
        Address toAddress = this.protocolProvider.parseAddressString(callee);
        return this.createOutgoingCall(toAddress, null, conference);
    }

    protected synchronized CallSipImpl createOutgoingCall() throws OperationFailedException {
        this.assertRegistered();
        if (this.desktopControlOutOfDialogEnabled) {
            return new DesktopSharingCallSipImpl(this);
        }
        return new CallSipImpl(this);
    }

    synchronized CallSipImpl createOutgoingCall(Address calleeAddress, Message cause, CallConference conference) throws OperationFailedException {
        CallSipImpl call = this.createOutgoingCall();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating outgoing call to " + calleeAddress));
        }
        if (conference != null) {
            call.setConference(conference);
        }
        call.invite(calleeAddress, cause);
        return call;
    }

    public Iterator<CallSipImpl> getActiveCalls() {
        return this.activeCallsRepository.getActiveCalls();
    }

    protected ActiveCallsRepositorySipImpl getActiveCallsRepository() {
        return this.activeCallsRepository;
    }

    public void putOffHold(CallPeer peer) throws OperationFailedException {
        this.putOnHold(peer, false);
    }

    public void putOnHold(CallPeer peer) throws OperationFailedException {
        this.putOnHold(peer, true);
    }

    private synchronized void putOnHold(CallPeer peer, boolean on) throws OperationFailedException {
        ((CallPeerSipImpl)peer).putOnHold(on);
    }

    @Override
    public boolean processRequest(RequestEvent requestEvent) {
        ServerTransaction serverTransaction = requestEvent.getServerTransaction();
        SipProvider jainSipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        String requestMethod = request.getMethod();
        if (serverTransaction == null) {
            try {
                serverTransaction = SipStackSharing.getOrCreateServerTransaction(requestEvent);
            }
            catch (TransactionAlreadyExistsException ex) {
                logger.error((Object)"Failed to create a new servertransaction for an incoming request\n(Next message contains the request)", (Throwable)ex);
                return false;
            }
            catch (TransactionUnavailableException ex) {
                logger.error((Object)"Failed to create a new servertransaction for an incoming request\n(Next message contains the request)", (Throwable)ex);
                return false;
            }
        }
        boolean processed = false;
        if (requestMethod.equals("INVITE")) {
            DialogState dialogState;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"received INVITE");
            }
            if ((dialogState = serverTransaction.getDialog().getState()) == null || dialogState.equals((Object)DialogState.CONFIRMED)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("request is an INVITE. Dialog state=" + dialogState));
                }
                this.processInvite(jainSipProvider, serverTransaction);
                processed = true;
            } else {
                if (dialogState.equals((Object)DialogState.TERMINATED)) {
                    this.processStrayInvite(serverTransaction);
                } else {
                    logger.error((Object)("reINVITEs while the dialog is not confirmed are not currently supported. DialogState is: " + dialogState));
                }
                processed = true;
            }
        } else if (requestMethod.equals("ACK")) {
            this.processAck(serverTransaction, request);
            processed = true;
        } else if (requestMethod.equals("BYE")) {
            this.processBye(serverTransaction, request);
            processed = true;
        } else if (requestMethod.equals("CANCEL")) {
            this.processCancel(serverTransaction, request);
            processed = true;
        } else if (requestMethod.equals("REFER")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"received REFER");
            }
            this.processRefer(serverTransaction, request, jainSipProvider);
            processed = true;
        } else if (requestMethod.equals("NOTIFY")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"received NOTIFY");
            }
            processed = this.processNotify(serverTransaction, request);
        } else if (requestMethod.equals("UPDATE")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"received UPDATE");
            }
            processed = this.processUpdate(serverTransaction, request);
        }
        return processed;
    }

    @Override
    public boolean processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        return false;
    }

    @Override
    public boolean processResponse(ResponseEvent responseEvent) {
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        Response response = responseEvent.getResponse();
        CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
        if (cseq == null) {
            logger.error((Object)"An incoming response did not contain a CSeq header");
            return false;
        }
        String method = cseq.getMethod();
        SipProvider sourceProvider = (SipProvider)responseEvent.getSource();
        int responseStatusCode = response.getStatusCode();
        boolean processed = false;
        switch (responseStatusCode) {
            case 200: {
                if (!method.equals("INVITE")) break;
                this.processInviteOK(clientTransaction, response);
                processed = true;
                break;
            }
            case 180: {
                this.processRinging(clientTransaction, response);
                processed = true;
                break;
            }
            case 183: {
                this.processSessionProgress(clientTransaction, response);
                processed = true;
                break;
            }
            case 100: {
                this.processTrying(clientTransaction, response);
                processed = true;
                break;
            }
            case 486: 
            case 600: 
            case 603: {
                this.processBusyHere(clientTransaction, response);
                processed = true;
                break;
            }
            case 202: {
                if (!"REFER".equals(method)) break;
                this.processReferAccepted(clientTransaction, response);
                processed = true;
                break;
            }
            case 401: 
            case 407: {
                this.processAuthenticationChallenge(clientTransaction, response, sourceProvider);
                processed = true;
                break;
            }
            case 487: {
                CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(clientTransaction.getDialog());
                if (callPeer != null) {
                    String reasonPhrase = response.getReasonPhrase();
                    if (reasonPhrase == null || reasonPhrase.trim().length() == 0) {
                        reasonPhrase = "Request terminated by server!";
                    }
                    callPeer.setState(CallPeerState.FAILED, reasonPhrase);
                }
                processed = true;
                break;
            }
            case 301: 
            case 302: {
                CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(clientTransaction.getDialog());
                if (callPeer == null) {
                    logger.error((Object)"Failed to find a forwarded call peer.");
                    return true;
                }
                ContactHeader contactHeader = (ContactHeader)response.getHeader("Contact");
                if (contactHeader == null) {
                    logger.error((Object)("Received a forward with no Contact destination: " + response.getStatusCode() + " " + response.getReasonPhrase()));
                    callPeer.setState(CallPeerState.FAILED, response.getReasonPhrase());
                    return true;
                }
                Address redirectAddress = contactHeader.getAddress();
                if (callPeer.getPeerAddress().getURI().equals(redirectAddress.getURI())) {
                    logger.error((Object)("Redirect loop detected for: " + callPeer.getPeerAddress().getURI()));
                    callPeer.setState(CallPeerState.FAILED, "Redirect loop detected for: " + callPeer.getPeerAddress().getURI());
                    return true;
                }
                CallSipImpl call = (CallSipImpl)callPeer.getCall();
                try {
                    call.invite(redirectAddress, null);
                }
                catch (OperationFailedException exc) {
                    logger.error((Object)("Call forward failed for address " + contactHeader.getAddress()), (Throwable)exc);
                    callPeer.setState(CallPeerState.DISCONNECTED, "Call forwarded failed. " + exc.getMessage());
                }
                callPeer.setState(CallPeerState.DISCONNECTED, "Call forwarded. " + response.getReasonPhrase());
                processed = true;
                break;
            }
            default: {
                int responseStatusCodeRange = responseStatusCode / 100;
                Request request = responseEvent.getClientTransaction().getRequest();
                if (responseStatusCode == 500 && this.isRemoteControlNotification(request)) {
                    return true;
                }
                CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(clientTransaction.getDialog());
                if (responseStatusCodeRange == 4 || responseStatusCodeRange == 5 || responseStatusCodeRange == 6) {
                    String reason = response.getReasonPhrase();
                    WarningHeader warningHeader = (WarningHeader)response.getHeader("Warning");
                    if (warningHeader != null) {
                        reason = warningHeader.getText();
                        logger.error((Object)("Received error: " + response.getStatusCode() + " " + response.getReasonPhrase() + " " + warningHeader.getText() + "-" + warningHeader.getAgent() + "-" + warningHeader.getName()));
                    } else {
                        logger.error((Object)("Received error: " + response.getStatusCode() + " " + response.getReasonPhrase()));
                    }
                    if (callPeer != null) {
                        callPeer.setState(CallPeerState.FAILED, reason);
                    }
                    processed = true;
                    break;
                }
                if (responseStatusCodeRange != 2 && responseStatusCodeRange != 3) break;
                logger.error((Object)("Received an non-supported final response: " + response.getStatusCode() + " " + response.getReasonPhrase()));
                if (callPeer != null) {
                    callPeer.setState(CallPeerState.FAILED, response.getReasonPhrase());
                }
                processed = true;
            }
        }
        return processed;
    }

    private void processReferAccepted(ClientTransaction clientTransaction, Response accepted) {
        try {
            EventPackageUtils.addSubscription(clientTransaction.getDialog(), "refer");
        }
        catch (SipException ex) {
            logger.error((Object)("Failed to make Accepted REFER response keep the dialog alive after BYE:\n" + accepted), (Throwable)ex);
        }
    }

    private void processTrying(ClientTransaction clientTransaction, Response response) {
        Dialog dialog = clientTransaction.getDialog();
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(dialog);
        if (callPeer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a stray trying response.");
            }
            return;
        }
        CallPeerState callPeerState = callPeer.getState();
        if (!CallPeerState.CONNECTED.equals(callPeerState) && !CallPeerState.isOnHold((CallPeerState)callPeerState)) {
            callPeer.setState(CallPeerState.CONNECTING);
        }
    }

    private void processRinging(ClientTransaction clientTransaction, Response response) {
        Address remotePartyAddress;
        String displayName;
        Dialog dialog = clientTransaction.getDialog();
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(dialog);
        if (callPeer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a stray trying response.");
            }
            return;
        }
        ContactHeader remotePartyContactHeader = (ContactHeader)response.getHeader("Contact");
        if (remotePartyContactHeader != null && (displayName = (remotePartyAddress = remotePartyContactHeader.getAddress()).getDisplayName()) != null && displayName.trim().length() > 0) {
            callPeer.setDisplayName(displayName);
        }
        callPeer.setState(CallPeerState.ALERTING_REMOTE_SIDE);
    }

    private void processSessionProgress(ClientTransaction tran, Response response) {
        Dialog dialog = tran.getDialog();
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(dialog);
        if (callPeer.getState() == CallPeerState.CONNECTING_WITH_EARLY_MEDIA) {
            logger.warn((Object)"Ignoring invite 183 since call peer is already exchanging early media.");
            return;
        }
        callPeer.processSessionProgress(tran, response);
    }

    private void processInviteOK(ClientTransaction clientTransaction, Response ok) {
        Dialog dialog = clientTransaction.getDialog();
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(dialog);
        if (callPeer == null) {
            callPeer = this.activeCallsRepository.findCallPeer(clientTransaction.getBranchId(), ok.getHeader("Call-ID"));
            if (callPeer == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Received a stray ok response.");
                }
                return;
            }
            callPeer.setDialog(dialog);
        }
        callPeer.processInviteOK(clientTransaction, ok);
    }

    private void processBusyHere(ClientTransaction clientTransaction, Response busyHere) {
        Dialog dialog = clientTransaction.getDialog();
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(dialog);
        if (callPeer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a stray busyHere response.");
            }
            return;
        }
        callPeer.setState(CallPeerState.BUSY);
    }

    private void processAuthenticationChallenge(ClientTransaction clientTransaction, Response response, SipProvider jainSipProvider) {
        block6: {
            CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(clientTransaction.getDialog());
            try {
                ClientTransaction retryTran;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Authenticating an INVITE request.");
                }
                if ((retryTran = this.protocolProvider.getSipSecurityManager().handleChallenge(response, clientTransaction, jainSipProvider)) == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"No password supplied or error occured!");
                    }
                    return;
                }
                if (callPeer != null) {
                    callPeer.handleAuthenticationChallenge(retryTran);
                }
                retryTran.sendRequest();
            }
            catch (Exception exc) {
                if (callPeer == null) break block6;
                callPeer.logAndFail("Failed to authenticate.", exc);
            }
        }
    }

    @Override
    public boolean processTimeout(TimeoutEvent timeoutEvent) {
        if (timeoutEvent.isServerTransaction()) {
            return false;
        }
        ClientTransaction transaction = timeoutEvent.getClientTransaction();
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(transaction.getDialog());
        if (callPeer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Got a headless timeout event." + timeoutEvent));
            }
            return false;
        }
        Request request = timeoutEvent.getClientTransaction().getRequest();
        if (this.isRemoteControlNotification(request)) {
            return true;
        }
        try {
            this.hangupCallPeer((CallPeer)callPeer, 408, "The remote party has not replied!The call will be disconnected");
        }
        catch (Throwable e) {
            callPeer.setState(CallPeerState.FAILED, "The remote party has not replied!The call will be disconnected");
        }
        return true;
    }

    @Override
    public boolean processIOException(IOExceptionEvent exceptionEvent) {
        logger.error((Object)("Got an asynchronous exception event. host=" + exceptionEvent.getHost() + " port=" + exceptionEvent.getPort()));
        return true;
    }

    @Override
    public boolean processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(dialogTerminatedEvent.getDialog());
        if (callPeer == null) {
            return false;
        }
        callPeer.setState(CallPeerState.DISCONNECTED);
        return true;
    }

    private void processInvite(SipProvider sourceProvider, ServerTransaction serverTransaction) {
        Request invite = serverTransaction.getRequest();
        Dialog dialog = serverTransaction.getDialog();
        CallPeerSipImpl existingPeer = this.activeCallsRepository.findCallPeer(dialog);
        OperationSetAutoAnswerSipImpl autoAnswerOpSet = (OperationSetAutoAnswerSipImpl)this.protocolProvider.getOperationSet(OperationSetBasicAutoAnswer.class);
        if (existingPeer != null) {
            existingPeer.processReInvite(serverTransaction);
            return;
        }
        ReplacesHeader replacesHeader = (ReplacesHeader)invite.getHeader("Replaces");
        if (replacesHeader != null) {
            existingPeer = this.activeCallsRepository.findCallPeer(replacesHeader.getCallId(), replacesHeader.getToTag(), replacesHeader.getFromTag());
            if (existingPeer != null) {
                ((CallSipImpl)existingPeer.getCall()).processReplacingInvite(sourceProvider, serverTransaction, existingPeer);
            } else {
                this.protocolProvider.sayErrorSilently(serverTransaction, 481);
            }
            return;
        }
        if (autoAnswerOpSet != null && autoAnswerOpSet.forwardCall(invite, serverTransaction)) {
            return;
        }
        CallSipImpl call = this.desktopControlOutOfDialogEnabled ? new DesktopSharingCallSipImpl(this) : new CallSipImpl(this);
        CallPeerSipImpl peer = call.processInvite(sourceProvider, serverTransaction);
        if (this.failServerTranForInsufficientSecurity(peer, serverTransaction)) {
            return;
        }
        if (autoAnswerOpSet != null) {
            autoAnswerOpSet.autoAnswer((Call)call);
        }
    }

    private boolean failServerTranForInsufficientSecurity(MediaAwareCallPeer<?, ?, ?> peer, ServerTransaction serverTransaction) {
        if (this.getProtocolProvider().getAccountID().getAccountPropertyBoolean((Object)"MODE_PARANOIA", false) && peer.getMediaHandler().getAdvertisedEncryptionMethods().length == 0) {
            String reasonText = SipActivator.getResources().getI18NString("service.gui.security.encryption.required");
            peer.setState(CallPeerState.FAILED, reasonText, 606);
            WarningHeader warning = null;
            try {
                warning = this.protocolProvider.getHeaderFactory().createWarningHeader(this.protocolProvider.getAccountID().getService(), 399, reasonText);
            }
            catch (ParseException | InvalidArgumentException e) {
                logger.error((Object)"Cannot create warning header", e);
            }
            try {
                this.protocolProvider.sayError(serverTransaction, 606, (Header)warning);
            }
            catch (OperationFailedException e) {
                logger.error((Object)"Cannot send 606 error!", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private void processBye(ServerTransaction serverTransaction, Request byeRequest) {
        Dialog dialog = serverTransaction.getDialog();
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(dialog);
        if (callPeer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a stray bye request.");
            }
            return;
        }
        callPeer.processBye(serverTransaction);
    }

    private void processStrayInvite(ServerTransaction serverTransaction) {
        logger.info((Object)"got an INVITE for a dead dialog. Rejecting");
        Request inviteRequest = serverTransaction.getRequest();
        Response noSuchCall = null;
        try {
            noSuchCall = this.messageFactory.createResponse(481, inviteRequest);
        }
        catch (ParseException ex) {
            logger.error((Object)"Error while trying to send a response to an INVITE", (Throwable)ex);
        }
        if (noSuchCall != null) {
            try {
                serverTransaction.sendResponse(noSuchCall);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sent response " + noSuchCall));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to reject a stray INVITE with a 481, exception was:\n", (Throwable)ex);
            }
        }
    }

    private void processCancel(ServerTransaction serverTransaction, Request cancelRequest) {
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(serverTransaction.getDialog());
        if (callPeer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"received a stray CANCEL req. ignoring");
            }
            return;
        }
        callPeer.processCancel(serverTransaction);
    }

    private void processAck(ServerTransaction serverTransaction, Request ackRequest) {
        CallPeerSipImpl peer = this.activeCallsRepository.findCallPeer(serverTransaction.getDialog());
        if (peer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"didn't find an ack's call, returning");
            }
            return;
        }
        peer.processAck(serverTransaction, ackRequest);
    }

    private void processRefer(ServerTransaction serverTransaction, Request referRequest, final SipProvider sipProvider) {
        CallSipImpl referToCall;
        ReferToHeader referToHeader = (ReferToHeader)referRequest.getHeader("Refer-To");
        if (referToHeader == null) {
            logger.error((Object)("No Refer-To header in REFER request:\n" + referRequest));
            return;
        }
        Address referToAddress = referToHeader.getAddress();
        if (referToAddress == null) {
            logger.error((Object)("No address in REFER request Refer-To header:\n" + referRequest));
            return;
        }
        final Dialog dialog = serverTransaction.getDialog();
        CallPeerSipImpl callPeer = this.activeCallsRepository.findCallPeer(dialog);
        if (callPeer == null) {
            boolean allowTransfer;
            if (this.transferAuthority == null) {
                logger.warn((Object)("Ignoring REFER request without call for request:" + referRequest));
                try {
                    serverTransaction.terminate();
                }
                catch (Throwable e) {
                    logger.warn((Object)("Failed to properly terminate transaction for a rogue request. Well ... so be it Request:" + referRequest));
                }
                return;
            }
            FromHeader fromHeader = (FromHeader)referRequest.getHeader("From");
            OperationSetPresenceSipImpl opSetPersPresence = (OperationSetPresenceSipImpl)this.protocolProvider.getOperationSet(OperationSetPersistentPresence.class);
            ContactSipImpl from = null;
            if (opSetPersPresence != null) {
                from = opSetPersPresence.resolveContactID(fromHeader.getAddress().getURI().toString());
            }
            if (from == null && opSetPersPresence != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("received a message from an unknown contact: " + fromHeader.getAddress().getURI().toString()));
                }
                from = opSetPersPresence.createVolatileContact(fromHeader.getAddress().getURI().toString());
            }
            if (!(allowTransfer = from != null ? this.transferAuthority.processTransfer((Contact)from, referToAddress.getURI().toString()) : this.transferAuthority.processTransfer(fromHeader.getAddress().getURI().toString(), referToAddress.getURI().toString()))) {
                Response declineResponse;
                try {
                    declineResponse = this.protocolProvider.getMessageFactory().createResponse(603, referRequest);
                }
                catch (ParseException e) {
                    logger.error((Object)"Error while creating 603 response", (Throwable)e);
                    return;
                }
                try {
                    serverTransaction.sendResponse(declineResponse);
                }
                catch (Exception e) {
                    logger.error((Object)"Error while sending the response 603", (Throwable)e);
                    return;
                }
                return;
            }
        }
        Response accepted = null;
        try {
            accepted = this.protocolProvider.getMessageFactory().createResponse(202, referRequest);
        }
        catch (ParseException ex) {
            logger.error((Object)("Failed to create Accepted response to REFER request:\n" + referRequest), (Throwable)ex);
        }
        boolean removeSubscription = false;
        if (accepted != null) {
            Throwable failure = null;
            try {
                serverTransaction.sendResponse(accepted);
            }
            catch (InvalidArgumentException | SipException ex) {
                failure = ex;
            }
            if (failure != null) {
                accepted = null;
                logger.error((Object)("Failed to send Accepted response to REFER request:\n" + referRequest), failure);
            } else {
                try {
                    removeSubscription = EventPackageUtils.addSubscription(dialog, referRequest);
                }
                catch (SipException ex) {
                    logger.error((Object)("Failed to make the REFER request keep the dialog alive after BYE:\n" + referRequest), (Throwable)ex);
                }
                try {
                    this.sendReferNotifyRequest(dialog, "active", null, "SIP/2.0 100 Trying", sipProvider);
                }
                catch (OperationFailedException ex) {
                    // empty catch block
                }
            }
        }
        if (callPeer != null) {
            callPeer.setState(CallPeerState.REFERRED);
        }
        try {
            referToCall = this.createOutgoingCall(referToAddress, (Message)referRequest, null);
        }
        catch (OperationFailedException ex) {
            referToCall = null;
            logger.error((Object)("Failed to create outgoing call to " + referToAddress), (Throwable)ex);
        }
        final CallSipImpl referToCallListenerSource = referToCall;
        final boolean sendNotifyRequest = accepted != null;
        final Request subscription = removeSubscription ? referRequest : null;
        CallChangeAdapter referToCallListener = new CallChangeAdapter(){
            private boolean done;

            public synchronized void callStateChanged(CallChangeEvent evt) {
                if (evt != null && !evt.getEventType().equals("CallState")) {
                    return;
                }
                if (!this.done && OperationSetBasicTelephonySipImpl.this.referToCallStateChanged(referToCallListenerSource, sendNotifyRequest, dialog, sipProvider, subscription)) {
                    this.done = true;
                    if (referToCallListenerSource != null) {
                        referToCallListenerSource.removeCallChangeListener((CallChangeListener)this);
                    }
                }
            }
        };
        if (referToCall != null) {
            referToCall.addCallChangeListener((CallChangeListener)referToCallListener);
        }
        referToCallListener.callStateChanged(null);
    }

    private boolean processNotify(ServerTransaction serverTransaction, Request notifyRequest) {
        EventHeader eventHeader = (EventHeader)notifyRequest.getHeader("Event");
        if (eventHeader == null || !"refer".equals(eventHeader.getEventType())) {
            return false;
        }
        SubscriptionStateHeader ssHeader = (SubscriptionStateHeader)notifyRequest.getHeader("Subscription-State");
        if (ssHeader == null) {
            logger.error((Object)"NOTIFY of refer event typewith no Subscription-State header.");
            return false;
        }
        Dialog dialog = serverTransaction.getDialog();
        CallPeerSipImpl peer = this.activeCallsRepository.findCallPeer(dialog);
        if (peer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a stray refer NOTIFY request.");
            }
            return false;
        }
        try {
            Response ok = this.messageFactory.createResponse(200, notifyRequest);
            serverTransaction.sendResponse(ok);
        }
        catch (ParseException ex) {
            String message = "Failed to create OK response to refer NOTIFY.";
            logger.error((Object)message, (Throwable)ex);
            peer.setState(CallPeerState.DISCONNECTED, message);
            return false;
        }
        catch (Exception ex) {
            String message = "Failed to send OK response to refer NOTIFY request.";
            logger.error((Object)message, (Throwable)ex);
            peer.setState(CallPeerState.DISCONNECTED, message);
            return false;
        }
        if ("terminated".equalsIgnoreCase(ssHeader.getState()) && !EventPackageUtils.removeSubscriptionThenIsDialogAlive(dialog, "refer")) {
            peer.setState(CallPeerState.DISCONNECTED);
        }
        if (!CallPeerState.DISCONNECTED.equals(peer.getState()) && !EventPackageUtils.isByeProcessed(dialog)) {
            try {
                peer.hangup();
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"Failed to send BYE in response to refer NOTIFY request.", (Throwable)ex);
            }
        }
        return true;
    }

    private boolean processUpdate(ServerTransaction serverTransaction, Request updateRequest) {
        ContentLengthHeader cl = updateRequest.getContentLength();
        if (cl != null && cl.getContentLength() > 0) {
            return false;
        }
        try {
            Response ok = this.messageFactory.createResponse(200, updateRequest);
            serverTransaction.sendResponse(ok);
        }
        catch (ParseException ex) {
            String message = "Failed to create OK response to UPDATE.";
            logger.error((Object)message, (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            String message = "Failed to send OK response to UPDATE request.";
            logger.error((Object)message, (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean referToCallStateChanged(CallSipImpl referToCall, boolean sendNotifyRequest, Dialog dialog, SipProvider sipProvider, Object subscription) {
        CallPeerSipImpl callPeer;
        CallState referToCallState;
        CallState callState = referToCallState = referToCall == null ? null : referToCall.getCallState();
        if (CallState.CALL_INITIALIZATION.equals(referToCallState)) {
            return false;
        }
        if (sendNotifyRequest) {
            String referStatus = CallState.CALL_IN_PROGRESS.equals(referToCallState) ? "SIP/2.0 200 OK" : "SIP/2.0 603 Declined";
            try {
                this.sendReferNotifyRequest(dialog, "terminated", "noresource", referStatus, sipProvider);
            }
            catch (OperationFailedException operationFailedException) {
                // empty catch block
            }
        }
        if (!EventPackageUtils.removeSubscriptionThenIsDialogAlive(dialog, subscription) && (callPeer = this.activeCallsRepository.findCallPeer(dialog)) != null) {
            callPeer.setState(CallPeerState.DISCONNECTED);
        }
        return true;
    }

    private void sendReferNotifyRequest(Dialog dialog, String subscriptionState, String reasonCode, Object content, SipProvider sipProvider) throws OperationFailedException {
        Request notify = this.messageFactory.createRequest(dialog, "NOTIFY");
        HeaderFactory headerFactory = this.protocolProvider.getHeaderFactory();
        String eventType = "refer";
        try {
            notify.setHeader((Header)headerFactory.createEventHeader(eventType));
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create " + eventType + " Event header.", 4, ex, logger);
        }
        SubscriptionStateHeader ssHeader = null;
        try {
            ssHeader = headerFactory.createSubscriptionStateHeader(subscriptionState);
            if (reasonCode != null) {
                ssHeader.setReasonCode(reasonCode);
            }
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create " + subscriptionState + " Subscription-State header.", 4, ex, logger);
        }
        notify.setHeader((Header)ssHeader);
        ContentTypeHeader ctHeader = null;
        try {
            ctHeader = headerFactory.createContentTypeHeader("message", "sipfrag");
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create Content-Type header.", 4, ex, logger);
        }
        try {
            notify.setContent(content, ctHeader);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to set NOTIFY body/content.", 4, ex, logger);
        }
        this.protocolProvider.sendInDialogRequest(sipProvider, notify, dialog);
    }

    public void hangupCallPeer(CallPeer peer) throws ClassCastException, OperationFailedException {
        this.hangupCallPeer(peer, 200, null);
    }

    public synchronized void hangupCallPeer(CallPeer peer, int reasonCode, String reason) throws ClassCastException, OperationFailedException {
        ((CallPeerSipImpl)peer).hangup(reasonCode, reason);
    }

    public synchronized void answerCallPeer(CallPeer peer) throws OperationFailedException, ClassCastException {
        ((CallPeerSipImpl)peer).answer();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-[dn=" + this.protocolProvider.getOurDisplayName() + (this.protocolProvider.getRegistrarConnection() != null ? " addr=[" + this.protocolProvider.getRegistrarConnection().getAddressOfRecord() + "]" : "]");
    }

    public synchronized void shutdown() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Ending all active calls.");
        }
        Iterator activeCalls = this.activeCallsRepository.getActiveCalls();
        while (activeCalls.hasNext()) {
            CallSipImpl call = (CallSipImpl)((Object)activeCalls.next());
            Iterator callPeers = call.getCallPeers();
            while (callPeers.hasNext()) {
                CallPeer peer = (CallPeer)callPeers.next();
                try {
                    this.hangupCallPeer(peer);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Failed to properly hangup particpant " + peer), (Throwable)ex);
                }
            }
        }
    }

    public boolean isSecure(CallPeer peer) {
        return ((CallPeerMediaHandlerSipImpl)((CallPeerSipImpl)peer).getMediaHandler()).isSecure();
    }

    private void transfer(CallPeer peer, Address target) throws OperationFailedException {
        CallPeerSipImpl sipPeer = (CallPeerSipImpl)peer;
        Dialog dialog = sipPeer.getDialog();
        Request refer = this.messageFactory.createRequest(dialog, "REFER");
        HeaderFactory headerFactory = this.protocolProvider.getHeaderFactory();
        refer.setHeader((Header)headerFactory.createReferToHeader(target));
        refer.addHeader((Header)((HeaderFactoryImpl)headerFactory).createReferredByHeader(dialog.getLocalParty()));
        this.protocolProvider.sendInDialogRequest(sipPeer.getJainSipProvider(), refer, dialog);
    }

    public void transfer(CallPeer transferee, CallPeer transferTarget) throws OperationFailedException {
        Address targetAddress = this.parseAddressString(transferTarget.getAddress());
        Dialog targetDialog = ((CallPeerSipImpl)transferTarget).getDialog();
        String remoteTag = targetDialog.getRemoteTag();
        String localTag = targetDialog.getLocalTag();
        Replaces replacesHeader = null;
        SipURI sipURI = (SipURI)targetAddress.getURI();
        try {
            replacesHeader = (Replaces)((HeaderFactoryImpl)this.protocolProvider.getHeaderFactory()).createReplacesHeader(targetDialog.getCallId().getCallId(), remoteTag == null ? "0" : remoteTag, localTag == null ? "0" : localTag);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create Replaces header for target dialog " + targetDialog, 11, ex, logger);
        }
        try {
            sipURI.setHeader("Replaces", URLEncoder.encode(replacesHeader.encodeBody(new StringBuilder()).toString(), "UTF-8"));
        }
        catch (Exception ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to set Replaces header " + replacesHeader + " to SipURI " + sipURI, 4, ex, logger);
        }
        this.putOnHold(transferee);
        this.putOnHold(transferTarget);
        this.transfer(transferee, targetAddress);
    }

    public void transfer(CallPeer peer, String target) throws OperationFailedException {
        this.transfer(peer, this.parseAddressString(target));
    }

    private Address parseAddressString(String addressString) throws OperationFailedException {
        Address address = null;
        try {
            address = this.protocolProvider.parseAddressString(addressString);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to parse address string " + addressString, 11, ex, logger);
        }
        return address;
    }

    void assertRegistered() throws OperationFailedException {
        if (this.protocolProvider.isRegistrationRequiredForCalling() && !this.protocolProvider.isRegistered()) {
            throw new OperationFailedException("The protocol provider should be registered before placing an outgoing call.", 3);
        }
    }

    public ProtocolProviderServiceSipImpl getProtocolProvider() {
        return this.protocolProvider;
    }

    private boolean isRemoteControlNotification(Request request) {
        if (!request.getMethod().equals("NOTIFY")) {
            return false;
        }
        byte[] raw = request.getRawContent();
        String content = new String(raw);
        return content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<remote-control>");
    }

    public void setTransferAuthority(TransferAuthority authority) {
        this.transferAuthority = authority;
    }
}

