/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.awt.Dimension;
import java.awt.Point;
import java.text.ParseException;
import javax.sip.address.Address;
import javax.sip.header.Header;
import javax.sip.message.Message;
import net.java.sip.communicator.impl.protocol.sip.CallPeerMediaHandlerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.DesktopSharingCallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetVideoTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.VideoMediaFormat;

public class OperationSetDesktopStreamingSipImpl
extends OperationSetVideoTelephonySipImpl
implements OperationSetDesktopStreaming {
    protected Dimension size = null;
    protected Point origin = null;
    private boolean desktopControlOutOfDialogEnabled = SipActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.protocol.sip.ENABLE_OUTOFDIALOG_DESKTOP_CONTROL_PROP", false);

    public OperationSetDesktopStreamingSipImpl(OperationSetBasicTelephonySipImpl basicTelephony) {
        super(basicTelephony);
    }

    public MediaUseCase getMediaUseCase() {
        return MediaUseCase.DESKTOP;
    }

    public Call createVideoCall(String uri, MediaDevice mediaDevice) throws OperationFailedException, ParseException {
        return this.createVideoCall(((ProtocolProviderServiceSipImpl)this.parentProvider).parseAddressString(uri), mediaDevice);
    }

    public Call createVideoCall(Contact callee, MediaDevice mediaDevice) throws OperationFailedException {
        Address toAddress;
        try {
            toAddress = ((ProtocolProviderServiceSipImpl)this.parentProvider).parseAddressString(callee.getAddress());
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        return this.createVideoCall(toAddress, mediaDevice);
    }

    private Call createVideoCall(Address toAddress, MediaDevice mediaDevice) throws OperationFailedException {
        ((OperationSetBasicTelephonySipImpl)this.basicTelephony).assertRegistered();
        CallSipImpl call = this.desktopControlOutOfDialogEnabled ? new DesktopSharingCallSipImpl((OperationSetBasicTelephonySipImpl)this.basicTelephony){

            @Override
            protected void processExtraHeaders(Message message) throws ParseException {
                OperationSetDesktopStreamingSipImpl.this.addDesktopShareHeader(message);
            }
        } : new CallSipImpl((OperationSetBasicTelephonySipImpl)this.basicTelephony){

            @Override
            protected void processExtraHeaders(Message message) throws ParseException {
                OperationSetDesktopStreamingSipImpl.this.addDesktopShareHeader(message);
            }
        };
        MediaUseCase useCase = this.getMediaUseCase();
        call.setVideoDevice(mediaDevice, useCase);
        call.setLocalVideoAllowed(true, useCase);
        call.invite(toAddress, null);
        this.origin = OperationSetDesktopStreamingSipImpl.getOriginForMediaDevice(mediaDevice);
        return call;
    }

    protected void addDesktopShareHeader(Message message) throws ParseException {
        Header customDesktopShareHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getHeaderFactory().createHeader("X-Desktop-Share", "true");
        message.setHeader(customDesktopShareHeader);
    }

    @Override
    public Call createVideoCall(String uri) throws OperationFailedException, ParseException {
        CallSipImpl call = (CallSipImpl)super.createVideoCall(uri);
        MediaDevice device = call.getDefaultDevice(MediaType.VIDEO);
        this.size = ((VideoMediaFormat)device.getFormat()).getSize();
        this.origin = OperationSetDesktopStreamingSipImpl.getOriginForMediaDevice(device);
        return call;
    }

    @Override
    public Call createVideoCall(Contact callee) throws OperationFailedException {
        CallSipImpl call = (CallSipImpl)super.createVideoCall(callee);
        MediaDevice device = call.getDefaultDevice(MediaType.VIDEO);
        this.size = ((VideoMediaFormat)device.getFormat()).getSize();
        this.origin = OperationSetDesktopStreamingSipImpl.getOriginForMediaDevice(device);
        return call;
    }

    @Override
    public void setLocalVideoAllowed(Call call, boolean allowed) throws OperationFailedException {
        CallSipImpl callImpl = (CallSipImpl)call;
        MediaUseCase useCase = MediaUseCase.DESKTOP;
        callImpl.setLocalVideoAllowed(allowed, useCase);
        callImpl.setVideoDevice(null, useCase);
        MediaDevice device = callImpl.getDefaultDevice(MediaType.VIDEO);
        if (device.getFormat() != null) {
            this.size = ((VideoMediaFormat)device.getFormat()).getSize();
        }
        this.origin = OperationSetDesktopStreamingSipImpl.getOriginForMediaDevice(device);
        callImpl.reInvite();
    }

    public boolean isLocalVideoAllowed(Call call) {
        return ((CallSipImpl)call).isLocalVideoAllowed(MediaUseCase.DESKTOP);
    }

    public void setLocalVideoAllowed(Call call, MediaDevice mediaDevice, boolean allowed) throws OperationFailedException {
        CallSipImpl sipCall = (CallSipImpl)call;
        MediaUseCase useCase = MediaUseCase.DESKTOP;
        sipCall.setVideoDevice(mediaDevice, useCase);
        sipCall.setLocalVideoAllowed(allowed, useCase);
        this.size = ((VideoMediaFormat)sipCall.getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
        this.origin = OperationSetDesktopStreamingSipImpl.getOriginForMediaDevice(mediaDevice);
        sipCall.reInvite();
    }

    public boolean isPartialStreaming(Call call) {
        CallSipImpl callImpl = (CallSipImpl)call;
        MediaDevice device = callImpl.getDefaultDevice(MediaType.VIDEO);
        return device == null ? false : SipActivator.getMediaService().isPartialStreaming(device);
    }

    public void movePartialDesktopStreaming(Call call, int x, int y) {
        CallSipImpl callImpl = (CallSipImpl)call;
        VideoMediaStream videoStream = (VideoMediaStream)((CallPeerMediaHandlerSipImpl)((CallPeerSipImpl)((Object)callImpl.getCallPeers().next())).getMediaHandler()).getStream(MediaType.VIDEO);
        if (videoStream != null) {
            videoStream.movePartialDesktopStreaming(x, y);
            if (this.origin != null) {
                this.origin.x = x;
                this.origin.y = y;
            } else {
                this.origin = new Point(x, y);
            }
        }
    }

    public Point getOrigin() {
        return this.origin;
    }

    protected static Point getOriginForMediaDevice(MediaDevice device) {
        return SipActivator.getMediaService().getOriginForDesktopStreamingDevice(device);
    }
}

