/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;

public class OperationSetServerStoredAccountInfoSipImpl
extends AbstractOperationSetServerStoredAccountInfo
implements RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(OperationSetServerStoredAccountInfoSipImpl.class);
    private ProtocolProviderServiceSipImpl provider;
    private ServerStoredDetails.ImageDetail accountImage;
    private ServerStoredDetails.DisplayNameDetail displayNameDetail;
    private boolean isAccountImageLoaded = false;

    public OperationSetServerStoredAccountInfoSipImpl(ProtocolProviderServiceSipImpl provider) {
        this.provider = provider;
        this.provider.addRegistrationStateChangeListener(this);
    }

    public <T extends ServerStoredDetails.GenericDetail> Iterator<T> getDetailsAndDescendants(Class<T> detailClass) {
        Vector<Object> result = new Vector<Object>();
        if (ServerStoredDetails.ImageDetail.class.isAssignableFrom(detailClass) && this.isImageDetailSupported()) {
            ServerStoredDetails.ImageDetail imageDetail = this.getAccountImage();
            if (imageDetail != null) {
                ServerStoredDetails.ImageDetail t = this.getAccountImage();
                result.add(t);
            }
        } else if (ServerStoredDetails.DisplayNameDetail.class.isAssignableFrom(detailClass) && this.displayNameDetail != null) {
            ServerStoredDetails.DisplayNameDetail t = this.displayNameDetail;
            result.add(t);
        }
        return result.iterator();
    }

    public Iterator<ServerStoredDetails.GenericDetail> getDetails(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (ServerStoredDetails.ImageDetail.class.isAssignableFrom(detailClass) && this.isImageDetailSupported()) {
            ServerStoredDetails.ImageDetail imageDetail = this.getAccountImage();
            if (imageDetail != null) {
                result.add(this.getAccountImage());
            }
        } else if (ServerStoredDetails.DisplayNameDetail.class.isAssignableFrom(detailClass) && this.displayNameDetail != null) {
            result.add(this.displayNameDetail);
        }
        return result.iterator();
    }

    public Iterator<ServerStoredDetails.GenericDetail> getAllAvailableDetails() {
        ServerStoredDetails.ImageDetail imageDetail;
        ArrayList<Object> details = new ArrayList<Object>();
        if (this.isImageDetailSupported() && (imageDetail = this.getAccountImage()) != null) {
            details.add(this.getAccountImage());
        }
        if (this.displayNameDetail != null) {
            details.add(this.displayNameDetail);
        }
        return details.iterator();
    }

    public Iterator<Class<? extends ServerStoredDetails.GenericDetail>> getSupportedDetailTypes() {
        Vector<Class> result = new Vector<Class>();
        if (this.isImageDetailSupported()) {
            result.add(ServerStoredDetails.ImageDetail.class);
        }
        result.add(ServerStoredDetails.DisplayNameDetail.class);
        return result.iterator();
    }

    public boolean isDetailClassSupported(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        return ServerStoredDetails.ImageDetail.class.isAssignableFrom(detailClass) && this.isImageDetailSupported() || ServerStoredDetails.DisplayNameDetail.class.isAssignableFrom(detailClass);
    }

    public boolean isDetailClassEditable(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        return this.isDetailClassSupported(detailClass) && ServerStoredDetails.ImageDetail.class.isAssignableFrom(detailClass);
    }

    public int getMaxDetailInstances(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        if (ServerStoredDetails.ImageDetail.class.isAssignableFrom(detailClass) && this.isImageDetailSupported()) {
            return 1;
        }
        if (ServerStoredDetails.DisplayNameDetail.class.isAssignableFrom(detailClass)) {
            return 1;
        }
        return 0;
    }

    public void addDetail(ServerStoredDetails.GenericDetail detail) throws IllegalArgumentException, OperationFailedException, ArrayIndexOutOfBoundsException {
        this.addDetail(detail, true);
    }

    public void addDetail(ServerStoredDetails.GenericDetail detail, boolean fireChangeEvents) throws IllegalArgumentException, OperationFailedException, ArrayIndexOutOfBoundsException {
        if (!this.isDetailClassSupported(detail.getClass())) {
            throw new IllegalArgumentException("Implementation does not support such details " + detail.getClass());
        }
        Vector<ServerStoredDetails.GenericDetail> alreadySetDetails = new Vector<ServerStoredDetails.GenericDetail>();
        Iterator<ServerStoredDetails.GenericDetail> iter = this.getDetails(detail.getClass());
        while (iter.hasNext()) {
            alreadySetDetails.add(iter.next());
        }
        if (alreadySetDetails.size() >= this.getMaxDetailInstances(detail.getClass())) {
            throw new ArrayIndexOutOfBoundsException("Max count for this detail is already reached");
        }
        if (ServerStoredDetails.ImageDetail.class.isAssignableFrom(detail.getClass()) && this.isImageDetailSupported()) {
            ServerStoredDetails.ImageDetail imageDetail = (ServerStoredDetails.ImageDetail)detail;
            this.putImageDetail(imageDetail);
            this.accountImage = imageDetail;
            this.isAccountImageLoaded = true;
        } else if (ServerStoredDetails.DisplayNameDetail.class.isAssignableFrom(detail.getClass())) {
            this.displayNameDetail = (ServerStoredDetails.DisplayNameDetail)detail;
        }
        if (fireChangeEvents) {
            this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.provider, 1, null, detail);
        }
    }

    public boolean removeDetail(ServerStoredDetails.GenericDetail detail) throws OperationFailedException {
        return this.removeDetail(detail, true);
    }

    private boolean removeDetail(ServerStoredDetails.GenericDetail detail, boolean fireChangeEvents) throws OperationFailedException {
        boolean isFound = false;
        Iterator<ServerStoredDetails.GenericDetail> iter = this.getAllAvailableDetails();
        while (iter.hasNext()) {
            ServerStoredDetails.GenericDetail item = iter.next();
            if (!item.equals((Object)detail)) continue;
            isFound = true;
        }
        if (!isFound) {
            return false;
        }
        if (ServerStoredDetails.ImageDetail.class.isAssignableFrom(detail.getClass()) && this.isImageDetailSupported()) {
            this.deleteImageDetail();
            this.accountImage = null;
        }
        if (fireChangeEvents) {
            this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.provider, 2, detail, null);
        }
        return true;
    }

    public boolean replaceDetail(ServerStoredDetails.GenericDetail currentDetailValue, ServerStoredDetails.GenericDetail newDetailValue) throws ClassCastException, OperationFailedException {
        if (!newDetailValue.getClass().equals(currentDetailValue.getClass())) {
            throw new ClassCastException("New value to be replaced is not as the current one");
        }
        if (currentDetailValue.equals((Object)newDetailValue)) {
            return true;
        }
        this.removeDetail(currentDetailValue, false);
        this.addDetail(newDetailValue, false);
        this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.provider, 3, currentDetailValue, newDetailValue);
        return true;
    }

    public void save() throws OperationFailedException {
    }

    private boolean isImageDetailSupported() {
        OperationSetPresenceSipImpl opSet = (OperationSetPresenceSipImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        if (opSet == null) {
            return false;
        }
        return opSet.getSsContactList().isAccountImageSupported();
    }

    private ServerStoredDetails.ImageDetail getAccountImage() {
        block3: {
            if (this.isAccountImageLoaded) {
                return this.accountImage;
            }
            this.isAccountImageLoaded = true;
            try {
                this.accountImage = this.getImageDetail();
            }
            catch (OperationFailedException e) {
                if (!logger.isInfoEnabled()) break block3;
                logger.info((Object)"Avatar image cannot be loaded", (Throwable)e);
            }
        }
        return this.accountImage;
    }

    private ServerStoredDetails.ImageDetail getImageDetail() throws OperationFailedException {
        OperationSetPresenceSipImpl opSet = (OperationSetPresenceSipImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        if (opSet == null) {
            return null;
        }
        return opSet.getSsContactList().getAccountImage();
    }

    private void putImageDetail(ServerStoredDetails.ImageDetail imageDetail) throws OperationFailedException {
        OperationSetPresenceSipImpl opSet = (OperationSetPresenceSipImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        if (opSet == null) {
            return;
        }
        opSet.getSsContactList().setAccountImage(imageDetail.getBytes());
    }

    private void deleteImageDetail() throws OperationFailedException {
        OperationSetPresenceSipImpl opSet = (OperationSetPresenceSipImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        if (opSet == null) {
            return;
        }
        opSet.getSsContactList().deleteAccountImage();
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERED) || evt.getNewState().equals((Object)RegistrationState.AUTHENTICATION_FAILED) || evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED)) {
            this.isAccountImageLoaded = false;
            this.accountImage = null;
        }
    }

    void setOurDisplayName(String newDisplayName) {
        ServerStoredDetails.DisplayNameDetail oldDisplayName = this.displayNameDetail;
        ServerStoredDetails.DisplayNameDetail newDisplayNameDetail = new ServerStoredDetails.DisplayNameDetail(newDisplayName);
        Vector<ServerStoredDetails.GenericDetail> alreadySetDetails = new Vector<ServerStoredDetails.GenericDetail>();
        Iterator<ServerStoredDetails.GenericDetail> iter = this.getDetails(newDisplayNameDetail.getClass());
        while (iter.hasNext()) {
            alreadySetDetails.add(iter.next());
        }
        try {
            if (alreadySetDetails.size() > 0) {
                this.replaceDetail((ServerStoredDetails.GenericDetail)oldDisplayName, (ServerStoredDetails.GenericDetail)newDisplayNameDetail);
            } else {
                this.addDetail((ServerStoredDetails.GenericDetail)newDisplayNameDetail);
            }
        }
        catch (OperationFailedException e) {
            logger.error((Object)"Filed to set display name", (Throwable)e);
        }
    }

    void shutdown() {
        this.provider.removeRegistrationStateChangeListener(this);
    }
}

