/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.header.HeaderFactoryImpl;
import java.text.ParseException;
import javax.sip.Dialog;
import javax.sip.address.Address;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.message.Request;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyPark;
import net.java.sip.communicator.util.Logger;

public class OperationSetTelephonyParkSipImpl
implements OperationSetTelephonyPark {
    private static final Logger logger = Logger.getLogger(OperationSetTelephonyParkSipImpl.class);
    private final ProtocolProviderServiceSipImpl protocolProvider;

    OperationSetTelephonyParkSipImpl(ProtocolProviderServiceSipImpl provider) {
        this.protocolProvider = provider;
    }

    public void parkCall(String parkSlot, CallPeer peer) throws OperationFailedException {
        CallPeerSipImpl sipPeer = (CallPeerSipImpl)peer;
        Dialog dialog = sipPeer.getDialog();
        Request refer = this.protocolProvider.getMessageFactory().createRequest(dialog, "REFER");
        HeaderFactory headerFactory = this.protocolProvider.getHeaderFactory();
        String addressString = parkSlot;
        String callParkPrefix = this.protocolProvider.getAccountID().getAccountPropertyString((Object)"CALL_PARK_PREFIX_PROPERTY", null);
        if (callParkPrefix != null) {
            addressString = callParkPrefix + addressString;
        }
        Address address = null;
        try {
            address = this.protocolProvider.parseAddressString(addressString);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to parse address string " + addressString, 11, ex, logger);
        }
        refer.setHeader((Header)headerFactory.createReferToHeader(address));
        refer.addHeader((Header)((HeaderFactoryImpl)headerFactory).createReferredByHeader(dialog.getLocalParty()));
        this.protocolProvider.sendInDialogRequest(sipPeer.getJainSipProvider(), refer, dialog);
    }
}

