/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import net.java.sip.communicator.impl.protocol.sip.SipAccountIDImpl;
import net.java.sip.communicator.impl.protocol.sip.net.ProxyConnection;
import net.java.sip.communicator.service.dns.DnssecException;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.SRVRecord;

public class AutoProxyConnection
extends ProxyConnection {
    private static final Logger logger = Logger.getLogger(AutoProxyConnection.class);
    private State state;
    private String address;
    private int port;
    private final String defaultTransport;
    private LocalNetworkUtils nu = new LocalNetworkUtils();
    private static final String[] transports = new String[]{"TLS", "TCP", "UDP"};
    private boolean hadSrvResults;
    private String[][] naptrRecords;
    private int naptrIndex;
    private SRVRecord[] srvRecords;
    private int srvRecordsIndex;
    private int srvTransportIndex;
    private InetSocketAddress[] socketAddresses;
    private int socketAddressIndex;

    public AutoProxyConnection(SipAccountIDImpl account, String defaultTransport) {
        super(account);
        this.port = 5060;
        this.defaultTransport = defaultTransport;
        this.reset();
    }

    public AutoProxyConnection(SipAccountIDImpl account, String address, int port, String defaultTransport) {
        super(account);
        this.defaultTransport = defaultTransport;
        this.port = port;
        this.reset();
        this.address = address;
        if (this.nu.isValidIPAddress(this.address)) {
            this.state = State.IP;
        }
    }

    protected void setNetworkUtils(LocalNetworkUtils nu) {
        this.nu = nu;
    }

    @Override
    protected boolean getNextAddressFromDns() throws DnssecException {
        try {
            return this.getNextAddressInternal();
        }
        catch (ParseException ex) {
            logger.error((Object)("Unable to get DNS data for <" + this.address + "> in state" + (Object)((Object)this.state)), (Throwable)ex);
            return false;
        }
    }

    private boolean getNextAddressInternal() throws DnssecException, ParseException {
        switch (this.state) {
            case New: {
                this.state = State.Naptr;
                return this.getNextAddressFromDns();
            }
            case IP: {
                if (this.socketAddressIndex == 0) {
                    ++this.socketAddressIndex;
                    try {
                        this.socketAddress = new InetSocketAddress(this.nu.getInetAddress(this.address), "TLS".equalsIgnoreCase(this.transport) ? 5061 : 5060);
                    }
                    catch (UnknownHostException e) {
                        logger.error((Object)("invalid IP address: " + this.address), (Throwable)e);
                        return false;
                    }
                    this.transport = this.defaultTransport;
                    return true;
                }
                return false;
            }
            case Naptr: {
                this.naptrRecords = this.nu.getNAPTRRecords(this.address);
                if (this.naptrRecords != null && this.naptrRecords.length > 0) {
                    this.state = State.NaptrSrv;
                    this.naptrIndex = 0;
                } else {
                    this.hadSrvResults = false;
                    this.state = State.Srv;
                    this.srvTransportIndex = 0;
                }
                return this.getNextAddressFromDns();
            }
            case NaptrSrv: {
                while (this.naptrIndex < this.naptrRecords.length) {
                    this.srvRecords = this.nu.getSRVRecords(this.naptrRecords[this.naptrIndex][2]);
                    if (this.srvRecords != null && this.srvRecords.length > 0) {
                        this.state = State.NaptrSrvHosts;
                        this.transport = "TLS".equalsIgnoreCase(this.naptrRecords[this.naptrIndex][1]) ? "TLS" : ("TCP".equalsIgnoreCase(this.naptrRecords[this.naptrIndex][1]) ? "TCP" : "UDP");
                        this.srvRecordsIndex = 0;
                        if (this.getNextAddressFromDns()) {
                            ++this.naptrIndex;
                            return true;
                        }
                    }
                    ++this.naptrIndex;
                }
                return false;
            }
            case NaptrSrvHosts: {
                while (this.srvRecordsIndex < this.srvRecords.length) {
                    this.socketAddresses = this.nu.getAandAAAARecords(this.srvRecords[this.srvRecordsIndex].getTarget(), this.srvRecords[this.srvRecordsIndex].getPort());
                    if (this.socketAddresses != null && this.socketAddresses.length > 0) {
                        this.state = State.NaptrSrvHostIPs;
                        this.socketAddressIndex = 0;
                        if (this.getNextAddressFromDns()) {
                            ++this.srvRecordsIndex;
                            return true;
                        }
                    }
                    ++this.srvRecordsIndex;
                }
                this.state = State.NaptrSrv;
                return this.getNextAddressFromDns();
            }
            case NaptrSrvHostIPs: {
                if (this.socketAddressIndex >= this.socketAddresses.length) {
                    this.state = State.NaptrSrvHosts;
                    return this.getNextAddressFromDns();
                }
                this.socketAddress = this.socketAddresses[this.socketAddressIndex];
                ++this.socketAddressIndex;
                return true;
            }
            case Srv: {
                while (this.srvTransportIndex < transports.length) {
                    this.srvRecords = this.nu.getSRVRecords("TLS".equals(transports[this.srvTransportIndex]) ? "sips" : "sip", "UDP".equalsIgnoreCase(transports[this.srvTransportIndex]) ? "UDP" : "TCP", this.address);
                    if (this.srvRecords != null && this.srvRecords.length > 0) {
                        this.hadSrvResults = true;
                        this.state = State.SrvHosts;
                        this.srvRecordsIndex = 0;
                        this.transport = transports[this.srvTransportIndex];
                        if (this.getNextAddressFromDns()) {
                            ++this.srvTransportIndex;
                            return true;
                        }
                    }
                    ++this.srvTransportIndex;
                }
                if (!this.hadSrvResults) {
                    this.state = State.Hosts;
                    this.socketAddressIndex = 0;
                    return this.getNextAddressFromDns();
                }
                return false;
            }
            case SrvHosts: {
                if (this.srvRecordsIndex >= this.srvRecords.length) {
                    this.state = State.Srv;
                    return this.getNextAddressFromDns();
                }
                while (this.srvRecordsIndex < this.srvRecords.length) {
                    this.socketAddresses = this.nu.getAandAAAARecords(this.srvRecords[this.srvRecordsIndex].getTarget(), this.srvRecords[this.srvRecordsIndex].getPort());
                    if (this.socketAddresses != null && this.socketAddresses.length > 0) {
                        this.state = State.SrvHostIPs;
                        this.socketAddressIndex = 0;
                        if (this.getNextAddressFromDns()) {
                            ++this.srvRecordsIndex;
                            return true;
                        }
                    }
                    ++this.srvRecordsIndex;
                }
                return false;
            }
            case SrvHostIPs: {
                if (this.socketAddressIndex >= this.socketAddresses.length) {
                    this.state = State.SrvHosts;
                    return this.getNextAddressFromDns();
                }
                this.socketAddress = this.socketAddresses[this.socketAddressIndex];
                ++this.socketAddressIndex;
                return true;
            }
            case Hosts: {
                this.transport = this.defaultTransport;
                if (this.socketAddresses == null) {
                    this.socketAddresses = this.nu.getAandAAAARecords(this.address, this.port);
                }
                if (this.socketAddresses != null && this.socketAddresses.length > 0 && this.socketAddressIndex < this.socketAddresses.length) {
                    this.socketAddress = this.socketAddresses[this.socketAddressIndex++];
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.state = State.New;
        String userID = this.account.getAccountPropertyString("USER_ID");
        int domainIx = userID.indexOf("@");
        if (domainIx > 0) {
            this.address = userID.substring(domainIx + 1);
        } else {
            this.address = this.account.getAccountPropertyString("SERVER_ADDRESS");
            if (this.address == null || this.address.trim().length() == 0) {
                return;
            }
        }
        if (this.nu.isValidIPAddress(this.address)) {
            this.state = State.IP;
            this.socketAddressIndex = 0;
        }
    }

    protected static class LocalNetworkUtils {
        protected LocalNetworkUtils() {
        }

        public InetAddress getInetAddress(String address) throws UnknownHostException {
            return NetworkUtils.getInetAddress((String)address);
        }

        public String[][] getNAPTRRecords(String address) throws ParseException, DnssecException {
            return NetworkUtils.getNAPTRRecords((String)address);
        }

        public SRVRecord[] getSRVRecords(String service, String proto, String address) throws ParseException, DnssecException {
            return NetworkUtils.getSRVRecords((String)service, (String)proto, (String)address);
        }

        public InetSocketAddress[] getAandAAAARecords(String target, int port) throws ParseException, DnssecException {
            return NetworkUtils.getAandAAAARecords((String)target, (int)port);
        }

        public boolean isValidIPAddress(String address) {
            return NetworkUtils.isValidIPAddress((String)address);
        }

        public SRVRecord[] getSRVRecords(String domain) throws ParseException, DnssecException {
            return NetworkUtils.getSRVRecords((String)domain);
        }
    }

    private static enum State {
        New,
        Naptr,
        NaptrSrv,
        NaptrSrvHosts,
        NaptrSrvHostIPs,
        Srv,
        SrvHosts,
        SrvHostIPs,
        Hosts,
        IP;

    }
}

