/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.util.HashMap;
import org.jitsi.impl.neomedia.codec.EncodingConfigurationImpl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.format.MediaFormat;

public class EncodingConfigurationConfigImpl
extends EncodingConfigurationImpl {
    private final String propPrefix;
    private final ConfigurationService cfg = LibJitsi.getConfigurationService();

    public EncodingConfigurationConfigImpl(String prefix) {
        this.propPrefix = prefix;
        this.loadConfig();
    }

    private void loadConfig() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String pName : this.cfg.getPropertyNamesByPrefix(this.propPrefix, false)) {
            properties.put(pName, this.cfg.getString(pName));
        }
        this.loadProperties(properties);
    }

    @Override
    public void setPriority(MediaFormat encoding, int priority) {
        super.setPriority(encoding, priority);
        this.cfg.setProperty(this.propPrefix + "." + this.getEncodingPreferenceKey(encoding), priority);
    }
}

