/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OverUseDetectorOptions;

class OveruseDetector {
    private static final double kMaxAdaptOffsetMs = 15.0;
    private static final int kOverUsingTimeThreshold = 100;
    private BandwidthUsage hypothesis = BandwidthUsage.kBwNormal;
    private final boolean inExperiment = false;
    private double kDown = 1.8E-4;
    private double kUp = 0.01;
    private long lastUpdateMs = -1L;
    private int overuseCounter;
    private double overusingTimeThreshold = 100.0;
    private double prevOffset;
    private double threshold = 12.5;
    private double timeOverUsing = -1.0;

    public OveruseDetector(OverUseDetectorOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.threshold = options.initialThreshold;
    }

    public BandwidthUsage detect(double offset, double tsDelta, int numOfDeltas, long nowMs) {
        if (numOfDeltas < 2) {
            return BandwidthUsage.kBwNormal;
        }
        double prev_offset = this.prevOffset;
        this.prevOffset = offset;
        double T = (double)Math.min(numOfDeltas, 60) * offset;
        if (T > this.threshold) {
            this.timeOverUsing = this.timeOverUsing == -1.0 ? tsDelta / 2.0 : (this.timeOverUsing += tsDelta);
            ++this.overuseCounter;
            if (this.timeOverUsing > this.overusingTimeThreshold && this.overuseCounter > 1 && offset >= prev_offset) {
                this.timeOverUsing = 0.0;
                this.overuseCounter = 0;
                this.hypothesis = BandwidthUsage.kBwOverusing;
            }
        } else if (T < -this.threshold) {
            this.timeOverUsing = -1.0;
            this.overuseCounter = 0;
            this.hypothesis = BandwidthUsage.kBwUnderusing;
        } else {
            this.timeOverUsing = -1.0;
            this.overuseCounter = 0;
            this.hypothesis = BandwidthUsage.kBwNormal;
        }
        this.updateThreshold(T, nowMs);
        return this.hypothesis;
    }

    public BandwidthUsage getState() {
        return this.hypothesis;
    }

    private void initializeExperiment() {
        double kUp = 0.0;
        double kDown = 0.0;
        this.overusingTimeThreshold = 100.0;
        this.kUp = kUp;
        this.kDown = kDown;
    }

    private void updateThreshold(double modifiedOffset, long nowMs) {
    }
}

