/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jitsi.impl.neomedia.RTCPFeedbackMessagePacket;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.rtp.translator.StreamRTPManagerDesc;
import org.jitsi.util.Logger;
import org.jitsi.util.concurrent.PeriodicRunnable;
import org.jitsi.util.concurrent.RecurringRunnableExecutor;

public class RTCPFeedbackMessageSender {
    private static final Logger logger = Logger.getLogger(RTCPFeedbackMessageSender.class);
    private static final boolean TRACE = logger.isTraceEnabled();
    private static final int FIR_RETRY_INTERVAL_MS = 300;
    private static final int FIR_MAX_RETRIES = 10;
    private final RTPTranslatorImpl rtpTranslator;
    private final RecurringRunnableExecutor recurringRunnableExecutor = new RecurringRunnableExecutor(RTCPFeedbackMessageSender.class.getSimpleName());
    private final ConcurrentMap<Integer, KeyframeRequester> kfRequesters = new ConcurrentHashMap<Integer, KeyframeRequester>();

    public RTCPFeedbackMessageSender(RTPTranslatorImpl rtpTranslator) {
        this.rtpTranslator = rtpTranslator;
    }

    private long getSenderSSRC() {
        long ssrc = this.rtpTranslator.getLocalSSRC(null);
        return ssrc == Long.MAX_VALUE ? -1L : ssrc & 0xFFFFFFFFL;
    }

    public boolean sendFIR(int mediaSenderSSRC) {
        boolean registerRecurringRunnable = false;
        KeyframeRequester keyframeRequester = (KeyframeRequester)this.kfRequesters.get(mediaSenderSSRC);
        if (keyframeRequester == null) {
            keyframeRequester = new KeyframeRequester(mediaSenderSSRC);
            KeyframeRequester existingKfRequester = this.kfRequesters.putIfAbsent(mediaSenderSSRC, keyframeRequester);
            if (existingKfRequester != null) {
                keyframeRequester = existingKfRequester;
            } else {
                registerRecurringRunnable = true;
            }
        }
        if (registerRecurringRunnable) {
            this.recurringRunnableExecutor.registerRecurringRunnable(keyframeRequester);
        }
        return keyframeRequester.maybeRequest(true);
    }

    public boolean sendFIR(int[] mediaSenderSSRCs) {
        if (mediaSenderSSRCs == null || mediaSenderSSRCs.length == 0) {
            return false;
        }
        boolean sentFIR = false;
        for (int mediaSenderSSRC : mediaSenderSSRCs) {
            if (!this.sendFIR(mediaSenderSSRC)) continue;
            sentFIR = true;
        }
        return sentFIR;
    }

    public void maybeStopRequesting(StreamRTPManagerDesc streamRTPManager, int ssrc, byte[] buf, int off, int len) {
        KeyframeRequester kfRequester = (KeyframeRequester)this.kfRequesters.get(ssrc);
        if (kfRequester != null) {
            kfRequester.maybeStopRequesting(streamRTPManager, buf, off, len);
        }
    }

    void dispose() {
        this.recurringRunnableExecutor.close();
    }

    class KeyframeRequester
    extends PeriodicRunnable {
        private final int mediaSenderSSRC;
        private final AtomicInteger sequenceNumber;
        private int remainingRetries;

        public KeyframeRequester(int mediaSenderSSRC) {
            super(300L);
            this.sequenceNumber = new AtomicInteger(0);
            this.mediaSenderSSRC = mediaSenderSSRC;
            this.remainingRetries = 0;
        }

        @Override
        public void run() {
            super.run();
            this.maybeRequest(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void maybeStopRequesting(StreamRTPManagerDesc streamRTPManager, byte[] buf, int off, int len) {
            if (this.remainingRetries == 0) {
                return;
            }
            if (!streamRTPManager.streamRTPManager.getMediaStream().isKeyFrame(buf, off, len)) {
                return;
            }
            if (TRACE) {
                logger.trace("Stopping FIRs to ssrc=" + ((long)this.mediaSenderSSRC & 0xFFFFFFFFL));
            }
            KeyframeRequester keyframeRequester = this;
            synchronized (keyframeRequester) {
                this.remainingRetries = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean maybeRequest(boolean allowResetRemainingRetries) {
            KeyframeRequester keyframeRequester = this;
            synchronized (keyframeRequester) {
                block10: {
                    if (allowResetRemainingRetries) {
                        if (this.remainingRetries == 0) {
                            if (TRACE) {
                                logger.trace("Starting FIRs to ssrc=" + ((long)this.mediaSenderSSRC & 0xFFFFFFFFL));
                            }
                            this.remainingRetries = 10;
                            break block10;
                        } else {
                            if (TRACE) {
                                logger.trace("Pending FIRs to ssrc=" + ((long)this.mediaSenderSSRC & 0xFFFFFFFFL));
                            }
                            return true;
                        }
                    }
                    if (this.remainingRetries == 0) {
                        return false;
                    }
                }
                --this.remainingRetries;
                logger.info("Sending a FIR to ssrc=" + ((long)this.mediaSenderSSRC & 0xFFFFFFFFL) + " remainingRetries=" + this.remainingRetries);
            }
            long senderSSRC = RTCPFeedbackMessageSender.this.getSenderSSRC();
            if (senderSSRC == -1L) {
                logger.warn("Not sending an FIR because the sender SSRC is -1.");
                return false;
            }
            StreamRTPManager streamRTPManager = RTCPFeedbackMessageSender.this.rtpTranslator.findStreamRTPManagerByReceiveSSRC(this.mediaSenderSSRC);
            if (streamRTPManager == null) {
                logger.warn("Not sending an FIR because the stream RTP manager is null.");
                return false;
            }
            RTCPFeedbackMessagePacket fir = new RTCPFeedbackMessagePacket(4, -50, senderSSRC, 0xFFFFFFFFL & (long)this.mediaSenderSSRC);
            fir.setSequenceNumber(this.sequenceNumber.incrementAndGet());
            return RTCPFeedbackMessageSender.this.rtpTranslator.writeControlPayload(fir, streamRTPManager.getMediaStream());
        }
    }
}

