/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.Properties;
import org.jitsi.service.neomedia.SrtpControl;

public class DtlsTransformEngine
implements SrtpControl.TransformEngine {
    private boolean disposed = false;
    private final DtlsControlImpl dtlsControl;
    private final DtlsPacketTransformer[] packetTransformers = new DtlsPacketTransformer[2];

    public DtlsTransformEngine(DtlsControlImpl dtlsControl) {
        this.dtlsControl = dtlsControl;
    }

    @Override
    public void cleanup() {
        this.disposed = true;
        for (int i = 0; i < this.packetTransformers.length; ++i) {
            DtlsPacketTransformer packetTransformer = this.packetTransformers[i];
            if (packetTransformer == null) continue;
            packetTransformer.close();
            this.packetTransformers[i] = null;
        }
    }

    protected DtlsPacketTransformer createPacketTransformer(int componentID) {
        return new DtlsPacketTransformer(this, componentID);
    }

    DtlsControlImpl getDtlsControl() {
        return this.dtlsControl;
    }

    private DtlsPacketTransformer getPacketTransformer(int componentID) {
        int index = componentID - 1;
        DtlsPacketTransformer packetTransformer = this.packetTransformers[index];
        if (packetTransformer == null && !this.disposed && (packetTransformer = this.createPacketTransformer(componentID)) != null) {
            this.packetTransformers[index] = packetTransformer;
        }
        return packetTransformer;
    }

    Properties getProperties() {
        return this.getDtlsControl().getProperties();
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this.getPacketTransformer(2);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this.getPacketTransformer(1);
    }
}

