/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.libjitsi;

import java.lang.reflect.Constructor;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.Logger;

public abstract class LibJitsi {
    private static final Logger logger = Logger.getLogger(LibJitsi.class);
    private static LibJitsi impl;

    public static AudioNotifierService getAudioNotifierService() {
        return LibJitsi.invokeGetServiceOnImpl(AudioNotifierService.class);
    }

    public static ConfigurationService getConfigurationService() {
        return LibJitsi.invokeGetServiceOnImpl(ConfigurationService.class);
    }

    public static FileAccessService getFileAccessService() {
        return LibJitsi.invokeGetServiceOnImpl(FileAccessService.class);
    }

    public static MediaService getMediaService() {
        return LibJitsi.invokeGetServiceOnImpl(MediaService.class);
    }

    public static PacketLoggingService getPacketLoggingService() {
        return LibJitsi.invokeGetServiceOnImpl(PacketLoggingService.class);
    }

    public static ResourceManagementService getResourceManagementService() {
        return LibJitsi.invokeGetServiceOnImpl(ResourceManagementService.class);
    }

    private static <T> T invokeGetServiceOnImpl(Class<T> serviceClass) {
        LibJitsi impl = LibJitsi.impl;
        if (impl == null) {
            throw new IllegalStateException("impl");
        }
        return impl.getService(serviceClass);
    }

    public static void start() {
        LibJitsi.start(null);
    }

    static void start(Object context) {
        if (null != impl) {
            if (logger.isInfoEnabled()) {
                logger.info("LibJitsi already started, using as implementation: " + impl.getClass().getCanonicalName());
            }
            return;
        }
        String implBaseClassName = LibJitsi.class.getName().replace(".service.", ".impl.");
        String[] implClassNameExtensions = new String[]{"OSGi", ""};
        Object impl = null;
        for (int i = 0; i < implClassNameExtensions.length; ++i) {
            Class<?> implClass = null;
            String implClassName = implBaseClassName + implClassNameExtensions[i] + "Impl";
            Throwable exception = null;
            try {
                implClass = Class.forName(implClassName);
            }
            catch (ClassNotFoundException cnfe) {
                exception = cnfe;
            }
            catch (ExceptionInInitializerError eiie) {
                exception = eiie;
            }
            catch (LinkageError le) {
                exception = le;
            }
            if (implClass != null && LibJitsi.class.isAssignableFrom(implClass)) {
                try {
                    if (context == null) {
                        impl = (LibJitsi)implClass.newInstance();
                    } else {
                        Constructor<?> constructor = null;
                        for (Constructor<?> aConstructor : implClass.getConstructors()) {
                            Class<?>[] parameterTypes = aConstructor.getParameterTypes();
                            if (parameterTypes.length != 1 || !parameterTypes[0].isInstance(context)) continue;
                            constructor = aConstructor;
                            break;
                        }
                        impl = (LibJitsi)constructor.newInstance(context);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    exception = t;
                }
                if (impl != null) break;
            }
            if (exception == null || !logger.isInfoEnabled()) continue;
            StringBuilder message = new StringBuilder();
            message.append("Failed to initialize LibJitsi backend ");
            message.append(implClassName);
            message.append(". (Exception stack trace follows.)");
            if (i < implClassNameExtensions.length - 1) {
                message.append(" Will try an alternative.");
            }
            logger.info(message, exception);
        }
        if (impl == null) {
            throw new IllegalStateException("impl");
        }
        LibJitsi.impl = impl;
        if (logger.isInfoEnabled()) {
            logger.info("Successfully started LibJitsi using as implementation: " + impl.getClass().getCanonicalName());
        }
    }

    public static void stop() {
        impl = null;
    }

    protected LibJitsi() {
    }

    protected abstract <T> T getService(Class<T> var1);
}

