/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SipSlickFixture
extends TestCase {
    public static BundleContext bc = null;
    public ServiceReference provider1ServiceRef = null;
    public ProtocolProviderService provider1 = null;
    public String userID1 = null;
    public ServiceReference provider2ServiceRef = null;
    public ProtocolProviderService provider2 = null;
    public String userID2 = null;
    public ProtocolProviderFactory providerFactory = null;
    public static boolean onlineTestingDisabled = false;
    public static Bundle providerBundle = null;
    public static Hashtable<String, List<String>> preInstalledBuddyList = null;

    public void setUp() throws Exception {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=SIP)";
        try {
            serRefs = bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            SipSlickFixture.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        SipSlickFixture.assertTrue((String)"Failed to find a provider factory service for protocol SIP", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        this.providerFactory = (ProtocolProviderFactory)bc.getService(serRefs[0]);
        this.userID1 = System.getProperty("accounts.sip.account1.USER_ID");
        this.userID2 = System.getProperty("accounts.sip.account2.USER_ID");
        ServiceReference[] sipProvider1Refs = bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=SIP)(USER_ID=" + this.userID1 + "))");
        SipSlickFixture.assertNotNull((String)("No Protocol Provider was found for SIP account1:" + this.userID1), (Object)sipProvider1Refs);
        SipSlickFixture.assertTrue((String)("No Protocol Provider was found for SIP account1:" + this.userID1), (sipProvider1Refs.length > 0 ? 1 : 0) != 0);
        ServiceReference[] sipProvider2Refs = bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=SIP)(USER_ID=" + this.userID2 + "))");
        SipSlickFixture.assertNotNull((String)("No Protocol Provider was found for SIP account2:" + this.userID2), (Object)sipProvider2Refs);
        SipSlickFixture.assertTrue((String)("No Protocol Provider was found for SIP account2:" + this.userID2), (sipProvider2Refs.length > 0 ? 1 : 0) != 0);
        this.provider1ServiceRef = sipProvider1Refs[0];
        this.provider1 = (ProtocolProviderService)bc.getService(this.provider1ServiceRef);
        this.provider2ServiceRef = sipProvider2Refs[0];
        this.provider2 = (ProtocolProviderService)bc.getService(this.provider2ServiceRef);
    }

    public void tearDown() {
        bc.ungetService(this.provider1ServiceRef);
        bc.ungetService(this.provider2ServiceRef);
    }

    public static Bundle findProtocolProviderBundle(ProtocolProviderService provider) {
        Bundle[] bundles = bc.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            ServiceReference[] registeredServices = bundles[i].getRegisteredServices();
            if (registeredServices == null) continue;
            for (int j = 0; j < registeredServices.length; ++j) {
                Object service = bc.getService(registeredServices[j]);
                if (service != provider) continue;
                return bundles[i];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProvidersLists() throws Exception {
        Object object;
        Object object2;
        Map supportedOperationSets1 = this.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this Sip implementation. ");
        }
        OperationSetPersistentPresence opSetPersPresence1 = (OperationSetPersistentPresence)supportedOperationSets1.get(OperationSetPersistentPresence.class.getName());
        if (opSetPersPresence1 == null) {
            throw new NullPointerException("An implementation of the Sip service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        Map supportedOperationSets2 = this.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this Jabber implementation. ");
        }
        OperationSetPersistentPresence opSetPersPresence2 = (OperationSetPersistentPresence)supportedOperationSets2.get(OperationSetPersistentPresence.class.getName());
        if (opSetPersPresence2 == null) {
            throw new NullPointerException("An implementation of the Sip service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        ContactGroup rootGroup1 = opSetPersPresence1.getServerStoredContactListRoot();
        Object lock = new Object();
        Iterator cgiter = rootGroup1.subgroups();
        while (cgiter.hasNext()) {
            ContactGroup item = (ContactGroup)cgiter.next();
            opSetPersPresence1.removeServerStoredContactGroup(item);
            object2 = lock;
            synchronized (object2) {
                lock.wait(1000L);
            }
            cgiter = rootGroup1.subgroups();
        }
        Iterator citer = rootGroup1.contacts();
        while (citer.hasNext()) {
            opSetPersPresence1.unsubscribe((Contact)citer.next());
            object2 = lock;
            synchronized (object2) {
                lock.wait(1000L);
            }
            citer = rootGroup1.contacts();
        }
        ContactGroup rootGroup2 = opSetPersPresence2.getServerStoredContactListRoot();
        cgiter = rootGroup2.subgroups();
        while (cgiter.hasNext()) {
            ContactGroup item = (ContactGroup)cgiter.next();
            Object object3 = lock;
            synchronized (object3) {
                lock.wait(1000L);
            }
            opSetPersPresence2.removeServerStoredContactGroup(item);
        }
        citer = rootGroup2.contacts();
        while (citer.hasNext()) {
            opSetPersPresence2.unsubscribe((Contact)citer.next());
            object = lock;
            synchronized (object) {
                lock.wait(1000L);
            }
            citer = rootGroup2.contacts();
        }
        object = lock;
        synchronized (object) {
            lock.wait(5000L);
        }
    }
}

