/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.util.Hashtable;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestAccountInstallation
extends TestCase {
    public TestAccountInstallation(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInstallAccount() {
        ((ConfigurationService)ServiceUtils.getService((BundleContext)SipSlickFixture.bc, ConfigurationService.class)).setProperty("net.java.sip.communicator.service.gui.ALWAYS_TRUST_MODE_ENABLED", (Object)true);
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=SIP)";
        try {
            serRefs = SipSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestAccountInstallation.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        TestAccountInstallation.assertTrue((String)"Failed to find a provider factory service for protocol SIP", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        ProtocolProviderFactory sipProviderFactory = (ProtocolProviderFactory)SipSlickFixture.bc.getService(serRefs[0]);
        TestAccountInstallation.assertTrue((String)"There was an account registered with the account mananger before we've installed any", (sipProviderFactory.getRegisteredAccounts().size() == 0 ? 1 : 0) != 0);
        Hashtable<String, String> sipAccount1Properties = this.getAccountProperties("accounts.sip.account1.");
        Hashtable<String, String> sipAccount2Properties = this.getAccountProperties("accounts.sip.account2.");
        try {
            sipProviderFactory.installAccount(null, sipAccount1Properties);
            TestAccountInstallation.fail((String)"installing an account with a null account id must result in a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        sipProviderFactory.installAccount(sipAccount1Properties.get("USER_ID"), sipAccount1Properties);
        sipProviderFactory.installAccount(sipAccount2Properties.get("USER_ID"), sipAccount2Properties);
        try {
            sipProviderFactory.installAccount(sipAccount1Properties.get("USER_ID"), sipAccount1Properties);
            TestAccountInstallation.fail((String)"An IllegalStateException must be thrown when trying to install a duplicate account");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestAccountInstallation.assertTrue((String)"The newly installed account was not in the acc man's registered accounts!", (sipProviderFactory.getRegisteredAccounts().size() == 2 ? 1 : 0) != 0);
        osgiFilter = "(&(PROTOCOL_NAME=SIP)(USER_ID=" + sipAccount1Properties.get("USER_ID") + "))";
        try {
            serRefs = SipSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestAccountInstallation.fail((String)(osgiFilter + "is not a valid osgi filter"));
        }
        TestAccountInstallation.assertTrue((String)"A SIP protocol provider was apparently not installed as requested.", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        Object icqProtocolProvider = SipSlickFixture.bc.getService(serRefs[0]);
        TestAccountInstallation.assertTrue((String)"The installed protocol provider does not implement the protocol provider service.", (boolean)(icqProtocolProvider instanceof ProtocolProviderService));
    }

    private Hashtable<String, String> getAccountProperties(String accountPrefix) {
        String xCapServerUri;
        Hashtable<String, String> table = new Hashtable<String, String>();
        String userID = System.getProperty(accountPrefix + "USER_ID", null);
        TestAccountInstallation.assertNotNull((String)("The system property named " + accountPrefix + "USER_ID" + " has to tontain a valid SIP address that could be used during SIP Communicator's tests."), (Object)userID);
        table.put("USER_ID", userID);
        String displayName = System.getProperty(accountPrefix + "DISPLAY_NAME", null);
        TestAccountInstallation.assertNotNull((String)("The system property named " + accountPrefix + "DISPLAY_NAME" + " has to contain a valid name string that could be used during SIP Communicator's tests."), (Object)displayName);
        table.put("DISPLAY_NAME", displayName);
        String passwd = System.getProperty(accountPrefix + "PASSWORD", null);
        TestAccountInstallation.assertNotNull((String)("The system property named " + accountPrefix + "PASSWORD" + " has to contain the password corresponding to the account specified in " + accountPrefix + "USER_ID"), (Object)passwd);
        table.put("PASSWORD", passwd);
        String serverAddress = System.getProperty(accountPrefix + "SERVER_ADDRESS", null);
        TestAccountInstallation.assertNotNull((String)("The system property named " + accountPrefix + "SERVER_ADDRESS" + " has to contain a valid server address to use for testing."), (Object)serverAddress);
        table.put("SERVER_ADDRESS", serverAddress);
        String serverPort = System.getProperty(accountPrefix + "SERVER_PORT", null);
        if (serverPort != null) {
            table.put("SERVER_PORT", serverPort);
        }
        String proxyAddress = System.getProperty(accountPrefix + "PROXY_ADDRESS", null);
        if (serverPort != null) {
            table.put("PROXY_ADDRESS", proxyAddress);
            String proxyPort = System.getProperty(accountPrefix + "PROXY_PORT", null);
            if (proxyPort != null) {
                table.put("PROXY_PORT", proxyPort);
            }
        }
        if ((xCapServerUri = System.getProperty(accountPrefix + "OPT_CLIST_SERVER_URI", null)) != null) {
            table.put("XCAP_ENABLE", Boolean.TRUE.toString());
            table.put("OPT_CLIST_USE_SIP_CREDETIALS", Boolean.TRUE.toString());
            table.put("OPT_CLIST_USER", Boolean.TRUE.toString());
            table.put("OPT_CLIST_SERVER_URI", xCapServerUri);
        }
        table.put("FORCE_P2P_MODE", Boolean.FALSE.toString());
        return table;
    }
}

