/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetPresence
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetPresence.class);
    private SipSlickFixture fixture = new SipSlickFixture();
    private OperationSetPresence operationSetPresence1 = null;
    private OperationSetPresence operationSetPresence2 = null;
    private String statusMessageRoot = new String("Our status is now: ");

    public TestOperationSetPresence(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.operationSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (this.operationSetPresence1 == null) {
            throw new NullPointerException("An implementation of the Jabber service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this SIP implementation. ");
        }
        this.operationSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (this.operationSetPresence2 == null) {
            throw new NullPointerException("An implementation of the SIP service must provide an implementation of at least the one of the Presence Operation Sets");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        if (SipSlickFixture.onlineTestingDisabled) {
            TestSuite suite = new TestSuite();
            return suite;
        }
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetPresence("clearLists"));
        suite.addTest((Test)new TestOperationSetPresence("postTestSubscribe"));
        suite.addTestSuite(TestOperationSetPresence.class);
        suite.addTest((Test)new TestOperationSetPresence("postTestUnsubscribe"));
        return suite;
    }

    public void testChangingState() throws Exception {
        Iterator supportedStatusSetIter = this.operationSetPresence1.getSupportedStatusSet();
        while (supportedStatusSetIter.hasNext()) {
            PresenceStatus supportedStatus = (PresenceStatus)supportedStatusSetIter.next();
            logger.trace((Object)("Will test a transition to " + supportedStatus.getStatusName()));
            this.subtestStateTransition(supportedStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtestStateTransition(PresenceStatus newStatus) throws Exception {
        Object lock;
        logger.trace((Object)" --=== beginning state transition test ===--");
        PresenceStatus oldStatus = this.operationSetPresence2.getPresenceStatus();
        String oldStatusMessage = this.operationSetPresence2.getCurrentStatusMessage();
        String newStatusMessage = this.statusMessageRoot + newStatus;
        logger.debug((Object)("old status is=" + oldStatus.getStatusName() + " new status=" + newStatus.getStatusName()));
        PresenceStatusEventCollector statusEventCollector = new PresenceStatusEventCollector();
        this.operationSetPresence2.addProviderPresenceStatusListener((ProviderPresenceStatusListener)statusEventCollector);
        this.operationSetPresence2.publishPresenceStatus(newStatus, newStatusMessage);
        this.pauseAfterStateChanges();
        statusEventCollector.waitForPresEvent(10000L);
        statusEventCollector.waitForStatMsgEvent(10000L);
        this.operationSetPresence2.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)statusEventCollector);
        TestOperationSetPresence.assertEquals((String)"Events dispatched during an event transition.", (int)1, (int)statusEventCollector.collectedPresEvents.size());
        TestOperationSetPresence.assertEquals((String)"A status changed event contained wrong old status.", (Object)oldStatus, (Object)((ProviderPresenceStatusChangeEvent)statusEventCollector.collectedPresEvents.get(0)).getOldStatus());
        TestOperationSetPresence.assertEquals((String)"A status changed event contained wrong new status.", (Object)newStatus, (Object)((ProviderPresenceStatusChangeEvent)statusEventCollector.collectedPresEvents.get(0)).getNewStatus());
        TestOperationSetPresence.assertEquals((String)"opSet.getPresenceStatus() did not return properly.", (Object)newStatus, (Object)this.operationSetPresence2.getPresenceStatus());
        Object object = lock = new Object();
        synchronized (object) {
            logger.trace((Object)"Will wait status to be received from the other side!");
            lock.wait(5000L);
        }
        PresenceStatus actualStatus = this.operationSetPresence1.queryContactStatus(this.fixture.userID2);
        if (newStatus.getStatus() != 0) {
            TestOperationSetPresence.assertEquals((String)"The underlying implementation did not switch to the requested presence status.", (Object)newStatus, (Object)actualStatus);
        } else if (newStatus.getStatus() != 0 && newStatus.getStatus() != 1) {
            TestOperationSetPresence.fail((String)"The underlying implementation did not switch to the requested presence status.");
        }
        TestOperationSetPresence.assertEquals((String)"No status message event.", (int)1, (int)statusEventCollector.collectedStatMsgEvents.size());
        TestOperationSetPresence.assertEquals((String)"A status message event contained wrong old value.", (Object)oldStatusMessage, (Object)((PropertyChangeEvent)statusEventCollector.collectedStatMsgEvents.get(0)).getOldValue());
        TestOperationSetPresence.assertEquals((String)"A status message event contained wrong new value.", (Object)newStatusMessage, (Object)((PropertyChangeEvent)statusEventCollector.collectedStatMsgEvents.get(0)).getNewValue());
        TestOperationSetPresence.assertEquals((String)"opSet.getCurrentStatusMessage() did not return properly.", (String)newStatusMessage, (String)this.operationSetPresence2.getCurrentStatusMessage());
        logger.trace((Object)" --=== finished test ===--");
    }

    private void pauseAfterStateChanges() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            logger.debug((Object)"Pausing between state changes was interrupted", (Throwable)ex);
        }
    }

    public void disabled_testQueryContactStatus() throws Exception {
        Iterator supportedStatusSetIter = this.operationSetPresence1.getSupportedStatusSet();
        while (supportedStatusSetIter.hasNext()) {
            PresenceStatus supportedStatus = (PresenceStatus)supportedStatusSetIter.next();
            logger.trace((Object)("Will test a transition to " + supportedStatus.getStatusName()));
            this.subtestQueryContactStatus(supportedStatus);
        }
    }

    public void subtestQueryContactStatus(PresenceStatus status) throws Exception {
        this.operationSetPresence2.publishPresenceStatus(status, "status message");
        this.pauseAfterStateChanges();
        PresenceStatus actualReturn = this.operationSetPresence1.queryContactStatus(this.fixture.userID2);
        if (status.getStatus() != 0) {
            TestOperationSetPresence.assertEquals((String)("Querying a " + status.getStatusName() + " state did not return as expected"), (Object)status, (Object)actualReturn);
        } else if (actualReturn.getStatus() != 0 && actualReturn.getStatus() != 1) {
            TestOperationSetPresence.fail((String)("Querying a " + status.getStatusName() + " state did not return as expected"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTestSubscribe() throws Exception {
        Object lock;
        logger.debug((Object)"Testing Subscription and Subscription Event Dispatch.");
        this.operationSetPresence2.subscribe(this.fixture.userID1);
        SubscriptionEventCollector subEvtCollector = new SubscriptionEventCollector();
        this.operationSetPresence1.addSubscriptionListener((SubscriptionListener)subEvtCollector);
        SubscriptionEventCollector subscriptionEventCollector = subEvtCollector;
        synchronized (subscriptionEventCollector) {
            this.operationSetPresence1.subscribe(this.fixture.userID2);
            subEvtCollector.waitForEvent(10000L);
        }
        TestOperationSetPresence.assertEquals((String)"Subscription event dispatching failed.", (int)1, (int)subEvtCollector.collectedEvents.size());
        SubscriptionEvent subEvt = (SubscriptionEvent)subEvtCollector.collectedEvents.get(0);
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source:", (String)this.fixture.userID2, (String)((Contact)subEvt.getSource()).getAddress());
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source Contact:", (String)this.fixture.userID2, (String)subEvt.getSourceContact().getAddress());
        TestOperationSetPresence.assertSame((String)"SubscriptionEvent Source Provider:", (Object)this.fixture.provider1, (Object)subEvt.getSourceProvider());
        subEvtCollector.collectedEvents.clear();
        SubscriptionEventCollector subscriptionEventCollector2 = subEvtCollector;
        synchronized (subscriptionEventCollector2) {
            subEvtCollector.waitForEvent(10000L);
            this.operationSetPresence1.removeSubscriptionListener((SubscriptionListener)subEvtCollector);
        }
        subEvtCollector.collectedEvents.clear();
        Object object = lock = new Object();
        synchronized (object) {
            logger.info((Object)"Will wait all subscription events to be received");
            lock.wait(10000L);
        }
        logger.debug((Object)"Testing presence notifications.");
        PresenceStatus oldStatus = this.operationSetPresence2.getPresenceStatus();
        PresenceStatus newStatus = this.getSampleStatus1();
        if (oldStatus.equals((Object)newStatus)) {
            newStatus = this.getSampleStatus2();
        }
        logger.debug((Object)("trying to set status " + newStatus + " for contact 2"));
        ContactPresenceEventCollector contactPresEvtCollector = new ContactPresenceEventCollector(this.fixture.userID2, newStatus);
        this.operationSetPresence1.addContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        ContactPresenceEventCollector contactPresenceEventCollector = contactPresEvtCollector;
        synchronized (contactPresenceEventCollector) {
            this.operationSetPresence2.publishPresenceStatus(newStatus, "new status");
            contactPresEvtCollector.waitForEvent(10000L);
            this.operationSetPresence1.removeContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        }
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event dispatching failed.", (int)1, (int)contactPresEvtCollector.collectedEvents.size());
        ContactPresenceStatusChangeEvent presEvt = (ContactPresenceStatusChangeEvent)contactPresEvtCollector.collectedEvents.get(0);
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event  Source:", (String)this.fixture.userID2, (String)((Contact)presEvt.getSource()).getAddress());
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event  Source Contact:", (String)this.fixture.userID2, (String)presEvt.getSourceContact().getAddress());
        TestOperationSetPresence.assertSame((String)"Presence Notif. event  Source Provider:", (Object)this.fixture.provider1, (Object)presEvt.getSourceProvider());
        PresenceStatus reportedNewStatus = presEvt.getNewStatus();
        PresenceStatus reportedOldStatus = presEvt.getOldStatus();
        TestOperationSetPresence.assertEquals((String)"Reported new PresenceStatus: ", (Object)newStatus, (Object)reportedNewStatus);
        TestOperationSetPresence.assertNotNull((String)"Reported old PresenceStatus: ", (Object)reportedOldStatus);
        Object object2 = lock;
        synchronized (object2) {
            logger.info((Object)"Will wait all subscription events to be received by lib");
            lock.wait(3000L);
            logger.info((Object)"Stopped waiting");
        }
    }

    private PresenceStatus getSampleStatus1() {
        PresenceStatus mostConnectedPresenceStatus = null;
        int mostConnectedPresenceStatusInt = Integer.MIN_VALUE;
        Iterator supportedStatusSetIter = this.operationSetPresence1.getSupportedStatusSet();
        while (supportedStatusSetIter.hasNext()) {
            PresenceStatus supportedStatus = (PresenceStatus)supportedStatusSetIter.next();
            if (supportedStatus.getStatus() <= mostConnectedPresenceStatusInt) continue;
            mostConnectedPresenceStatusInt = supportedStatus.getStatus();
            mostConnectedPresenceStatus = supportedStatus;
        }
        return mostConnectedPresenceStatus;
    }

    private PresenceStatus getSampleStatus2() {
        int mostConnectedPresenceStatusInt = Integer.MIN_VALUE;
        PresenceStatus secondMostConnectedPresenceStatus = null;
        int secondMostConnectedPresenceStatusInt = Integer.MIN_VALUE;
        Iterator supportedStatusSetIter = this.operationSetPresence1.getSupportedStatusSet();
        while (supportedStatusSetIter.hasNext()) {
            PresenceStatus supportedStatus = (PresenceStatus)supportedStatusSetIter.next();
            if (supportedStatus.getStatus() > mostConnectedPresenceStatusInt) {
                mostConnectedPresenceStatusInt = supportedStatus.getStatus();
                continue;
            }
            if (supportedStatus.getStatus() <= secondMostConnectedPresenceStatusInt) continue;
            secondMostConnectedPresenceStatus = supportedStatus;
            secondMostConnectedPresenceStatusInt = supportedStatus.getStatus();
        }
        return secondMostConnectedPresenceStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTestUnsubscribe() throws Exception {
        logger.debug((Object)"Testing Unsubscribe and unsubscription event dispatch.");
        SubscriptionEventCollector subEvtCollector = new SubscriptionEventCollector();
        this.operationSetPresence1.addSubscriptionListener((SubscriptionListener)subEvtCollector);
        Contact sipTesterAgentContact = this.operationSetPresence1.findContactByID(this.fixture.userID2);
        TestOperationSetPresence.assertNotNull((String)"Failed to find an existing subscription for the tester agent", (Object)sipTesterAgentContact);
        SubscriptionEventCollector subscriptionEventCollector = subEvtCollector;
        synchronized (subscriptionEventCollector) {
            this.operationSetPresence1.unsubscribe(sipTesterAgentContact);
            subEvtCollector.waitForEvent(10000L);
            this.operationSetPresence1.removeSubscriptionListener((SubscriptionListener)subEvtCollector);
        }
        TestOperationSetPresence.assertEquals((String)"Subscription event dispatching failed.", (int)1, (int)subEvtCollector.collectedEvents.size());
        SubscriptionEvent subEvt = (SubscriptionEvent)subEvtCollector.collectedEvents.get(0);
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source:", (Object)sipTesterAgentContact, (Object)subEvt.getSource());
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source Contact:", (Object)sipTesterAgentContact, (Object)subEvt.getSourceContact());
        TestOperationSetPresence.assertSame((String)"SubscriptionEvent Source Provider:", (Object)this.fixture.provider1, (Object)subEvt.getSourceProvider());
        subEvtCollector.collectedEvents.clear();
        logger.debug((Object)"Testing (lack of) presence notifications.");
        PresenceStatus oldStatus = this.operationSetPresence2.getPresenceStatus();
        PresenceStatus newStatus = this.getSampleStatus1();
        if (oldStatus.equals((Object)newStatus)) {
            newStatus = this.getSampleStatus2();
        }
        ContactPresenceEventCollector contactPresEvtCollector = new ContactPresenceEventCollector(this.fixture.userID2, null);
        this.operationSetPresence1.addContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        ContactPresenceEventCollector contactPresenceEventCollector = contactPresEvtCollector;
        synchronized (contactPresenceEventCollector) {
            this.operationSetPresence2.publishPresenceStatus(newStatus, "new status");
            contactPresEvtCollector.waitForEvent(10000L);
            this.operationSetPresence1.removeContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        }
        TestOperationSetPresence.assertEquals((String)"Presence Notifications were received after unsubscibing.", (int)0, (int)contactPresEvtCollector.collectedEvents.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLists() throws Exception {
        Object o;
        logger.debug((Object)"Clear the two lists before tests");
        this.fixture.clearProvidersLists();
        Object object = o = new Object();
        synchronized (object) {
            o.wait(3000L);
        }
    }

    private class ContactPresenceEventCollector
    implements ContactPresenceStatusListener {
        public ArrayList<EventObject> collectedEvents = new ArrayList();
        private String trackedScreenName = null;
        private PresenceStatus status = null;

        ContactPresenceEventCollector(String screenname, PresenceStatus wantedStatus) {
            this.trackedScreenName = screenname;
            this.status = wantedStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            ContactPresenceEventCollector contactPresenceEventCollector = this;
            synchronized (contactPresenceEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
            ContactPresenceEventCollector contactPresenceEventCollector = this;
            synchronized (contactPresenceEventCollector) {
                if (this.trackedScreenName != null && !evt.getSourceContact().getAddress().equals(this.trackedScreenName)) {
                    return;
                }
                if (this.status != null && this.status != evt.getNewStatus()) {
                    return;
                }
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }
    }

    private class SubscriptionEventCollector
    implements SubscriptionListener {
        public ArrayList<EventObject> collectedEvents = new ArrayList();

        private SubscriptionEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionCreated(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionRemoved(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactModified(ContactPropertyChangeEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionMoved(SubscriptionMovedEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionFailed(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionResolved(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }
    }

    private class PresenceStatusEventCollector
    implements ProviderPresenceStatusListener {
        public ArrayList<EventObject> collectedPresEvents = new ArrayList();
        public ArrayList<EventObject> collectedStatMsgEvents = new ArrayList();

        private PresenceStatusEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedPresEvents.size() + ")= " + evt));
                this.collectedPresEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void providerStatusMessageChanged(PropertyChangeEvent evt) {
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                logger.debug((Object)("Collected stat.msg. evt(" + this.collectedPresEvents.size() + ")= " + evt));
                this.collectedStatMsgEvents.add(evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForPresEvent(long waitFor) {
            logger.trace((Object)"Waiting for a change in provider status.");
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                if (this.collectedPresEvents.size() > 0) {
                    logger.trace((Object)("Change already received. " + this.collectedPresEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedPresEvents.size() > 0) {
                        logger.trace((Object)"Received a change in provider status.");
                    } else {
                        logger.trace((Object)("No change received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a provider evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStatMsgEvent(long waitFor) {
            logger.trace((Object)"Waiting for a provider status message event.");
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                if (this.collectedStatMsgEvents.size() > 0) {
                    logger.trace((Object)("Stat msg. evt already received. " + this.collectedStatMsgEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedStatMsgEvents.size() > 0) {
                        logger.trace((Object)"Received a prov. stat. msg. evt.");
                    } else {
                        logger.trace((Object)("No prov. stat msg. received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a status msg evt", (Throwable)ex);
                }
            }
        }
    }
}

