/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.generalconfig.GeneralConfigPluginActivator;
import net.java.sip.communicator.plugin.generalconfig.Resources;
import net.java.sip.communicator.util.ConfigurationUtils;

public class SIPConfigForm
extends TransparentPanel
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private Box pnlSslProtocols;

    public SIPConfigForm() {
        super((LayoutManager)new BorderLayout());
        Box box = Box.createVerticalBox();
        this.add(box, "North");
        TransparentPanel sipClientPortConfigPanel = new TransparentPanel();
        sipClientPortConfigPanel.setLayout((LayoutManager)new BorderLayout(10, 10));
        sipClientPortConfigPanel.setPreferredSize(new Dimension(250, 50));
        box.add((Component)sipClientPortConfigPanel);
        TransparentPanel labelPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 2, 2));
        TransparentPanel valuePanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 2, 2));
        sipClientPortConfigPanel.add((Component)labelPanel, (Object)"West");
        sipClientPortConfigPanel.add((Component)valuePanel, (Object)"Center");
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.SIP_CLIENT_PORT")));
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.SIP_CLIENT_SECURE_PORT")));
        final JTextField clientPortField = new JTextField(6);
        clientPortField.setText(String.valueOf(ConfigurationUtils.getClientPort()));
        valuePanel.add((Component)clientPortField);
        clientPortField.addFocusListener(new FocusListener(){
            private String oldValue = null;

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    int port = Integer.valueOf(clientPortField.getText());
                    if (port <= 0 || port > 65535) {
                        throw new NumberFormatException("Not a port number");
                    }
                    ConfigurationUtils.setClientPort((int)port);
                }
                catch (NumberFormatException ex) {
                    String error = Resources.getString("plugin.generalconfig.ERROR_PORT_NUMBER");
                    GeneralConfigPluginActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)error, error, 0);
                    clientPortField.setText(this.oldValue);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.oldValue = clientPortField.getText();
            }
        });
        final JTextField clientSecurePortField = new JTextField(6);
        clientSecurePortField.setText(String.valueOf(ConfigurationUtils.getClientSecurePort()));
        valuePanel.add((Component)clientSecurePortField);
        clientSecurePortField.addFocusListener(new FocusListener(){
            private String oldValue = null;

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    int port = Integer.valueOf(clientSecurePortField.getText());
                    if (port <= 0 || port > 65535) {
                        throw new NumberFormatException("Not a port number");
                    }
                    ConfigurationUtils.setClientSecurePort((int)port);
                }
                catch (NumberFormatException ex) {
                    String error = Resources.getString("plugin.generalconfig.ERROR_PORT_NUMBER");
                    GeneralConfigPluginActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)error, error, 0);
                    clientSecurePortField.setText(this.oldValue);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.oldValue = clientSecurePortField.getText();
            }
        });
        String configuredProtocols = Arrays.toString(ConfigurationUtils.getEnabledSslProtocols());
        this.pnlSslProtocols = Box.createVerticalBox();
        this.pnlSslProtocols.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.generalconfig.SIP_SSL_PROTOCOLS")));
        this.pnlSslProtocols.setAlignmentX(0.0f);
        for (String protocol : ConfigurationUtils.getAvailableSslProtocols()) {
            SIPCommCheckBox chkProtocol = new SIPCommCheckBox(protocol);
            chkProtocol.addActionListener(this);
            chkProtocol.setSelected(configuredProtocols.contains(protocol));
            this.pnlSslProtocols.add((Component)chkProtocol);
        }
        this.pnlSslProtocols.add(new JLabel(Resources.getString("plugin.generalconfig.DEFAULT_LANGUAGE_RESTART_WARN")));
        TransparentPanel sslWrapper = new TransparentPanel((LayoutManager)new BorderLayout());
        sslWrapper.add((Component)this.pnlSslProtocols, "Center");
        box.add((Component)sslWrapper);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<String> enabledSslProtocols = new ArrayList<String>(this.pnlSslProtocols.getComponentCount());
        for (Component child : this.pnlSslProtocols.getComponents()) {
            if (!(child instanceof JCheckBox) || !((JCheckBox)child).isSelected()) continue;
            enabledSslProtocols.add(((JCheckBox)child).getText());
        }
        ConfigurationUtils.setEnabledSslProtocols((String[])enabledSslProtocols.toArray(new String[0]));
    }
}

