/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.muc.ChatRoomSourceContact;
import net.java.sip.communicator.impl.muc.MUCActivator;
import net.java.sip.communicator.plugin.desktoputil.chat.ChatRoomDestroyReasonDialog;
import net.java.sip.communicator.plugin.desktoputil.chat.ChatRoomJoinOptionsDialog;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.customcontactactions.ContactAction;
import net.java.sip.communicator.service.customcontactactions.ContactActionMenuItem;
import net.java.sip.communicator.service.customcontactactions.CustomContactActionsService;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import org.jitsi.service.resources.ResourceManagementService;

public class MUCCustomContactActionService
implements CustomContactActionsService<SourceContact> {
    private final List<ContactActionMenuItem<SourceContact>> mucActionMenuItems = new LinkedList<ContactActionMenuItem<SourceContact>>();
    private final List<ContactAction<SourceContact>> mucActions = new LinkedList<ContactAction<SourceContact>>();
    private static final String OWNER_CANT_REMOVE_CHATROOM_PROPERTY = "net.java.sip.communicator.impl.muc.OWNER_CANT_REMOVE_CHATROOM";
    private String[] actionsNames = new String[]{"leave", "join", "autojoin", "autojoin_pressed", "destroy_chatroom"};
    private String[] actionsLabels = new String[]{"service.gui.LEAVE", "service.gui.JOIN", "service.gui.JOIN_AUTOMATICALLY", "service.gui.JOIN_AUTOMATICALLY", "service.gui.DESTROY_CHATROOM"};
    private String[] actionsIcons = new String[]{"service.gui.icons.LEAVE_ICON_BUTTON", "service.gui.icons.JOIN_ICON_BUTTON", "service.gui.icons.AUTOJOIN_ON_ICON_BUTTON", "service.gui.icons.AUTOJOIN_OFF_ICON_BUTTON", "service.gui.icons.DESTROY_ICON_BUTTON"};
    private String[] actionsIconsRollover = new String[]{"service.gui.icons.LEAVE_ICON_ROLLOVER_BUTTON", "service.gui.icons.JOIN_ICON_ROLLOVER_BUTTON", "service.gui.icons.AUTOJOIN_ON_ICON_ROLLOVER_BUTTON", "service.gui.icons.AUTOJOIN_OFF_ICON_ROLLOVER_BUTTON", "service.gui.icons.DESTROY_ICON_ROLLOVER_BUTTON"};
    private String[] actionsIconsPressed = new String[]{"service.gui.icons.LEAVE_ICON_PRESSED_BUTTON", "service.gui.icons.JOIN_ICON_PRESSED_BUTTON", "service.gui.icons.AUTOJOIN_ON_ICON_PRESSED_BUTTON", "service.gui.icons.AUTOJOIN_OFF_ICON_PRESSED_BUTTON", "service.gui.icons.DESTROY_ICON_PRESSED_BUTTON"};
    private String[] menuActionsNames = new String[]{"open", "join", "join_as", "leave", "remove", "change_nick", "autojoin", "autojoin_pressed", "open_automatically", "destroy_chatroom"};
    private String[] menuActionsLabels = new String[]{"service.gui.OPEN", "service.gui.JOIN", "service.gui.JOIN_AS", "service.gui.LEAVE", "service.gui.REMOVE", "service.gui.CHANGE_NICK", "service.gui.JOIN_AUTOMATICALLY", "service.gui.DONT_JOIN_AUTOMATICALLY", "service.gui.OPEN_AUTOMATICALLY", "service.gui.DESTROY_CHATROOM"};
    private String[] menuActionsIcons = new String[]{"service.gui.icons.CHAT_ROOM_16x16_ICON", "service.gui.icons.JOIN_ICON", "service.gui.icons.JOIN_AS_ICON", "service.gui.icons.LEAVE_ICON", "service.gui.icons.REMOVE_CHAT_ICON", "service.gui.icons.RENAME_16x16_ICON", "service.gui.icons.AUTOJOIN", "service.gui.icons.AUTOJOIN", "service.gui.icons.OPEN_AUTOMATICALLY", "service.gui.icons.DESTROY_CHATROOM"};
    private MUCCustomActionRunnable leaveRunnable = new MUCCustomActionRunnable(){

        @Override
        public void run() {
            ChatRoomWrapper leavedRoomWrapped = MUCActivator.getMUCService().leaveChatRoom(this.chatRoomWrapper);
            if (leavedRoomWrapped != null) {
                MUCActivator.getUIService().closeChatRoomWindow(leavedRoomWrapped);
            }
        }
    };
    private MUCCustomActionRunnable joinRunnable = new MUCCustomActionRunnable(){

        @Override
        public void run() {
            String subject = null;
            String nickName = null;
            nickName = ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)this.chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)this.chatRoomWrapper.getChatRoomID(), (String)"userNickName");
            if (nickName == null) {
                String[] joinOptions = ChatRoomJoinOptionsDialog.getJoinOptions((ProtocolProviderService)this.chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)this.chatRoomWrapper.getChatRoomID(), (String)MUCActivator.getGlobalDisplayDetailsService().getDisplayName(this.chatRoomWrapper.getParentProvider().getProtocolProvider()));
                nickName = joinOptions[0];
                subject = joinOptions[1];
            }
            if (nickName != null) {
                MUCActivator.getMUCService().joinChatRoom(this.chatRoomWrapper, nickName, null, subject);
            }
        }
    };
    private MUCCustomActionRunnable autoJoinRunnable = new MUCCustomActionRunnable(){

        @Override
        public void run() {
            this.chatRoomWrapper.setAutoJoin(!this.chatRoomWrapper.isAutojoin());
        }
    };
    private MUCCustomActionRunnable destroyActionRunnable = new MUCCustomActionRunnable(){

        @Override
        public void run() {
            String[] destroyOptions = ChatRoomDestroyReasonDialog.getDestroyOptions();
            if (destroyOptions == null) {
                return;
            }
            MUCActivator.getMUCService().destroyChatRoom(this.chatRoomWrapper, destroyOptions[0], destroyOptions[1]);
        }
    };
    private MUCCustomActionRunnable[] actionsRunnable = new MUCCustomActionRunnable[]{this.leaveRunnable, this.joinRunnable, this.autoJoinRunnable, this.autoJoinRunnable, this.destroyActionRunnable};
    private MUCCustomActionRunnable[] menuActionsRunnable = new MUCCustomActionRunnable[]{new MUCCustomActionRunnable(){

        @Override
        public void run() {
            MUCActivator.getMUCService().openChatRoom(this.chatRoomWrapper);
        }
    }, this.joinRunnable, new MUCCustomActionRunnable(){

        @Override
        public void run() {
            String[] joinOptions = ChatRoomJoinOptionsDialog.getJoinOptions((ProtocolProviderService)this.chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)this.chatRoomWrapper.getChatRoomID(), (String)MUCActivator.getGlobalDisplayDetailsService().getDisplayName(this.chatRoomWrapper.getParentProvider().getProtocolProvider()));
            if (joinOptions[0] == null) {
                return;
            }
            MUCActivator.getMUCService().joinChatRoom(this.chatRoomWrapper, joinOptions[0], null, joinOptions[1]);
        }
    }, this.leaveRunnable, new MUCCustomActionRunnable(){

        @Override
        public void run() {
            ChatRoomWrapper leavedRoomWrapped;
            ChatRoom chatRoom = this.chatRoomWrapper.getChatRoom();
            if (chatRoom != null && (leavedRoomWrapped = MUCActivator.getMUCService().leaveChatRoom(this.chatRoomWrapper)) != null) {
                MUCActivator.getUIService().closeChatRoomWindow(leavedRoomWrapped);
            }
            MUCActivator.getUIService().closeChatRoomWindow(this.chatRoomWrapper);
            MUCActivator.getMUCService().removeChatRoom(this.chatRoomWrapper);
        }
    }, new MUCCustomActionRunnable(){

        @Override
        public void run() {
            ChatRoomJoinOptionsDialog.getJoinOptions((boolean)true, (ProtocolProviderService)this.chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)this.chatRoomWrapper.getChatRoomID(), (String)MUCActivator.getGlobalDisplayDetailsService().getDisplayName(this.chatRoomWrapper.getParentProvider().getProtocolProvider()));
        }
    }, this.autoJoinRunnable, this.autoJoinRunnable, new MUCCustomActionRunnable(){

        @Override
        public void run() {
            MUCActivator.getUIService().showChatRoomAutoOpenConfigDialog(this.chatRoomWrapper.getParentProvider().getProtocolProvider(), this.chatRoomWrapper.getChatRoomID());
        }
    }, this.destroyActionRunnable};
    private EnableChecker[] actionsEnabledCheckers = new EnableChecker[]{null, new JoinEnableChecker(), new JoinEnableChecker(), new LeaveEnableChecker(), null, null, null, null, null, null};
    ResourceManagementService resources = MUCActivator.getResources();

    public MUCCustomContactActionService() {
        Object item;
        int i;
        for (i = 0; i < this.menuActionsLabels.length; ++i) {
            item = new MUCActionMenuItems(this.menuActionsNames[i], this.menuActionsLabels[i], this.menuActionsIcons[i], this.menuActionsRunnable[i]);
            this.mucActionMenuItems.add((ContactActionMenuItem<SourceContact>)item);
            if (this.actionsEnabledCheckers[i] == null) continue;
            ((MUCActionMenuItems)item).setEnabled(this.actionsEnabledCheckers[i]);
        }
        for (i = 0; i < this.actionsLabels.length; ++i) {
            item = new MUCAction(this.actionsNames[i], this.actionsLabels[i], this.actionsIcons[i], this.actionsIconsRollover[i], this.actionsIconsPressed[i], this.actionsRunnable[i]);
            this.mucActions.add((ContactAction<SourceContact>)item);
        }
    }

    public Class<SourceContact> getContactSourceClass() {
        return SourceContact.class;
    }

    public Iterator<ContactActionMenuItem<SourceContact>> getCustomContactActionsMenuItems() {
        return this.mucActionMenuItems.iterator();
    }

    public Iterator<ContactAction<SourceContact>> getCustomContactActions() {
        return this.mucActions.iterator();
    }

    private abstract class MUCCustomActionRunnable
    implements Runnable {
        protected SourceContact contact;
        protected ChatRoomWrapper chatRoomWrapper;

        private MUCCustomActionRunnable() {
        }

        public void setContact(SourceContact contact) {
            this.contact = contact;
            this.chatRoomWrapper = MUCActivator.getMUCService().findChatRoomWrapperFromSourceContact(contact);
        }
    }

    private static class LeaveEnableChecker
    extends JoinEnableChecker {
        private LeaveEnableChecker() {
        }

        @Override
        public boolean check(SourceContact contact) {
            return !super.check(contact);
        }
    }

    private static class JoinEnableChecker
    extends EnableChecker {
        private JoinEnableChecker() {
        }

        @Override
        public boolean check(SourceContact contact) {
            ChatRoomWrapper chatRoomWrapper = MUCActivator.getMUCService().findChatRoomWrapperFromSourceContact(contact);
            ChatRoom chatRoom = null;
            if (chatRoomWrapper != null) {
                chatRoom = chatRoomWrapper.getChatRoom();
            }
            return chatRoom == null || !chatRoom.isJoined();
        }
    }

    private static class EnableChecker {
        private EnableChecker() {
        }

        public boolean check(SourceContact contact) {
            return true;
        }
    }

    private class MUCActionMenuItems
    implements ContactActionMenuItem<SourceContact> {
        private String text;
        private byte[] image;
        private MUCCustomActionRunnable actionPerformed;
        private EnableChecker enabled;
        private String name;
        private char mnemonics;

        public MUCActionMenuItems(String name, String textKey, String imageKey, MUCCustomActionRunnable actionPerformed) {
            this.text = MUCCustomContactActionService.this.resources.getI18NString(textKey);
            this.image = imageKey == null ? null : MUCCustomContactActionService.this.resources.getImageInBytes(imageKey);
            this.actionPerformed = actionPerformed;
            this.enabled = new EnableChecker();
            this.name = name;
            this.mnemonics = MUCCustomContactActionService.this.resources.getI18nMnemonic(textKey);
        }

        public void actionPerformed(SourceContact actionSource) throws OperationFailedException {
            if (!(actionSource instanceof ChatRoomSourceContact)) {
                return;
            }
            this.actionPerformed.setContact(actionSource);
            new Thread(this.actionPerformed).start();
        }

        public byte[] getIcon() {
            return this.image;
        }

        public String getText(SourceContact actionSource) {
            if (!(actionSource instanceof ChatRoomSourceContact)) {
                return "";
            }
            if (!this.name.equals("open_automatically")) {
                return this.text;
            }
            String openAutomaticallyValue = MUCService.getChatRoomAutoOpenOption(((ChatRoomSourceContact)actionSource).getProvider(), ((ChatRoomSourceContact)actionSource).getChatRoomID());
            if (openAutomaticallyValue == null) {
                openAutomaticallyValue = MUCService.DEFAULT_AUTO_OPEN_BEHAVIOUR;
            }
            String openAutomaticallyKey = MUCService.autoOpenConfigValuesTexts.get(openAutomaticallyValue);
            return "<html>" + this.text + "...<br><font size=\"2\"><center> (" + MUCCustomContactActionService.this.resources.getI18NString(openAutomaticallyKey) + ")</center></font></html>";
        }

        public boolean isVisible(SourceContact actionSource) {
            if (!(actionSource instanceof ChatRoomSourceContact)) {
                return false;
            }
            ChatRoomSourceContact contact = (ChatRoomSourceContact)actionSource;
            ChatRoomWrapper room = MUCActivator.getMUCService().findChatRoomWrapperFromSourceContact((SourceContact)contact);
            if (this.name.equals("autojoin") || this.name.equals("autojoin_pressed")) {
                if (room == null) {
                    return true;
                }
                if (this.name.equals("autojoin")) {
                    return !room.isAutojoin();
                }
                if (this.name.equals("autojoin_pressed")) {
                    return room.isAutojoin();
                }
            } else {
                if (this.name.equals("remove")) {
                    if (room == null || room.getChatRoom() == null) {
                        return true;
                    }
                    boolean ownerCannotRemoveRoom = MUCActivator.getConfigurationService().getBoolean(MUCCustomContactActionService.OWNER_CANT_REMOVE_CHATROOM_PROPERTY, false);
                    if (room.getChatRoom().getUserRole().equals((Object)ChatRoomMemberRole.MEMBER)) {
                        return true;
                    }
                    return !ownerCannotRemoveRoom;
                }
                if (this.name.equals("destroy_chatroom")) {
                    if (room == null || room.getChatRoom() == null) {
                        return false;
                    }
                    return room.getChatRoom().getUserRole().equals((Object)ChatRoomMemberRole.OWNER);
                }
            }
            return true;
        }

        public char getMnemonics() {
            return this.mnemonics;
        }

        public boolean isEnabled(SourceContact actionSource) {
            return this.enabled.check(actionSource);
        }

        public void setEnabled(EnableChecker enabled) {
            this.enabled = enabled;
        }

        public boolean isCheckBox() {
            return false;
        }

        public boolean isSelected(SourceContact contact) {
            ChatRoomWrapper chatRoomWrapper = MUCActivator.getMUCService().findChatRoomWrapperFromSourceContact(contact);
            if (chatRoomWrapper == null) {
                return false;
            }
            return chatRoomWrapper.isAutojoin();
        }
    }

    private class MUCAction
    implements ContactAction<SourceContact> {
        private String text;
        private byte[] icon;
        private byte[] iconPressed;
        private MUCCustomActionRunnable actionPerformed;
        private byte[] iconRollover;
        private String name;

        public MUCAction(String name, String textKey, String iconKey, String iconRolloverKey, String iconPressedKey, MUCCustomActionRunnable actionPerformed) {
            this.name = name;
            this.text = MUCCustomContactActionService.this.resources.getI18NString(textKey);
            this.icon = MUCCustomContactActionService.this.resources.getImageInBytes(iconKey);
            this.iconRollover = MUCCustomContactActionService.this.resources.getImageInBytes(iconRolloverKey);
            this.iconPressed = MUCCustomContactActionService.this.resources.getImageInBytes(iconPressedKey);
            this.actionPerformed = actionPerformed;
        }

        public void actionPerformed(SourceContact actionSource, int x, int y) throws OperationFailedException {
            if (!(actionSource instanceof ChatRoomSourceContact)) {
                return;
            }
            this.actionPerformed.setContact(actionSource);
            new Thread(this.actionPerformed).start();
        }

        public byte[] getIcon() {
            return this.icon;
        }

        public byte[] getRolloverIcon() {
            return this.iconRollover;
        }

        public byte[] getPressedIcon() {
            return this.iconPressed;
        }

        public String getToolTipText() {
            return this.text;
        }

        public boolean isVisible(SourceContact actionSource) {
            if (actionSource instanceof ChatRoomSourceContact) {
                if (this.name.equals("leave")) {
                    return MUCCustomContactActionService.this.actionsEnabledCheckers[3].check(actionSource);
                }
                if (this.name.equals("join")) {
                    return MUCCustomContactActionService.this.actionsEnabledCheckers[1].check(actionSource);
                }
                if (this.name.equals("destroy_chatroom")) {
                    ChatRoomSourceContact contact = (ChatRoomSourceContact)actionSource;
                    ChatRoomWrapper room = MUCActivator.getMUCService().findChatRoomWrapperFromSourceContact((SourceContact)contact);
                    if (room == null || room.getChatRoom() == null) {
                        return false;
                    }
                    return room.getChatRoom().getUserRole().equals((Object)ChatRoomMemberRole.OWNER);
                }
                ChatRoomSourceContact contact = (ChatRoomSourceContact)actionSource;
                ChatRoomWrapper room = MUCActivator.getMUCService().findChatRoomWrapperFromSourceContact((SourceContact)contact);
                if (room == null) {
                    return false;
                }
                if (this.name.equals("autojoin")) {
                    return room.isAutojoin();
                }
                if (this.name.equals("autojoin_pressed")) {
                    return !room.isAutojoin();
                }
            }
            return false;
        }
    }
}

