/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class MockContactGroup
implements ContactGroup {
    private String groupName = null;
    private final List<Contact> contacts = new Vector<Contact>();
    private final List<ContactGroup> subGroups = new Vector<ContactGroup>();
    private MockContactGroup parentGroup = null;
    private boolean isPersistent = true;
    private MockProvider parentProvider = null;
    private boolean isResolved = true;
    private String uid = null;
    private static final String UID_SUFFIX = ".uid";

    public MockContactGroup(String groupName, MockProvider parentProvider) {
        this.groupName = groupName;
        this.uid = groupName + UID_SUFFIX;
        this.parentProvider = parentProvider;
    }

    public boolean canContainSubgroups() {
        return true;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.parentProvider;
    }

    public Iterator<Contact> contacts() {
        return this.contacts.iterator();
    }

    public void addContact(MockContact contactToAdd) {
        this.contacts.add((Contact)contactToAdd);
        contactToAdd.setParentGroup(this);
    }

    public int countContacts() {
        return this.contacts.size();
    }

    public int countSubgroups() {
        return this.subGroups.size();
    }

    public void addSubgroup(MockContactGroup subgroup) {
        this.subGroups.add(subgroup);
        subgroup.setParentGroup(this);
    }

    void setParentGroup(MockContactGroup parent) {
        this.parentGroup = parent;
    }

    public ContactGroup getParentContactGroup() {
        return this.parentGroup;
    }

    public void removeSubGroup(MockContactGroup subgroup) {
        this.subGroups.remove(subgroup);
        subgroup.setParentGroup(null);
    }

    public MockContactGroup findGroupParent(MockContactGroup mockGroup) {
        if (this.subGroups.contains(mockGroup)) {
            return this;
        }
        Iterator<ContactGroup> subGroupsIter = this.subgroups();
        while (subGroupsIter.hasNext()) {
            MockContactGroup subgroup = (MockContactGroup)subGroupsIter.next();
            MockContactGroup parent = subgroup.findGroupParent(mockGroup);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public MockContactGroup findContactParent(MockContact mockContact) {
        if (this.contacts.contains((Object)mockContact)) {
            return this;
        }
        Iterator<ContactGroup> subGroupsIter = this.subgroups();
        while (subGroupsIter.hasNext()) {
            MockContactGroup subgroup = (MockContactGroup)subGroupsIter.next();
            MockContactGroup parent = subgroup.findContactParent(mockContact);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public Contact getContact(String id) {
        Iterator<Contact> contactsIter = this.contacts();
        while (contactsIter.hasNext()) {
            Contact contact = contactsIter.next();
            if (!contact.getAddress().equals(id)) continue;
            return contact;
        }
        return null;
    }

    public ContactGroup getGroup(int index) {
        return this.subGroups.get(index);
    }

    public ContactGroup getGroup(String groupName) {
        Iterator<ContactGroup> groupsIter = this.subgroups();
        while (groupsIter.hasNext()) {
            ContactGroup contactGroup = groupsIter.next();
            if (!contactGroup.getGroupName().equals(groupName)) continue;
            return contactGroup;
        }
        return null;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String newGrpName) {
        this.groupName = newGrpName;
    }

    public Iterator<ContactGroup> subgroups() {
        return this.subGroups.iterator();
    }

    public void removeContact(MockContact contact) {
        this.contacts.remove((Object)contact);
    }

    public MockContact findContactByID(String id) {
        Iterator<Contact> contactsIter = this.contacts();
        while (contactsIter.hasNext()) {
            MockContact mContact = (MockContact)contactsIter.next();
            if (!mContact.getAddress().equals(id)) continue;
            return mContact;
        }
        Iterator<ContactGroup> groupsIter = this.subgroups();
        while (groupsIter.hasNext()) {
            MockContactGroup mGroup = (MockContactGroup)groupsIter.next();
            MockContact mContact = mGroup.findContactByID(id);
            if (mContact == null) continue;
            return mContact;
        }
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.getGroupName());
        buff.append(".subGroups=" + this.countSubgroups() + ":\n");
        Iterator<ContactGroup> subGroups = this.subgroups();
        while (subGroups.hasNext()) {
            ContactGroup group = subGroups.next();
            buff.append(group.toString());
            if (!subGroups.hasNext()) continue;
            buff.append("\n");
        }
        buff.append("\nChildContacts=" + this.countContacts() + ":[");
        Iterator<Contact> contacts = this.contacts();
        while (contacts.hasNext()) {
            Contact contact = contacts.next();
            buff.append(contact.toString());
            if (!contacts.hasNext()) continue;
            buff.append(", ");
        }
        return buff.append("]").toString();
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public String getPersistentData() {
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setResolved(boolean resolved) {
        this.isResolved = resolved;
    }

    public String getUID() {
        return this.uid;
    }

    static String createNameFromUID(String uid) {
        return uid.substring(0, uid.length() - UID_SUFFIX.length());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MockContactGroup)) {
            return false;
        }
        MockContactGroup mockGroup = (MockContactGroup)obj;
        if (!mockGroup.getGroupName().equals(this.getGroupName()) || !mockGroup.getUID().equals(this.getUID()) || mockGroup.countContacts() != this.countContacts() || mockGroup.countSubgroups() != this.countSubgroups()) {
            return false;
        }
        Iterator<Contact> theirContacts = mockGroup.contacts();
        while (theirContacts.hasNext()) {
            MockContact theirContact = (MockContact)theirContacts.next();
            MockContact ourContact = (MockContact)this.getContact(theirContact.getAddress());
            if (ourContact != null && ourContact.equals((Object)theirContact)) continue;
            return false;
        }
        Iterator<ContactGroup> theirSubgroups = mockGroup.subgroups();
        while (theirSubgroups.hasNext()) {
            MockContactGroup theirSubgroup = (MockContactGroup)theirSubgroups.next();
            MockContactGroup ourSubgroup = (MockContactGroup)this.getGroup(theirSubgroup.getGroupName());
            if (ourSubgroup != null && ourSubgroup.equals(theirSubgroup)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(this.getGroupName());
        objects.add(this.getUID());
        objects.add(this.countContacts());
        objects.add(this.countSubgroups());
        for (Contact c : this.contacts) {
            objects.add(c.getAddress());
        }
        for (ContactGroup g : this.subGroups) {
            objects.add(g.getGroupName());
        }
        return Objects.hash(objects.toArray());
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }
}

