/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.mock.MockAccountID;
import net.java.sip.communicator.impl.protocol.mock.MockBasicInstantMessaging;
import net.java.sip.communicator.impl.protocol.mock.MockMultiUserChat;
import net.java.sip.communicator.impl.protocol.mock.MockOperationSetBasicTelephony;
import net.java.sip.communicator.impl.protocol.mock.MockOperationSetFileTransfer;
import net.java.sip.communicator.impl.protocol.mock.MockPersistentPresenceOperationSet;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;

public class MockProvider
implements ProtocolProviderService {
    private static final String PROTO_NAME = "TheSipCommMockProtocol";
    private final Map<String, OperationSet> supportedOperationSets = new Hashtable<String, OperationSet>();
    private MockPersistentPresenceOperationSet mockPresOpSet = null;
    private AccountID accountID = null;

    public MockProvider(String userName) {
        this.accountID = new MockAccountID(userName);
        this.mockPresOpSet = new MockPersistentPresenceOperationSet(this);
        MockBasicInstantMessaging mockBImOpSet = new MockBasicInstantMessaging(this, this.mockPresOpSet);
        this.supportedOperationSets.put(OperationSetPersistentPresence.class.getName(), (OperationSet)this.mockPresOpSet);
        this.supportedOperationSets.put(OperationSetPresence.class.getName(), (OperationSet)this.mockPresOpSet);
        this.supportedOperationSets.put(OperationSetBasicInstantMessaging.class.getName(), (OperationSet)mockBImOpSet);
        this.supportedOperationSets.put(OperationSetMultiUserChat.class.getName(), (OperationSet)new MockMultiUserChat(this));
        MockOperationSetBasicTelephony mockTelphonyOpSet = new MockOperationSetBasicTelephony(this);
        this.supportedOperationSets.put(OperationSetBasicTelephony.class.getName(), (OperationSet)mockTelphonyOpSet);
        MockOperationSetFileTransfer mockFileTransferOpSet = new MockOperationSetFileTransfer(this);
        this.supportedOperationSets.put(OperationSetFileTransfer.class.getName(), (OperationSet)mockFileTransferOpSet);
    }

    public void addRegistrationStateChangeListener(RegistrationStateChangeListener listener) {
    }

    public String getProtocolName() {
        return PROTO_NAME;
    }

    public String getProtocolDisplayName() {
        return PROTO_NAME;
    }

    public RegistrationState getRegistrationState() {
        return RegistrationState.REGISTERED;
    }

    public Map<String, OperationSet> getSupportedOperationSets() {
        return this.supportedOperationSets;
    }

    public Collection<Class<? extends OperationSet>> getSupportedOperationSetClasses() {
        ArrayList<Class<? extends OperationSet>> opSetClasses = new ArrayList<Class<? extends OperationSet>>();
        for (String opSetClassName : this.getSupportedOperationSets().keySet()) {
            try {
                opSetClasses.add(this.getSupportedOperationSets().get(opSetClassName).getClass().getClassLoader().loadClass(opSetClassName));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return opSetClasses;
    }

    public <T extends OperationSet> T getOperationSet(Class<T> opsetClass) {
        return (T)this.getSupportedOperationSets().get(opsetClass.getName());
    }

    public boolean isRegistered() {
        return true;
    }

    public void register(SecurityAuthority authority) {
    }

    public void removeRegistrationStateChangeListener(RegistrationStateChangeListener listener) {
    }

    public void shutdown() {
    }

    public void unregister() {
    }

    public void unregister(boolean userRequest) throws OperationFailedException {
        this.unregister();
    }

    public boolean isSignalingTransportSecure() {
        return false;
    }

    public TransportProtocol getTransportProtocol() {
        return TransportProtocol.UNKNOWN;
    }

    public AccountID getAccountID() {
        return this.accountID;
    }

    public boolean validateContactAddress(String contactId, List<String> result) {
        return true;
    }

    public ProtocolIcon getProtocolIcon() {
        return null;
    }

    public boolean isRegistrationRequiredForCalling() {
        return false;
    }
}

