/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import com.ircclouds.irc.api.IRCApi;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.plugin.irccommands.command.Msg;
import org.easymock.EasyMock;

public class MsgTest
extends TestCase {
    public void testGoodInit() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{connection});
        new Msg(null, connection);
    }

    public void testBadInit() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        EasyMock.replay((Object[])new Object[]{provider});
        try {
            new Msg(provider, null);
            Assert.fail((String)"Should not reach this, expected IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMessageNoNickNoMsg() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Msg msg = new Msg(provider, connection);
        try {
            msg.execute("#test", "/msg");
            Assert.fail((String)"Should have thrown IAE for missing target and message.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMessageZeroLengthMsg() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Msg msg = new Msg(provider, connection);
        try {
            msg.execute("#test", "/msg ");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMessageZeroLengthNickMsg() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Msg msg = new Msg(provider, connection);
        try {
            msg.execute("#test", "/msg  ");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMessageNickZeroLengthMsg() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Msg msg = new Msg(provider, connection);
        try {
            msg.execute("#test", "/msg target ");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPrivateMessage() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        IRCApi client = (IRCApi)EasyMock.createMock(IRCApi.class);
        EasyMock.expect((Object)connection.getClient()).andReturn((Object)client);
        client.message((String)EasyMock.eq((Object)"target"), (String)EasyMock.eq((Object)"This is my target message."));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Msg msg = new Msg(provider, connection);
        msg.execute("#test", "/msg target This is my target message.");
    }
}

