/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.jdic;

import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.accessibility.Accessible;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;
import net.java.sip.communicator.impl.osdependent.OsDependentActivator;
import net.java.sip.communicator.impl.osdependent.Resources;
import net.java.sip.communicator.impl.osdependent.jdic.StatusSubMenu;
import net.java.sip.communicator.impl.osdependent.jdic.SystrayServiceJdicImpl;
import net.java.sip.communicator.service.gui.ExportedWindow;
import org.apache.commons.lang3.tuple.Pair;
import org.jitsi.util.OSUtils;

public final class TrayMenuFactory {
    private static void actionPerformed(ActionEvent evt) {
        String itemName;
        Accessible menuItem;
        Object source = evt.getSource();
        if (source instanceof JMenuItem) {
            menuItem = (JMenuItem)source;
            itemName = ((Component)((Object)menuItem)).getName();
        } else {
            menuItem = (MenuItem)source;
            itemName = ((MenuComponent)((Object)menuItem)).getName();
        }
        if (itemName.equals("settings")) {
            OsDependentActivator.getUIService().getConfigurationContainer().setVisible(true);
        } else if (itemName.equals("service.gui.QUIT")) {
            OsDependentActivator.getShutdownService().beginShutdown();
        } else if (itemName.equals("addContact")) {
            ExportedWindow dialog = OsDependentActivator.getUIService().getExportedWindow(ExportedWindow.ADD_CONTACT_WINDOW);
            if (dialog != null) {
                dialog.setVisible(true);
            } else {
                OsDependentActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)Resources.getString("impl.systray.FAILED_TO_OPEN_ADD_CONTACT_DIALOG"));
            }
        } else if (itemName.equals("service.gui.SHOW")) {
            OsDependentActivator.getUIService().setVisible(true);
            OsDependentActivator.getUIService().bringToFront();
            TrayMenuFactory.changeTrayMenuItem(source, "service.gui.HIDE", "service.gui.HIDE", "service.gui.icons.SEARCH_ICON_16x16");
        } else if (itemName.equals("service.gui.HIDE")) {
            OsDependentActivator.getUIService().setVisible(false);
            TrayMenuFactory.changeTrayMenuItem(source, "service.gui.SHOW", "service.gui.SHOW", "service.gui.icons.SEARCH_ICON_16x16");
        }
    }

    private static void add(Object trayMenu, Object trayMenuItem) {
        if (trayMenu instanceof JPopupMenu) {
            ((JPopupMenu)trayMenu).add((JMenuItem)trayMenuItem);
        } else {
            ((PopupMenu)trayMenu).add((MenuItem)trayMenuItem);
        }
    }

    public static void addPopupMenuListener(Object trayMenu, PopupMenuListener listener) {
        if (trayMenu instanceof JPopupMenu) {
            ((JPopupMenu)trayMenu).addPopupMenuListener(listener);
        }
    }

    private static void addSeparator(Object trayMenu) {
        if (trayMenu instanceof JPopupMenu) {
            ((JPopupMenu)trayMenu).addSeparator();
        } else {
            ((PopupMenu)trayMenu).addSeparator();
        }
    }

    public static Pair<Object, Object> createTrayMenu(SystrayServiceJdicImpl tray, boolean swing, boolean accountMenuSupported) {
        String showHideIconId;
        String showHideTextId;
        String showHideName;
        Accessible trayMenu = swing ? new JPopupMenu() : new PopupMenu();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TrayMenuFactory.actionPerformed(event);
            }
        };
        Boolean showOptions = OsDependentActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.gui.main.configforms.SHOW_OPTIONS_WINDOW", true);
        if (showOptions.booleanValue()) {
            TrayMenuFactory.add(trayMenu, TrayMenuFactory.createTrayMenuItem("settings", OSUtils.IS_MAC ? "service.gui.PREFERENCES" : "service.gui.SETTINGS", "service.systray.CONFIGURE_ICON", listener, swing));
        }
        TrayMenuFactory.add(trayMenu, TrayMenuFactory.createTrayMenuItem("addContact", "service.gui.ADD_CONTACT", "service.gui.icons.ADD_CONTACT_16x16_ICON", listener, swing));
        TrayMenuFactory.addSeparator(trayMenu);
        Boolean chatPresenceDisabled = OsDependentActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.gui.main.presence.CHAT_PRESENCE_DISABLED", false);
        if (!chatPresenceDisabled.booleanValue() && accountMenuSupported) {
            TrayMenuFactory.add(trayMenu, new StatusSubMenu(swing, accountMenuSupported).getMenu());
            TrayMenuFactory.addSeparator(trayMenu);
        }
        if (OsDependentActivator.getUIService().isVisible()) {
            showHideName = "service.gui.HIDE";
            showHideTextId = "service.gui.HIDE";
            showHideIconId = "service.gui.icons.SEARCH_ICON_16x16";
        } else {
            showHideName = "service.gui.SHOW";
            showHideTextId = "service.gui.SHOW";
            showHideIconId = "service.gui.icons.SEARCH_ICON_16x16";
        }
        final Object showHideMenuItem = TrayMenuFactory.createTrayMenuItem(showHideName, showHideTextId, showHideIconId, listener, swing);
        TrayMenuFactory.add(trayMenu, showHideMenuItem);
        TrayMenuFactory.add(trayMenu, TrayMenuFactory.createTrayMenuItem("service.gui.QUIT", "service.gui.QUIT", "service.systray.QUIT_MENU_ICON", listener, swing));
        OsDependentActivator.getUIService().addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                TrayMenuFactory.changeTrayMenuItem(showHideMenuItem, "service.gui.HIDE", "service.gui.HIDE", "service.gui.icons.SEARCH_ICON_16x16");
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                TrayMenuFactory.changeTrayMenuItem(showHideMenuItem, "service.gui.SHOW", "service.gui.SHOW", "service.gui.icons.SEARCH_ICON_16x16");
            }
        });
        return Pair.of((Object)trayMenu, (Object)showHideMenuItem);
    }

    private static Object createTrayMenuItem(String name, String textID, String iconID, ActionListener listener, boolean swing) {
        Accessible trayMenuItem;
        String text = Resources.getString(textID);
        if (swing) {
            JMenuItem menuItem = new JMenuItem(text, Resources.getImage(iconID));
            menuItem.setName(name);
            menuItem.addActionListener(listener);
            trayMenuItem = menuItem;
        } else {
            MenuItem menuItem = new MenuItem(text);
            menuItem.setName(name);
            menuItem.addActionListener(listener);
            trayMenuItem = menuItem;
        }
        return trayMenuItem;
    }

    private static void changeTrayMenuItem(Object trayItem, String name, String textID, String iconID) {
        String text = Resources.getString(textID);
        if (trayItem instanceof JMenuItem) {
            JMenuItem jmenuItem = (JMenuItem)trayItem;
            jmenuItem.setName(name);
            jmenuItem.setText(text);
            jmenuItem.setIcon(Resources.getImage(iconID));
        } else if (trayItem instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)trayItem;
            menuItem.setName(name);
            menuItem.setLabel(text);
        }
    }

    public static boolean isVisible(Object trayMenu) {
        if (trayMenu instanceof JPopupMenu) {
            return ((JPopupMenu)trayMenu).isVisible();
        }
        return false;
    }
}

